/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class MissingDeprecatedAnnotationInspection
extends BaseInspection {
    public boolean warnOnMissingJavadoc = false;

    MissingDeprecatedAnnotationInspection() {
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean annotationWarning = (Boolean)infos[0];
        return annotationWarning ? InspectionGadgetsBundle.message("missing.deprecated.annotation.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("missing.deprecated.tag.problem.descriptor", new Object[0]);
    }

    @NotNull
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("missing.deprecated.tag.option", new Object[0]), (InspectionProfileEntry)this, "warnOnMissingJavadoc");
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean annotationWarning = (Boolean)infos[0];
        return annotationWarning ? new MissingDeprecatedAnnotationFix() : new MissingDeprecatedTagFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MissingDeprecatedAnnotationVisitor();
    }

    private class MissingDeprecatedAnnotationVisitor
    extends BaseInspectionVisitor {
        private MissingDeprecatedAnnotationVisitor() {
        }

        public void visitModule(@NotNull PsiJavaModule module) {
            super.visitModule(module);
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)module)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiJavaDocumentedElement)module, true)) {
                    this.registerModuleError(module, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiJavaDocumentedElement)module, false)) {
                this.registerModuleError(module, Boolean.TRUE);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            super.visitClass(aClass);
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)aClass)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiJavaDocumentedElement)aClass, true)) {
                    this.registerClassError(aClass, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiJavaDocumentedElement)aClass, false)) {
                this.registerClassError(aClass, Boolean.TRUE);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)method)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc) {
                    PsiMethod m = method;
                    while (m != null) {
                        if (this.hasDeprecatedComment((PsiJavaDocumentedElement)m, true)) {
                            return;
                        }
                        m = MethodUtils.getSuper(m);
                    }
                    this.registerMethodError(method, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiJavaDocumentedElement)method, false)) {
                this.registerMethodError(method, Boolean.TRUE);
            }
        }

        public void visitField(@NotNull PsiField field) {
            if (this.hasDeprecatedAnnotation((PsiModifierListOwner)field)) {
                if (MissingDeprecatedAnnotationInspection.this.warnOnMissingJavadoc && !this.hasDeprecatedComment((PsiJavaDocumentedElement)field, true)) {
                    this.registerFieldError(field, Boolean.FALSE);
                }
            } else if (this.hasDeprecatedComment((PsiJavaDocumentedElement)field, false)) {
                this.registerFieldError(field, Boolean.TRUE);
            }
        }

        private boolean hasDeprecatedAnnotation(PsiModifierListOwner element) {
            PsiModifierList modifierList = element.getModifierList();
            return modifierList != null && modifierList.hasAnnotation("java.lang.Deprecated");
        }

        private boolean hasDeprecatedComment(PsiJavaDocumentedElement documentedElement, boolean checkContent) {
            PsiDocComment comment = documentedElement.getDocComment();
            if (comment == null) {
                return false;
            }
            PsiDocTag deprecatedTag = comment.findTagByName("deprecated");
            if (deprecatedTag == null) {
                return false;
            }
            if (!checkContent) {
                return true;
            }
            for (PsiElement element : deprecatedTag.getDataElements()) {
                if (!(element instanceof PsiDocTagValue) && (!(element instanceof PsiDocToken) || ((PsiDocToken)element).getTokenType() != JavaDocTokenType.DOC_COMMENT_DATA)) continue;
                return true;
            }
            return false;
        }
    }

    private static class MissingDeprecatedTagFix
    extends InspectionGadgetsFix {
        private static final String DEPRECATED_TAG_NAME = "deprecated";

        private MissingDeprecatedTagFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("missing.add.deprecated.javadoc.tag.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement parent = descriptor.getPsiElement().getParent();
            if (!(parent instanceof PsiJavaDocumentedElement)) {
                return;
            }
            PsiJavaDocumentedElement documentedElement = (PsiJavaDocumentedElement)parent;
            PsiDocComment docComment = documentedElement.getDocComment();
            if (docComment != null) {
                PsiDocTag existingTag = docComment.findTagByName(DEPRECATED_TAG_NAME);
                if (existingTag != null) {
                    MissingDeprecatedTagFix.moveCaretAfter((PsiElement)existingTag);
                    return;
                }
                PsiDocTag deprecatedTag = JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText("@deprecated TODO: explain");
                PsiElement addedTag = docComment.add((PsiElement)deprecatedTag);
                MissingDeprecatedTagFix.moveCaretAfter(addedTag);
            } else {
                PsiDocTag addedTag;
                PsiDocComment newDocComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText(StringUtil.join((String[])new String[]{"/**\n", " * ", "@deprecated TODO: explain", "\n */"}));
                PsiElement addedComment = documentedElement.addBefore((PsiElement)newDocComment, documentedElement.getFirstChild());
                if (addedComment instanceof PsiDocComment && (addedTag = ((PsiDocComment)addedComment).findTagByName(DEPRECATED_TAG_NAME)) != null) {
                    MissingDeprecatedTagFix.moveCaretAfter((PsiElement)addedTag);
                }
            }
        }

        private static void moveCaretAfter(PsiElement newCaretPosition) {
            PsiElement sibling = newCaretPosition.getNextSibling();
            if (sibling instanceof Navigatable) {
                ((Navigatable)sibling).navigate(true);
            }
        }
    }

    private static class MissingDeprecatedAnnotationFix
    extends InspectionGadgetsFix {
        private MissingDeprecatedAnnotationFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("missing.deprecated.annotation.add.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement identifier = descriptor.getPsiElement();
            PsiModifierListOwner parent = (PsiModifierListOwner)identifier.getParent();
            if (parent == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiAnnotation annotation = factory.createAnnotationFromText("@java.lang.Deprecated", (PsiElement)parent);
            PsiModifierList modifierList = parent.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.addAfter((PsiElement)annotation, null);
        }
    }
}

