/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.internationalization;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AbsoluteAlignmentInUserInterfaceInspection
extends BaseInspection {
    private static final Map<String, String> gridbagConstants = new HashMap<String, String>();
    private static final Map<String, String> borderLayoutConstants;
    private static final Map<String, String> flowLayoutConstants;
    private static final Map<String, String> scrollPaneConstants;
    private static final Map<String, String> boxLayoutConstants;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String className2 = (String)infos[0];
        String shortClassName = className2.substring(className2.lastIndexOf(46) + 1);
        return InspectionGadgetsBundle.message("absolute.alignment.in.user.interface.problem.descriptor", shortClassName);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AbsoluteAlignmentInUserInterfaceFix((String)infos[0], (String)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbsoluteAlignmentInUserInterfaceVisitor();
    }

    static {
        gridbagConstants.put("NORTHWEST", "FIRST_LINE_START");
        gridbagConstants.put("NORTHEAST", "FIRST_LINE_END");
        gridbagConstants.put("SOUTHWEST", "LAST_LINE_START");
        gridbagConstants.put("SOUTHEAST", "LAST_LINE_END");
        borderLayoutConstants = new HashMap<String, String>();
        borderLayoutConstants.put("NORTH", "PAGE_START");
        borderLayoutConstants.put("SOUTH", "PAGE_END");
        borderLayoutConstants.put("EAST", "LINE_END");
        borderLayoutConstants.put("WEST", "LINE_START");
        flowLayoutConstants = new HashMap<String, String>();
        flowLayoutConstants.put("LEFT", "LEADING");
        flowLayoutConstants.put("RIGHT", "TRAILING");
        scrollPaneConstants = new HashMap<String, String>();
        scrollPaneConstants.put("LOWER_LEFT_CORNER", "LOWER_LEADING_CORNER");
        scrollPaneConstants.put("LOWER_RIGHT_CORNER", "LOWER_TRAILING_CORNER");
        scrollPaneConstants.put("UPPER_LEFT_CORNER", "UPPER_LEADING_CORNER");
        scrollPaneConstants.put("UPPER_RIGHT_CORNER", "UPPER_TRAILING_CORNER");
        boxLayoutConstants = new HashMap<String, String>();
        boxLayoutConstants.put("X_AXIS", "LINE_AXIS");
        boxLayoutConstants.put("Y_AXIS", "PAGE_AXIS");
    }

    private static class AbsoluteAlignmentInUserInterfaceVisitor
    extends BaseInspectionVisitor {
        private AbsoluteAlignmentInUserInterfaceVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            String className2;
            super.visitReferenceExpression(expression2);
            PsiElement referenceNameElement2 = expression2.getReferenceNameElement();
            if (referenceNameElement2 == null) {
                return;
            }
            String referenceName = expression2.getReferenceName();
            String value2 = (String)gridbagConstants.get(referenceName);
            if (value2 != null) {
                className2 = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression2, "java.awt.GridBagConstraints");
            } else {
                value2 = (String)borderLayoutConstants.get(referenceName);
                if (value2 != null) {
                    className2 = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression2, "java.awt.BorderLayout", "java.awt.GridBagConstraints");
                } else {
                    value2 = (String)flowLayoutConstants.get(referenceName);
                    if (value2 != null) {
                        className2 = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression2, "java.awt.FlowLayout");
                    } else {
                        value2 = (String)scrollPaneConstants.get(referenceName);
                        if (value2 != null) {
                            className2 = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression2, "javax.swing.ScrollPaneConstants");
                        } else {
                            value2 = (String)boxLayoutConstants.get(referenceName);
                            if (value2 != null) {
                                className2 = AbsoluteAlignmentInUserInterfaceVisitor.checkExpression(expression2, "javax.swing.BoxLayout");
                            } else {
                                return;
                            }
                        }
                    }
                }
            }
            if (className2 == null) {
                return;
            }
            this.registerError(referenceNameElement2, className2, value2);
        }

        private static String checkExpression(PsiReferenceExpression expression2, String ... classNames) {
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)target;
            PsiClass containingClass = field.getContainingClass();
            for (String className2 : classNames) {
                if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)className2)) continue;
                return className2;
            }
            return null;
        }
    }

    private static class AbsoluteAlignmentInUserInterfaceFix
    extends InspectionGadgetsFix {
        private final String myClassName;
        private final String myReplacement;

        AbsoluteAlignmentInUserInterfaceFix(String className2, String replacement) {
            this.myClassName = className2;
            this.myReplacement = replacement;
        }

        @NotNull
        public String getName() {
            String shortClassName = this.myClassName.substring(this.myClassName.lastIndexOf(46) + 1);
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{shortClassName + "." + this.myReplacement});
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("absolute.alignment.in.user.interface.fix.family.name", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, this.myClassName + '.' + this.myReplacement);
        }
    }
}

