/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.NonNls;

public class MemberSignature
implements Comparable<MemberSignature> {
    @NonNls
    private static final String CONSTRUCTOR_NAME = "<init>";
    @NonNls
    private static final String INITIALIZER_SIGNATURE = "()V";
    @NonNls
    private static final MemberSignature ASSERTIONS_DISABLED_FIELD = new MemberSignature("$assertionsDisabled", 24, "Z");
    @NonNls
    private static final MemberSignature PACKAGE_PRIVATE_CONSTRUCTOR = new MemberSignature("<init>", 0, "()V");
    @NonNls
    private static final MemberSignature PUBLIC_CONSTRUCTOR = new MemberSignature("<init>", 1, "()V");
    @NonNls
    private static final MemberSignature STATIC_INITIALIZER = new MemberSignature("<clinit>", 8, "()V");
    private final int modifiers;
    private final String name;
    private final String signature;

    public MemberSignature(PsiField field) {
        this.modifiers = MemberSignature.calculateModifierBitmap(field.getModifierList());
        this.name = field.getName();
        this.signature = ClassUtil.getBinaryPresentation((PsiType)field.getType());
    }

    public MemberSignature(PsiMethod method) {
        this.modifiers = MemberSignature.calculateModifierBitmap(method.getModifierList());
        this.signature = ClassUtil.getAsmMethodSignature((PsiMethod)method).replace('/', '.');
        this.name = method.isConstructor() ? CONSTRUCTOR_NAME : method.getName();
    }

    public MemberSignature(@NonNls String name2, int modifiers, @NonNls String signature) {
        this.name = name2;
        this.modifiers = modifiers;
        this.signature = signature;
    }

    public static int calculateModifierBitmap(PsiModifierList modifierList) {
        int modifiers = 0;
        if (modifierList.hasModifierProperty("public")) {
            modifiers |= 1;
        }
        if (modifierList.hasModifierProperty("private")) {
            modifiers |= 2;
        }
        if (modifierList.hasModifierProperty("protected")) {
            modifiers |= 4;
        }
        if (modifierList.hasModifierProperty("static")) {
            modifiers |= 8;
        }
        if (modifierList.hasModifierProperty("final")) {
            modifiers |= 0x10;
        }
        if (modifierList.hasModifierProperty("volatile")) {
            modifiers |= 0x40;
        }
        if (modifierList.hasModifierProperty("transient")) {
            modifiers |= 0x80;
        }
        if (modifierList.hasModifierProperty("abstract")) {
            modifiers |= 0x400;
        }
        if (modifierList.hasModifierProperty("synchronized")) {
            modifiers |= 0x20;
        }
        if (modifierList.hasModifierProperty("native")) {
            modifiers |= 0x100;
        }
        if (modifierList.hasModifierProperty("strictfp")) {
            modifiers |= 0x800;
        }
        return modifiers;
    }

    @Override
    public int compareTo(MemberSignature other) {
        int result = this.name.compareTo(other.name);
        if (result != 0) {
            return result;
        }
        return this.signature.compareTo(other.signature);
    }

    @Deprecated
    public static String createTypeSignature(PsiType type2) {
        return ClassUtil.getBinaryPresentation((PsiType)type2);
    }

    public boolean equals(Object object) {
        try {
            MemberSignature other = (MemberSignature)object;
            return this.name.equals(other.name) && this.signature.equals(other.signature) && this.modifiers == other.modifiers;
        }
        catch (ClassCastException | NullPointerException ignored) {
            return false;
        }
    }

    public static MemberSignature getAssertionsDisabledFieldMemberSignature() {
        return ASSERTIONS_DISABLED_FIELD;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public static MemberSignature getPackagePrivateConstructor() {
        return PACKAGE_PRIVATE_CONSTRUCTOR;
    }

    public static MemberSignature getPublicConstructor() {
        return PUBLIC_CONSTRUCTOR;
    }

    public String getSignature() {
        return this.signature;
    }

    public static MemberSignature getStaticInitializerMemberSignature() {
        return STATIC_INITIALIZER;
    }

    public int hashCode() {
        return this.name.hashCode() + this.signature.hashCode();
    }

    public String toString() {
        return this.name + this.signature;
    }
}

