/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.BaseSwitchFix;
import com.siyeh.ig.psiutils.CreateSwitchBranchesUtil;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreateMissingSwitchBranchesFix
extends BaseSwitchFix {
    private final Set<String> myNames;

    public CreateMissingSwitchBranchesFix(@NotNull PsiSwitchBlock block, Set<String> names2) {
        super(block);
        this.myNames = names2;
    }

    @NotNull
    public String getText() {
        return this.getName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return CreateSwitchBranchesUtil.getActionName(this.myNames);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("create.missing.switch.branches.fix.family.name", new Object[0]);
    }

    @Override
    protected void invoke() {
        PsiSwitchBlock switchBlock = (PsiSwitchBlock)this.myBlock.getElement();
        if (switchBlock == null) {
            return;
        }
        PsiExpression switchExpression = switchBlock.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiClassType switchType = (PsiClassType)switchExpression.getType();
        if (switchType == null) {
            return;
        }
        PsiClass enumClass = switchType.resolve();
        if (enumClass == null) {
            return;
        }
        List allEnumConstants = StreamEx.of((Object[])enumClass.getAllFields()).select(PsiEnumConstant.class).map(PsiField::getName).toList();
        Function<PsiSwitchLabelStatementBase, List<String>> caseExtractor = label -> ContainerUtil.map(SwitchUtils.findEnumConstants(label), PsiField::getName);
        List<PsiSwitchLabelStatementBase> addedLabels = CreateSwitchBranchesUtil.createMissingBranches(switchBlock, allEnumConstants, this.myNames, caseExtractor);
        CreateSwitchBranchesUtil.createTemplate(switchBlock, addedLabels);
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiSwitchBlock block = (PsiSwitchBlock)this.myBlock.getElement();
        return block == null ? null : new CreateMissingSwitchBranchesFix((PsiSwitchBlock)PsiTreeUtil.findSameElementInCopy((PsiElement)block, (PsiFile)target), this.myNames);
    }
}

