/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.fix.DeleteSwitchLabelFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowSubRange;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryDefaultInspection
extends BaseInspection {
    public boolean onlyReportSwitchExpressions = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.default.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.default.expressions.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportSwitchExpressions");
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DeleteDefaultFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !this.onlyReportSwitchExpressions || HighlightingFeature.ENHANCED_SWITCH.isAvailable((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryDefaultVisitor();
    }

    private static boolean isDefaultNeededForInitializationOfVariable(PsiSwitchBlock switchBlock) {
        Collection expressions2 = PsiTreeUtil.findChildrenOfType((PsiElement)switchBlock, PsiReferenceExpression.class);
        THashSet checked = new THashSet();
        for (PsiReferenceExpression expression2 : expressions2) {
            PsiVariable variable;
            PsiElement target;
            PsiAssignmentExpression assignmentExpression;
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (!(parent instanceof PsiAssignmentExpression) || JavaTokenType.EQ != (assignmentExpression = (PsiAssignmentExpression)parent).getOperationTokenType() || !PsiTreeUtil.isAncestor((PsiElement)assignmentExpression.getLExpression(), (PsiElement)expression2, (boolean)false) || (target = expression2.resolve()) != null && !checked.add(target) || !(target instanceof PsiLocalVariable) && (!(target instanceof PsiField) || !((PsiField)target).hasModifierProperty("final")) || (variable = (PsiVariable)target).getInitializer() != null) continue;
            PsiElement context = UnnecessaryDefaultInspection.getContext((PsiElement)switchBlock);
            if (context == null) {
                return true;
            }
            try {
                LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
                ControlFlow controlFlow = ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, policy);
                int switchStart = controlFlow.getStartOffset((PsiElement)switchBlock);
                int switchEnd = controlFlow.getEndOffset((PsiElement)switchBlock);
                ControlFlowSubRange beforeFlow = new ControlFlowSubRange(controlFlow, 0, switchStart);
                ControlFlowSubRange switchFlow = new ControlFlowSubRange(controlFlow, switchStart, switchEnd);
                if (ControlFlowUtil.isVariableDefinitelyAssigned(variable, beforeFlow) || !ControlFlowUtil.isVariableDefinitelyAssigned(variable, switchFlow) || !ControlFlowUtil.needVariableValueAt(variable, controlFlow, switchEnd)) continue;
                return true;
            }
            catch (AnalysisCanceledException e) {
                return true;
            }
        }
        return false;
    }

    private static PsiElement getContext(PsiElement element) {
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
        if (context instanceof PsiField) {
            return ((PsiField)context).getInitializer();
        }
        if (context instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)context).getBody();
        }
        if (context instanceof PsiMethod) {
            return ((PsiMethod)context).getBody();
        }
        if (context instanceof PsiLambdaExpression) {
            return ((PsiLambdaExpression)context).getBody();
        }
        return null;
    }

    @Nullable
    private static PsiSwitchLabelStatementBase retrieveUnnecessaryDefault(PsiSwitchBlock switchBlock) {
        PsiExpression expression2 = switchBlock.getExpression();
        if (expression2 == null) {
            return null;
        }
        PsiType type2 = expression2.getType();
        if (!(type2 instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiClass aClass = classType.resolve();
        if (aClass == null || !aClass.isEnum()) {
            return null;
        }
        PsiCodeBlock body2 = switchBlock.getBody();
        if (body2 == null) {
            return null;
        }
        THashSet coveredConstants = new THashSet();
        PsiSwitchLabelStatementBase result = null;
        for (PsiStatement psiStatement : body2.getStatements()) {
            if (!(psiStatement instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)psiStatement;
            if (labelStatement.isDefaultCase()) {
                result = labelStatement;
                continue;
            }
            List<PsiEnumConstant> constants = SwitchUtils.findEnumConstants(labelStatement);
            for (PsiEnumConstant constant : constants) {
                if (coveredConstants.add(constant)) continue;
                return null;
            }
        }
        if (result == null) {
            return null;
        }
        for (PsiStatement psiStatement : aClass.getFields()) {
            if (!(psiStatement instanceof PsiEnumConstant) || coveredConstants.remove(psiStatement)) continue;
            return null;
        }
        return !coveredConstants.isEmpty() ? null : result;
    }

    private class UnnecessaryDefaultVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryDefaultVisitor() {
        }

        public void visitSwitchExpression(PsiSwitchExpression expression2) {
            super.visitSwitchExpression(expression2);
            this.checkSwitchBlock((PsiSwitchBlock)expression2);
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            super.visitSwitchStatement(statement);
            this.checkSwitchBlock((PsiSwitchBlock)statement);
        }

        private void checkSwitchBlock(@NotNull PsiSwitchBlock switchBlock) {
            ProblemHighlightType highlightType;
            PsiStatement nextStatement;
            PsiSwitchLabelStatementBase defaultStatement = UnnecessaryDefaultInspection.retrieveUnnecessaryDefault(switchBlock);
            if (defaultStatement == null) {
                return;
            }
            boolean ruleBasedSwitch = defaultStatement instanceof PsiSwitchLabeledRuleStatement;
            boolean statementSwitch = switchBlock instanceof PsiStatement;
            PsiStatement psiStatement = nextStatement = ruleBasedSwitch ? ((PsiSwitchLabeledRuleStatement)defaultStatement).getBody() : (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)defaultStatement, PsiStatement.class);
            if (statementSwitch && nextStatement instanceof PsiThrowStatement) {
                return;
            }
            while (nextStatement != null) {
                if (UnnecessaryDefaultInspection.isDefaultNeededForInitializationOfVariable(switchBlock)) {
                    return;
                }
                if (statementSwitch && !ControlFlowUtils.statementMayCompleteNormally(nextStatement)) {
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)switchBlock, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                    if (method == null || PsiType.VOID.equals((Object)method.getReturnType()) || ControlFlowUtils.statementContainsNakedBreak(nextStatement)) break;
                    PsiCodeBlock body2 = method.getBody();
                    assert (body2 != null);
                    if (ControlFlowUtils.blockCompletesWithStatement(body2, (PsiStatement)switchBlock)) {
                        return;
                    }
                }
                if (ruleBasedSwitch) break;
                nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)nextStatement, PsiStatement.class);
            }
            if (UnnecessaryDefaultInspection.this.onlyReportSwitchExpressions && statementSwitch) {
                if (!this.isOnTheFly()) {
                    return;
                }
                highlightType = ProblemHighlightType.INFORMATION;
            } else {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            }
            this.registerError(defaultStatement.getFirstChild(), highlightType, new Object[0]);
        }
    }

    private static class DeleteDefaultFix
    extends InspectionGadgetsFix {
        private DeleteDefaultFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.default.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement().getParent();
            if (element instanceof PsiSwitchLabelStatementBase) {
                DeleteSwitchLabelFix.deleteLabel((PsiSwitchLabelStatementBase)element);
            }
        }
    }
}

