/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateConditionInspection
extends BaseInspection {
    public boolean ignoreSideEffectConditions = true;
    private static final int LIMIT_DEPTH = 20;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("duplicate.condition.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("duplicate.condition.ignore.method.calls.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSideEffectConditions");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DuplicateConditionVisitor();
    }

    private class DuplicateConditionVisitor
    extends BaseInspectionVisitor {
        private final Set<PsiIfStatement> myAnalyzedStatements = new HashSet<PsiIfStatement>();

        private DuplicateConditionVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            super.visitIfStatement(statement);
            if (ControlFlowUtils.isElseIf(statement)) {
                return;
            }
            LinkedHashSet<PsiExpression> conditions = new LinkedHashSet<PsiExpression>();
            this.collectConditionsForIfStatement(statement, conditions, 0);
            if (conditions.size() < 2) {
                return;
            }
            this.findDuplicatesAccordingToSideEffects(conditions);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            PsiBinaryExpression parentExpression;
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ANDAND) && !tokenType.equals(JavaTokenType.OROR)) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            if (parent instanceof PsiIfStatement) {
                return;
            }
            if (parent instanceof PsiBinaryExpression && tokenType.equals((parentExpression = (PsiBinaryExpression)parent).getOperationTokenType())) {
                return;
            }
            LinkedHashSet<PsiExpression> conditions = new LinkedHashSet<PsiExpression>();
            this.collectConditionsForExpression((PsiExpression)expression2, conditions, tokenType);
            if (conditions.size() < 2) {
                return;
            }
            this.findDuplicatesAccordingToSideEffects(conditions);
        }

        private void collectConditionsForIfStatement(PsiIfStatement statement, Set<? super PsiExpression> conditions, int depth) {
            if (depth > 20 || !this.myAnalyzedStatements.add(statement)) {
                return;
            }
            PsiExpression condition2 = statement.getCondition();
            this.collectConditionsForExpression(condition2, conditions, JavaTokenType.OROR);
            PsiStatement branch = ControlFlowUtils.stripBraces(statement.getElseBranch());
            if (branch instanceof PsiIfStatement) {
                this.collectConditionsForIfStatement((PsiIfStatement)branch, conditions, depth + 1);
            }
            if (branch == null) {
                PsiStatement thenBranch = statement.getThenBranch();
                if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                    return;
                }
                PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement);
                if (next instanceof PsiIfStatement) {
                    this.collectConditionsForIfStatement((PsiIfStatement)next, conditions, depth + 1);
                }
            }
        }

        private void collectConditionsForExpression(PsiExpression condition2, Set<? super PsiExpression> conditions, IElementType wantedTokenType) {
            PsiPolyadicExpression polyadicExpression;
            IElementType tokenType;
            if (condition2 == null) {
                return;
            }
            if (condition2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition2;
                PsiExpression contents = parenthesizedExpression.getExpression();
                this.collectConditionsForExpression(contents, conditions, wantedTokenType);
                return;
            }
            if (condition2 instanceof PsiPolyadicExpression && wantedTokenType.equals(tokenType = (polyadicExpression = (PsiPolyadicExpression)condition2).getOperationTokenType())) {
                PsiExpression[] operands2;
                for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                    this.collectConditionsForExpression(operand2, conditions, wantedTokenType);
                }
                return;
            }
            conditions.add((PsiExpression)condition2);
        }

        private void findDuplicatesAccordingToSideEffects(Set<PsiExpression> conditions) {
            ArrayList<PsiExpression> conditionList = new ArrayList<PsiExpression>(conditions);
            if (DuplicateConditionInspection.this.ignoreSideEffectConditions) {
                conditionList.replaceAll(cond -> SideEffectChecker.mayHaveSideEffects(cond) ? null : cond);
                ((StreamEx)StreamEx.of(conditionList).groupRuns((a, b) -> a != null && b != null).filter(list -> list.size() >= 2)).forEach(this::findDuplicates);
            } else {
                this.findDuplicates(conditionList);
            }
        }

        private void findDuplicates(List<PsiExpression> conditions) {
            BitSet matched = new BitSet();
            for (int i = 0; i < conditions.size(); ++i) {
                if (matched.get(i)) continue;
                PsiExpression condition2 = conditions.get(i);
                for (int j = i + 1; j < conditions.size(); ++j) {
                    if (matched.get(j)) continue;
                    PsiExpression testCondition = conditions.get(j);
                    boolean areEquivalent = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(condition2, testCondition);
                    if (!areEquivalent) continue;
                    this.registerError((PsiElement)testCondition, new Object[0]);
                    if (!matched.get(i)) {
                        this.registerError((PsiElement)condition2, new Object[0]);
                    }
                    matched.set(i);
                    matched.set(j);
                }
            }
        }
    }
}

