/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfusingElseInspection
extends BaseInspection {
    public boolean reportWhenNoStatementFollow = true;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ConfusingElseBranch";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("redundant.else.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("confusing.else.option", new Object[0]), (InspectionProfileEntry)this, "reportWhenNoStatementFollow");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingElseVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveRedundantElseFix();
    }

    private class ConfusingElseVisitor
    extends BaseInspectionVisitor {
        private ConfusingElseVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiKeyword elseToken;
            super.visitIfStatement(statement);
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            PsiStatement elseBranch = statement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                return;
            }
            if (!ConfusingElseInspection.this.reportWhenNoStatementFollow) {
                PsiStatement nextStatement = this.getNextStatement(statement);
                if (nextStatement == null) {
                    return;
                }
                if (!ControlFlowUtils.statementMayCompleteNormally(elseBranch)) {
                    return;
                }
            }
            if ((elseToken = statement.getElseElement()) == null) {
                return;
            }
            if (this.parentCompletesNormally((PsiElement)statement)) {
                return;
            }
            this.registerError((PsiElement)elseToken, new Object[0]);
        }

        private boolean parentCompletesNormally(PsiElement element) {
            PsiElement parent = element.getParent();
            while (parent instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)parent;
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (elseBranch != element) {
                    return true;
                }
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (ControlFlowUtils.statementMayCompleteNormally(thenBranch)) {
                    return true;
                }
                element = parent;
                parent = element.getParent();
            }
            return !(parent instanceof PsiCodeBlock);
        }

        @Nullable
        private PsiStatement getNextStatement(PsiIfStatement statement) {
            PsiIfStatement parentIfStatement;
            PsiStatement elseBranch;
            PsiElement parent;
            while ((parent = statement.getParent()) instanceof PsiIfStatement && (elseBranch = (parentIfStatement = (PsiIfStatement)parent).getElseBranch()) == statement) {
                statement = parentIfStatement;
            }
            return (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
        }
    }

    private static class RemoveRedundantElseFix
    extends InspectionGadgetsFix {
        private RemoveRedundantElseFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("redundant.else.unwrap.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement ifKeyword = descriptor.getPsiElement();
            PsiIfStatement ifStatement = (PsiIfStatement)ifKeyword.getParent();
            if (ifStatement == null) {
                return;
            }
            PsiStatement elseBranch = ifStatement.getElseBranch();
            if (elseBranch == null) {
                return;
            }
            PsiIfStatement anchor = ifStatement;
            PsiElement parent = anchor.getParent();
            while (parent instanceof PsiIfStatement) {
                anchor = parent;
                parent = anchor.getParent();
            }
            if (elseBranch instanceof PsiBlockStatement) {
                PsiBlockStatement elseBlock = (PsiBlockStatement)elseBranch;
                PsiCodeBlock block = elseBlock.getCodeBlock();
                PsiElement[] children = block.getChildren();
                if (children.length > 2) {
                    parent.addRangeAfter(children[1], children[children.length - 2], (PsiElement)anchor);
                }
            } else {
                parent.addAfter((PsiElement)elseBranch, (PsiElement)anchor);
            }
            elseBranch.delete();
        }
    }
}

