/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.RemoveRedundantPolyadicOperandFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.ReorderingUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionCoveredByFurtherConditionInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ConditionCoveredByFurtherConditionInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new ConditionCoveredByFurtherConditionVisitor(holder);
    }

    @NotNull
    private static Map<PsiExpression, ThreeState> computeOperandValues(final PsiPolyadicExpression expressionToAnalyze) {
        HashMap values;
        StandardInstructionVisitor visitor2;
        DataFlowRunner runner = new DataFlowRunner(expressionToAnalyze.getProject(), (PsiElement)expressionToAnalyze){

            @Override
            @NotNull
            protected List<DfaInstructionState> createInitialInstructionStates(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> memStates, @NotNull ControlFlow flow) {
                List<DfaInstructionState> states = super.createInitialInstructionStates(psiBlock, memStates, flow);
                List vars = flow.accessedVariables().filter(var -> {
                    if (!(var.getInherentType() instanceof DfReferenceType) || ((DfReferenceType)var.getInherentType()).getNullability() == DfaNullability.UNKNOWN) {
                        return false;
                    }
                    PsiVariable psi = (PsiVariable)ObjectUtils.tryCast((Object)var.getPsiVariable(), PsiVariable.class);
                    if (psi instanceof PsiPatternVariable) {
                        return true;
                    }
                    if (psi instanceof PsiLocalVariable || psi instanceof PsiParameter) {
                        PsiElement block = PsiUtil.getVariableCodeBlock((PsiVariable)psi, null);
                        return block == null || !HighlightControlFlowUtil.isEffectivelyFinal(psi, block, null);
                    }
                    return true;
                }).collect(Collectors.toList());
                if (!vars.isEmpty()) {
                    for (DfaInstructionState state : states) {
                        for (DfaVariableValue var2 : vars) {
                            state.getMemoryState().setVarValue(var2, this.getFactory().fromDfType(((DfReferenceType)var2.getInherentType()).dropNullability()));
                        }
                    }
                }
                return states;
            }
        };
        RunnerResult result = runner.analyzeMethod((PsiElement)expressionToAnalyze, visitor2 = new StandardInstructionVisitor(values = new HashMap()){
            final /* synthetic */ Map val$values;
            {
                this.val$values = map2;
            }

            @Override
            protected boolean checkNotNullable(DfaMemoryState state, @NotNull DfaValue value2, @Nullable NullabilityProblemKind.NullabilityProblem<?> problem) {
                DfType dfType;
                if (value2 instanceof DfaVariableValue && (dfType = state.getDfType(value2)) instanceof DfReferenceType) {
                    state.setDfType(value2, ((DfReferenceType)dfType).dropNullability().meet(DfaNullability.NULLABLE.asDfType()));
                }
                return true;
            }

            @Override
            protected void beforeExpressionPush(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @Nullable TextRange range, @NotNull DfaMemoryState state) {
                super.beforeExpressionPush(value2, expression2, range, state);
                if (PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent()) != expressionToAnalyze) {
                    return;
                }
                ThreeState old = (ThreeState)this.val$values.get(expression2);
                if (old == ThreeState.UNSURE) {
                    return;
                }
                ThreeState result = ThreeState.UNSURE;
                Boolean bool = DfConstantType.getConstantOfType(state.getDfType(value2), Boolean.class);
                if (bool != null) {
                    result = ThreeState.fromBoolean((boolean)bool);
                }
                this.val$values.put(expression2, old == null || old == result ? result : ThreeState.UNSURE);
            }
        });
        return result == RunnerResult.OK ? values : Collections.emptyMap();
    }

    private static class ConditionCoveredByFurtherConditionVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        ConditionCoveredByFurtherConditionVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            IElementType type2 = expression2.getOperationTokenType();
            if (type2.equals(JavaTokenType.ANDAND)) {
                this.processConditionChain(expression2, true);
            } else if (type2.equals(JavaTokenType.OROR)) {
                this.processConditionChain(expression2, false);
            }
        }

        private void processConditionChain(PsiPolyadicExpression expression2, boolean and) {
            ((StreamEx)StreamEx.of((Object[])expression2.getOperands()).map(operand2 -> ConditionCoveredByFurtherConditionVisitor.isAllowed(operand2) ? operand2 : null).groupRuns((o1, o2) -> o1 != null && o2 != null).remove(list -> list.size() == 1)).forEach(operands2 -> this.process(expression2, (List<PsiExpression>)operands2, and));
        }

        private static boolean isAllowed(PsiExpression expression2) {
            return ReorderingUtils.isSideEffectFree(expression2, true);
        }

        private void process(PsiPolyadicExpression context, List<PsiExpression> operands2, boolean and) {
            int[] indices2;
            for (int index : indices2 = ConditionCoveredByFurtherConditionVisitor.getRedundantOperandIndices(context, operands2, and)) {
                List<PsiExpression> dependencies = operands2.subList(index + 1, operands2.size());
                PsiExpression operand2 = operands2.get(index);
                dependencies = ConditionCoveredByFurtherConditionVisitor.minimizeDependencies(context, operand2, and, dependencies);
                if (dependencies.isEmpty()) continue;
                String operandText = PsiExpressionTrimRenderer.render((PsiExpression)operand2);
                String description = InspectionGadgetsBundle.message("inspection.condition.covered.by.further.condition.descr", operandText, dependencies.size(), PsiExpressionTrimRenderer.render((PsiExpression)Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)dependencies.get(0)))));
                this.myHolder.registerProblem((PsiElement)operand2, description, new LocalQuickFix[]{new RemoveRedundantPolyadicOperandFix(operandText)});
            }
        }

        private static List<PsiExpression> minimizeDependencies(PsiPolyadicExpression context, PsiExpression operand2, boolean and, List<PsiExpression> dependencies) {
            if (dependencies.isEmpty() || ConditionCoveredByFurtherConditionVisitor.getRedundantOperandIndices(context, Collections.singletonList(operand2), and).length != 0) {
                return Collections.emptyList();
            }
            if (dependencies.size() == 1) {
                return dependencies;
            }
            for (PsiExpression dependency : dependencies) {
                if (ArrayUtil.indexOf((int[])ConditionCoveredByFurtherConditionVisitor.getRedundantOperandIndices(context, Arrays.asList(operand2, dependency), and), (int)0) == -1) continue;
                return Collections.singletonList(dependency);
            }
            return dependencies;
        }

        private static int[] getRedundantOperandIndices(PsiPolyadicExpression context, List<PsiExpression> operands2, boolean and) {
            assert (!operands2.isEmpty());
            if (operands2.size() == 1) {
                int[] nArray;
                Object value2 = CommonDataflow.computeValue(operands2.get(0));
                if (Boolean.valueOf(and).equals(value2)) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = 0;
                } else {
                    nArray = ArrayUtilRt.EMPTY_INT_ARRAY;
                }
                return nArray;
            }
            String text2 = StreamEx.ofReversed(operands2).map(expression2 -> ParenthesesUtils.getText(expression2, 13)).joining((CharSequence)(and ? " && " : " || "));
            PsiExpression expression3 = JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText(text2, (PsiElement)context);
            if (!(expression3 instanceof PsiPolyadicExpression)) {
                LOG.error("Unexpected expression type: " + expression3.getClass().getName(), new Attachment[]{new Attachment("reversed.txt", text2)});
                return ArrayUtilRt.EMPTY_INT_ARRAY;
            }
            PsiPolyadicExpression expressionToAnalyze = (PsiPolyadicExpression)expression3;
            List<PsiExpression> reversedOperands = Arrays.asList(expressionToAnalyze.getOperands());
            Map values = ConditionCoveredByFurtherConditionInspection.computeOperandValues(expressionToAnalyze);
            return StreamEx.ofKeys((Map)values, arg_0 -> ThreeState.fromBoolean((boolean)and).equals(arg_0)).mapToInt(operand2 -> IntStreamEx.ofIndices((List)reversedOperands, op -> PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)operand2, (boolean)false)).findFirst().orElse(0)).map(index -> operands2.size() - 1 - index).toArray();
        }
    }
}

