/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublicConstructorInspection
extends BaseInspection {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceConstructorWithFactoryMethodFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            return InspectionGadgetsBundle.message("public.default.constructor.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("public.constructor.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicConstructorVisitor();
    }

    private static class PublicConstructorVisitor
    extends BaseInspectionVisitor {
        private PublicConstructorVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            PsiParameterList parameterList;
            super.visitMethod(method);
            if (!method.isConstructor()) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || aClass.hasModifierProperty("abstract") || aClass.isRecord()) {
                return;
            }
            if (SerializationUtils.isExternalizable(aClass) && (parameterList = method.getParameterList()).isEmpty()) {
                return;
            }
            this.registerMethodError(method, Boolean.FALSE);
        }

        public void visitClass(PsiClass aClass) {
            super.visitClass(aClass);
            if (aClass.isInterface() || aClass.isEnum() || aClass.isRecord()) {
                return;
            }
            if (!aClass.hasModifierProperty("public") || aClass.hasModifierProperty("abstract")) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0) {
                return;
            }
            if (SerializationUtils.isExternalizable(aClass)) {
                return;
            }
            this.registerClassError(aClass, Boolean.TRUE);
        }
    }

    private static class ReplaceConstructorWithFactoryMethodFix
    extends RefactoringInspectionGadgetsFix {
        private ReplaceConstructorWithFactoryMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("public.constructor.quickfix", new Object[0]);
        }

        @NotNull
        public RefactoringActionHandler getHandler() {
            return JavaRefactoringActionHandlerFactory.getInstance().createReplaceConstructorWithFactoryHandler();
        }
    }
}

