/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SuspiciousArrayCastInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("suspicious.array.cast.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousArrayCastVisitor();
    }

    private static class SuspiciousArrayCastVisitor
    extends BaseInspectionVisitor {
        private SuspiciousArrayCastVisitor() {
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
            super.visitTypeCastExpression(expression2);
            PsiTypeElement typeElement = expression2.getCastType();
            if (typeElement == null) {
                return;
            }
            PsiType castType = typeElement.getType();
            if (!(castType instanceof PsiArrayType)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            if (operand2 == null) {
                return;
            }
            PsiType type2 = operand2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            PsiClass castClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)castType.getDeepComponentType());
            if (castClass == null) {
                return;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2.getDeepComponentType());
            if (aClass == null || !castClass.isInheritor(aClass, true) || SuspiciousArrayCastVisitor.isCollectionToArrayCall(operand2)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        private static boolean isCollectionToArrayCall(PsiExpression expression2) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressionCount() != 1) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (!"toArray".equals(methodExpression.getReferenceName())) {
                return false;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.Collection");
        }
    }
}

