/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullDialog;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.DelegatingFix;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnNullInspection
extends BaseInspection {
    private static final CallMatcher.Simple MAP_COMPUTE = CallMatcher.instanceCall("java.util.Map", "compute", "computeIfPresent", "computeIfAbsent");
    public boolean m_reportObjectMethods = true;
    public boolean m_reportArrayMethods = true;
    public boolean m_reportCollectionMethods = true;
    public boolean m_ignorePrivateMethods = false;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.ignore.private.option", new Object[0]), "m_ignorePrivateMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.arrays.option", new Object[0]), "m_reportArrayMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.collections.option", new Object[0]), "m_reportCollectionMethods");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("return.of.null.objects.option", new Object[0]), "m_reportObjectMethods");
        optionsPanel.addComponent((JComponent)NullableNotNullDialog.createConfigureAnnotationsButton((Component)optionsPanel));
        return optionsPanel;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ReturnOfNull";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("return.of.null.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method;
        PsiType type2;
        PsiElement elt = (PsiElement)infos[0];
        if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)elt)) {
            return null;
        }
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)elt, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (element instanceof PsiLambdaExpression) {
            return null;
        }
        if (element instanceof PsiMethod && TypeUtils.isOptional(type2 = (method = (PsiMethod)element).getReturnType())) {
            return new ReplaceWithEmptyOptionalFix(((PsiClassType)type2).rawType().getCanonicalText());
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)elt.getProject());
        return new DelegatingFix(new AnnotateMethodFix(manager.getDefaultNullable(), ArrayUtilRt.toStringArray((Collection)manager.getNotNulls())));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnNullVisitor();
    }

    private class ReturnNullVisitor
    extends BaseInspectionVisitor {
        private ReturnNullVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression value2) {
            Project project;
            NullabilityAnnotationInfo info;
            boolean lambda2;
            PsiType returnType;
            PsiMethod method;
            super.visitLiteralExpression(value2);
            String text2 = value2.getText();
            if (!"null".equals(text2)) {
                return;
            }
            PsiElement parent = ExpressionUtils.getPassThroughParent((PsiExpression)value2);
            if (!(parent instanceof PsiReturnStatement) && !(parent instanceof PsiLambdaExpression)) {
                return;
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)value2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (element instanceof PsiMethod) {
                method = (PsiMethod)element;
                returnType = method.getReturnType();
                lambda2 = false;
            } else if (element instanceof PsiLambdaExpression) {
                PsiType functionalInterfaceType = ((PsiLambdaExpression)element).getFunctionalInterfaceType();
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                lambda2 = true;
            } else {
                return;
            }
            if (method == null || returnType == null) {
                return;
            }
            if (TypeUtils.isOptional(returnType)) {
                this.registerError((PsiElement)value2, value2);
                return;
            }
            if (lambda2) {
                if (ReturnNullInspection.this.m_ignorePrivateMethods || this.isInNullableContext(element)) {
                    return;
                }
            } else {
                if (ReturnNullInspection.this.m_ignorePrivateMethods && method.hasModifierProperty("private")) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass instanceof PsiAnonymousClass && (ReturnNullInspection.this.m_ignorePrivateMethods || this.isInNullableContext(containingClass.getParent()))) {
                    return;
                }
            }
            if ((info = NullableNotNullManager.getInstance((Project)(project = method.getProject())).findEffectiveNullabilityInfo((PsiModifierListOwner)method)) != null && info.getNullability() == Nullability.NULLABLE && !info.isInferred()) {
                return;
            }
            if (DfaPsiUtil.getTypeNullability(returnType) == Nullability.NULLABLE) {
                return;
            }
            if (CollectionUtils.isCollectionClassOrInterface(returnType)) {
                if (ReturnNullInspection.this.m_reportCollectionMethods) {
                    this.registerError((PsiElement)value2, value2);
                }
            } else if (returnType.getArrayDimensions() > 0) {
                if (ReturnNullInspection.this.m_reportArrayMethods) {
                    this.registerError((PsiElement)value2, value2);
                }
            } else if (!returnType.equalsToText("java.lang.Void") && ReturnNullInspection.this.m_reportObjectMethods) {
                this.registerError((PsiElement)value2, value2);
            }
        }

        private boolean isInNullableContext(PsiElement element) {
            PsiElement grandParent;
            PsiElement parent;
            PsiElement psiElement = parent = element instanceof PsiExpression ? ExpressionUtils.getPassThroughParent((PsiExpression)element) : element;
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
                if (codeBlock == null) {
                    return false;
                }
                PsiElement[] refs = DefUseUtil.getRefs(codeBlock, variable, element);
                return Arrays.stream(refs).anyMatch(this::isInNullableContext);
            }
            if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
                return MAP_COMPUTE.test(methodCallExpression);
            }
            return false;
        }
    }

    private static class ReplaceWithEmptyOptionalFix
    extends InspectionGadgetsFix {
        private final String myTypeText;

        ReplaceWithEmptyOptionalFix(String typeText) {
            this.myTypeText = typeText;
        }

        @Nls
        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.getReplacementText()});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"Optional.empty()"});
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiLiteralExpression)) {
                return;
            }
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)element;
            PsiReplacementUtil.replaceExpression((PsiExpression)literalExpression, this.getReplacementText());
        }

        @NotNull
        private String getReplacementText() {
            return this.myTypeText + "." + ("com.google.common.base.Optional".equals(this.myTypeText) ? "absent" : "empty") + "()";
        }
    }
}

