/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MismatchedStringCaseInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher STRING_COMPARISON_METHODS = CallMatcher.exactInstanceCall("java.lang.String", "equals", "startsWith", "endsWith", "contains", "indexOf", "lastIndexOf");
    private static final CallMatcher CASE_PRESERVING_METHODS = CallMatcher.exactInstanceCall("java.lang.String", "trim", "repeat", "substring", "strip");
    private static final CallMatcher TO_LOWER_CASE = CallMatcher.exactInstanceCall("java.lang.String", "toLowerCase");
    private static final CallMatcher TO_UPPER_CASE = CallMatcher.exactInstanceCall("java.lang.String", "toUpperCase");
    private static final int ANALYSIS_COMPLEXITY = 16;

    static StringCase fromExpression(@Nullable PsiExpression expression2, int energy) {
        if (expression2 == null || energy <= 0) {
            return StringCase.UNSURE;
        }
        String str = (String)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)), String.class);
        if (str != null) {
            return MismatchedStringCaseInspection.fromConstant(str);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (CASE_PRESERVING_METHODS.test(call)) {
                return MismatchedStringCaseInspection.fromExpression(call.getMethodExpression().getQualifierExpression(), energy - 1);
            }
            if (TO_LOWER_CASE.test(call)) {
                return new StringCase(ThreeState.UNSURE, ThreeState.NO);
            }
            if (TO_UPPER_CASE.test(call)) {
                return new StringCase(ThreeState.NO, ThreeState.UNSURE);
            }
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiExpression thenBranch = ((PsiConditionalExpression)expression2).getThenExpression();
            StringCase thenCase = MismatchedStringCaseInspection.fromExpression(thenBranch, energy / 2);
            if (thenCase.equals(StringCase.UNSURE)) {
                return thenCase;
            }
            PsiExpression elseBranch = ((PsiConditionalExpression)expression2).getElseExpression();
            return MismatchedStringCaseInspection.fromExpression(elseBranch, energy / 2).either(thenCase);
        }
        if (expression2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)expression2).getOperationTokenType().equals(JavaTokenType.PLUS)) {
            PsiExpression[] operands2 = ((PsiPolyadicExpression)expression2).getOperands();
            StringCase result = new StringCase(ThreeState.NO, ThreeState.NO);
            for (PsiExpression operand2 : operands2) {
                StringCase operandCase = MismatchedStringCaseInspection.fromExpression(operand2, energy / operands2.length);
                result = result.concat(operandCase);
                if (result.myHasLower == ThreeState.YES && result.myHasUpper == ThreeState.YES) break;
            }
            return result;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            return MismatchedStringCaseInspection.fromExpression(MismatchedStringCaseInspection.resolveDefinition(expression2), energy - 4);
        }
        return StringCase.UNSURE;
    }

    @Nullable
    private static PsiExpression resolveDefinition(@NotNull PsiExpression expression2) {
        PsiAssignmentExpression assignment;
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiReferenceExpression.class);
        if (referenceExpression == null) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiVariable.class);
        if (variable == null) {
            return null;
        }
        PsiCodeBlock block = (PsiCodeBlock)ObjectUtils.tryCast((Object)PsiUtil.getVariableCodeBlock((PsiVariable)variable, null), PsiCodeBlock.class);
        if (block == null) {
            return null;
        }
        PsiElement[] defs = DefUseUtil.getDefs(block, variable, (PsiElement)expression2);
        if (defs.length != 1) {
            return null;
        }
        PsiElement def = defs[0];
        if (def instanceof PsiLocalVariable) {
            return ((PsiLocalVariable)def).getInitializer();
        }
        if (def instanceof PsiReferenceExpression && (assignment = ExpressionUtils.getAssignment(def.getParent())) != null && assignment.getLExpression() == def) {
            return assignment.getRExpression();
        }
        if (def instanceof PsiExpression) {
            return (PsiExpression)def;
        }
        return null;
    }

    private static StringCase fromConstant(String str) {
        int codepoint;
        ThreeState hasLower = ThreeState.NO;
        ThreeState hasUpper = ThreeState.NO;
        for (int i = 0; i < str.length(); i += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(i);
            if (Character.isLowerCase(codepoint)) {
                hasLower = ThreeState.YES;
                if (hasUpper != ThreeState.YES) continue;
                break;
            }
            if (!Character.isUpperCase(codepoint)) continue;
            hasUpper = ThreeState.YES;
            if (hasLower == ThreeState.YES) break;
        }
        return new StringCase(hasLower, hasUpper);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                String returnValue;
                String methodName;
                String oppositeCase;
                String problematicCase;
                if (!STRING_COMPARISON_METHODS.test(call)) {
                    return;
                }
                PsiExpression arg = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
                StringCase argCase = MismatchedStringCaseInspection.fromExpression(arg, 16);
                if (argCase.myHasUpper != ThreeState.YES && argCase.myHasLower != ThreeState.YES) {
                    return;
                }
                StringCase qualifierCase = MismatchedStringCaseInspection.fromExpression(qualifier, 16);
                if (qualifierCase.myHasLower == ThreeState.NO && argCase.myHasLower == ThreeState.YES) {
                    problematicCase = "a lowercase";
                    oppositeCase = "uppercase";
                } else if (qualifierCase.myHasUpper == ThreeState.NO && argCase.myHasUpper == ThreeState.YES) {
                    problematicCase = "an uppercase";
                    oppositeCase = "lowercase";
                } else {
                    return;
                }
                PsiElement anchor = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                switch (methodName = anchor.getText()) {
                    case "indexOf": 
                    case "lastIndexOf": {
                        returnValue = "-1";
                        break;
                    }
                    default: {
                        returnValue = "false";
                    }
                }
                String message2 = InspectionGadgetsBundle.message("inspection.case.mismatch.message", methodName, returnValue, problematicCase, oppositeCase);
                holder.registerProblem(anchor, message2, new LocalQuickFix[0]);
            }
        };
    }

    private static class StringCase {
        static final StringCase UNSURE = new StringCase(ThreeState.UNSURE, ThreeState.UNSURE);
        @NotNull
        final ThreeState myHasLower;
        @NotNull
        final ThreeState myHasUpper;

        StringCase(@NotNull ThreeState hasLower, @NotNull ThreeState hasUpper) {
            this.myHasLower = hasLower;
            this.myHasUpper = hasUpper;
        }

        StringCase either(@NotNull StringCase other) {
            ThreeState hasLower;
            ThreeState threeState = this.myHasLower == ThreeState.NO && other.myHasLower == ThreeState.NO ? ThreeState.NO : (hasLower = this.myHasLower == ThreeState.YES && other.myHasLower == ThreeState.YES ? ThreeState.YES : ThreeState.UNSURE);
            ThreeState hasUpper = this.myHasUpper == ThreeState.NO && other.myHasUpper == ThreeState.NO ? ThreeState.NO : (this.myHasUpper == ThreeState.YES && other.myHasUpper == ThreeState.YES ? ThreeState.YES : ThreeState.UNSURE);
            return new StringCase(hasLower, hasUpper);
        }

        StringCase concat(@NotNull StringCase other) {
            ThreeState hasLower;
            ThreeState threeState = this.myHasLower == ThreeState.YES || other.myHasLower == ThreeState.YES ? ThreeState.YES : (hasLower = this.myHasLower == ThreeState.NO && other.myHasLower == ThreeState.NO ? ThreeState.NO : ThreeState.UNSURE);
            ThreeState hasUpper = this.myHasUpper == ThreeState.YES || other.myHasUpper == ThreeState.YES ? ThreeState.YES : (this.myHasUpper == ThreeState.NO && other.myHasUpper == ThreeState.NO ? ThreeState.NO : ThreeState.UNSURE);
            return new StringCase(hasLower, hasUpper);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringCase aCase = (StringCase)o;
            return this.myHasLower == aCase.myHasLower && this.myHasUpper == aCase.myHasUpper;
        }
    }
}

