/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class ShiftOutOfRangeInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        LongRangeSet range = (LongRangeSet)infos[0];
        Long val = range.getConstantValue();
        if (val == null) {
            return InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.out.of.bounds", range.toString());
        }
        if (val > 0L) {
            return InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.too.large", val);
        }
        return InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.negative", val);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        Long val = ((LongRangeSet)infos[0]).getConstantValue();
        if (val == null) {
            return null;
        }
        return new ShiftOutOfRangeFix(val, (Boolean)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ShiftOutOfRange();
    }

    private static class ShiftOutOfRange
    extends BaseInspectionVisitor {
        private ShiftOutOfRange() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            LongRangeSet allowedRange;
            super.visitBinaryExpression(expression2);
            PsiJavaToken sign = expression2.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!(tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT))) {
                return;
            }
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType expressionType = expression2.getType();
            if (expressionType == null) {
                return;
            }
            if (expressionType.equals(PsiType.LONG)) {
                allowedRange = LongRangeSet.range(0L, 63L);
            } else if (expressionType.equals(PsiType.INT)) {
                allowedRange = LongRangeSet.range(0L, 31L);
            } else {
                return;
            }
            LongRangeSet actualRange = CommonDataflow.getExpressionRange(rhs);
            if (actualRange != null && !actualRange.isEmpty() && !actualRange.intersects(allowedRange)) {
                this.registerError((PsiElement)sign, actualRange, expressionType.equals(PsiType.LONG));
            }
        }
    }

    private static class ShiftOutOfRangeFix
    extends InspectionGadgetsFix {
        private final long myValue;
        private final boolean myLong;

        ShiftOutOfRangeFix(long value2, boolean isLong) {
            this.myValue = value2;
            this.myLong = isLong;
        }

        @NotNull
        public String getName() {
            int newValue = (int)(this.myValue & (long)(this.myLong ? 63 : 31));
            return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myValue, newValue});
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("shift.out.of.range.fix.family.name", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiBinaryExpression.class);
            if (binaryExpression == null) {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            int mask = PsiType.LONG.equals((Object)lhs.getType()) ? 63 : 31;
            String text2 = String.valueOf(this.myValue & (long)mask);
            new CommentTracker().replaceAndRestoreComments((PsiElement)rhs, text2);
        }
    }
}

