/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class AssignmentToStaticFieldFromInstanceMethodInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("assignment.to.static.field.from.instance.method.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToStaticFieldFromInstanceMethodVisitor();
    }

    private static class AssignmentToStaticFieldFromInstanceMethodVisitor
    extends BaseInspectionVisitor {
        private AssignmentToStaticFieldFromInstanceMethodVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
            super.visitAssignmentExpression(expression2);
            PsiExpression lhs = expression2.getLExpression();
            this.checkForStaticFieldAccess(lhs);
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression2) {
            super.visitUnaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand2 = expression2.getOperand();
            this.checkForStaticFieldAccess(operand2);
        }

        private void checkForStaticFieldAccess(PsiExpression expression2) {
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)expression2).resolve();
            if (referent == null) {
                return;
            }
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField fieldReferenced = (PsiField)referent;
            if (!fieldReferenced.hasModifierProperty("static")) {
                return;
            }
            if (AssignmentToStaticFieldFromInstanceMethodVisitor.isInStaticMember((PsiElement)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static boolean isInStaticMember(PsiElement element) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiField.class});
            if (member == null) {
                return false;
            }
            return member.hasModifierProperty("static");
        }
    }
}

