/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiteralFormatUtil {
    private static final CharFilter UNDERSCORES_FILTER = ch -> ch != '_';

    private LiteralFormatUtil() {
    }

    @NotNull
    public static String removeUnderscores(@NotNull String text2) {
        return StringUtil.strip((String)text2, (CharFilter)UNDERSCORES_FILTER);
    }

    @NotNull
    public static String format(@NotNull String original, @Nullable PsiType type2) {
        boolean isFP = PsiType.FLOAT.equals((Object)type2) || PsiType.DOUBLE.equals((Object)type2);
        String text2 = original;
        String prefix = "";
        String suffix = "";
        int groupSize = 3;
        if (text2.startsWith("0x") || text2.startsWith("0X") || text2.startsWith("0b") || text2.startsWith("0B")) {
            prefix = text2.substring(0, 2);
            text2 = text2.substring(2);
            groupSize = 4;
        }
        if (text2.length() == 0) {
            return original;
        }
        char last = text2.charAt(text2.length() - 1);
        if (StringUtil.containsChar((String)"Ll", (char)last) || isFP && StringUtil.containsChar((String)"FfDd", (char)last)) {
            int pos = text2.length() - 1;
            suffix = text2.substring(pos);
            text2 = text2.substring(0, pos);
        }
        if (text2.length() == 0) {
            return original;
        }
        boolean hasPoint = false;
        String fractional = "";
        String exponentMark = "";
        String exponent = "";
        if (isFP) {
            int pos = StringUtil.indexOfAny((String)text2, (String)("0x".equals(prefix) || "0X".equals(prefix) ? "Pp" : "Ee"));
            if (pos >= 0) {
                int pos2 = Math.max(StringUtil.indexOfAny((String)text2, (String)"+-", (int)pos, (int)text2.length()), pos) + 1;
                exponentMark = text2.substring(pos, pos2);
                exponent = text2.substring(pos2);
                text2 = text2.substring(0, pos);
            }
            if ((pos = text2.indexOf(46)) >= 0) {
                hasPoint = true;
                fractional = text2.substring(pos + 1);
                text2 = text2.substring(0, pos);
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        LiteralFormatUtil.appendFromEnd(buffer, text2, groupSize);
        if (isFP) {
            if (hasPoint) {
                buffer.append('.');
            }
            LiteralFormatUtil.appendFromStart(buffer, fractional, groupSize);
            buffer.append(exponentMark);
            LiteralFormatUtil.appendFromEnd(buffer, exponent, 3);
        }
        buffer.append(suffix);
        return buffer.toString();
    }

    private static void appendFromEnd(StringBuilder buffer, String original, int groupSize) {
        int pointer;
        int position = buffer.length();
        for (pointer = original.length(); pointer > groupSize; pointer -= groupSize) {
            buffer.insert(position, original.substring(pointer - groupSize, pointer));
            buffer.insert(position, '_');
        }
        if (pointer > 0) {
            buffer.insert(position, original.substring(0, pointer));
        }
    }

    private static void appendFromStart(StringBuilder buffer, String original, int groupSize) {
        int pointer = 0;
        while (pointer + groupSize < original.length()) {
            buffer.append(original, pointer, pointer + groupSize);
            buffer.append('_');
            pointer += groupSize;
        }
        if (pointer < original.length()) {
            buffer.append(original.substring(pointer));
        }
    }
}

