/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacerUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReplaceHandler
extends StructuralReplaceHandler {
    private final PsiElement[] patternElements;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ReplaceOptions myReplaceOptions;

    public JavaReplaceHandler(@NotNull Project project, @NotNull ReplaceOptions replaceOptions) {
        this.myProject = project;
        this.myReplaceOptions = replaceOptions;
        MatchOptions matchOptions = replaceOptions.getMatchOptions();
        this.patternElements = MatcherImplUtil.createTreeFromText((String)matchOptions.getSearchPattern(), (PatternTreeContext)PatternTreeContext.Block, (LanguageFileType)matchOptions.getFileType(), (Project)project);
    }

    private static boolean isListContext(PsiElement element) {
        if (element instanceof PsiParameter || element instanceof PsiClass) {
            return true;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiExpressionList && !parent.getClass().getSimpleName().startsWith("Jsp") || parent instanceof PsiCodeBlock || parent instanceof PsiCodeFragment || parent instanceof PsiClass || parent instanceof PsiIfStatement && (((PsiIfStatement)parent).getThenBranch() == element || ((PsiIfStatement)parent).getElseBranch() == element) || parent instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == element;
    }

    @Nullable
    private PsiNamedElement getSymbolReplacementTarget(PsiElement el) {
        PsiExpression expression2;
        if (this.patternElements.length == 1 && this.patternElements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)this.patternElements[0]).getExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).getQualifierExpression() == null && el instanceof PsiNamedElement) {
            return (PsiNamedElement)el;
        }
        return null;
    }

    private static PsiElement getMatchExpr(PsiElement replacement, PsiElement elementToReplace) {
        if (replacement instanceof PsiExpressionStatement && !(replacement.getLastChild() instanceof PsiJavaToken) && !(replacement.getLastChild() instanceof PsiComment)) {
            replacement = ((PsiExpressionStatement)replacement).getExpression();
        } else {
            if (replacement instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)replacement).getDeclaredElements().length == 1 && (elementToReplace instanceof PsiVariable || elementToReplace instanceof PsiClass)) {
                return ((PsiDeclarationStatement)replacement).getDeclaredElements()[0];
            }
            if (replacement instanceof PsiBlockStatement && elementToReplace instanceof PsiCodeBlock) {
                return ((PsiBlockStatement)replacement).getCodeBlock();
            }
        }
        return replacement;
    }

    private boolean isSymbolReplacement(PsiElement el) {
        return this.getSymbolReplacementTarget(el) != null;
    }

    private void copyUnmatchedElements(PsiElement original, PsiElement replacement, ReplacementInfo info) {
        Map<String, PsiElement> originalNamedElements = JavaReplaceHandler.collectNamedElements(original);
        Map<String, PsiElement> replacedNamedElements = JavaReplaceHandler.collectNamedElements(replacement);
        if (originalNamedElements.isEmpty() && replacedNamedElements.isEmpty()) {
            Replacer.handleComments((PsiElement)original, (PsiElement)replacement, (ReplacementInfo)info);
            return;
        }
        Map<String, PsiElement> patternNamedElements = JavaReplaceHandler.collectNamedElements(this.patternElements);
        for (String name2 : originalNamedElements.keySet()) {
            PsiElement originalNamedElement = originalNamedElements.get(name2);
            PsiElement replacementNamedElement = replacedNamedElements.get(name2);
            PsiElement patternNamedElement = (PsiElement)ObjectUtils.coalesce((Object)patternNamedElements.get(name2), (Object)patternNamedElements.get('$' + info.getSearchPatternName(name2) + '$'));
            if (patternNamedElement == null) continue;
            if (replacementNamedElement == null && originalNamedElements.size() == 1 && replacedNamedElements.size() == 1) {
                replacementNamedElement = replacedNamedElements.entrySet().iterator().next().getValue();
            }
            PsiDocComment comment = null;
            if (originalNamedElement instanceof PsiDocCommentOwner && (comment = ((PsiDocCommentOwner)originalNamedElement).getDocComment()) == null) {
                PsiElement prevElement = originalNamedElement.getPrevSibling();
                if (prevElement instanceof PsiWhiteSpace) {
                    prevElement = prevElement.getPrevSibling();
                }
                if (prevElement instanceof PsiComment) {
                    comment = prevElement;
                }
            }
            if (replacementNamedElement != null) {
                Replacer.handleComments((PsiElement)originalNamedElement, (PsiElement)replacementNamedElement, (ReplacementInfo)info);
            }
            if (comment != null && replacementNamedElement instanceof PsiDocCommentOwner && !(replacementNamedElement.getFirstChild() instanceof PsiDocComment)) {
                PsiElement nextSibling = comment.getNextSibling();
                PsiElement prevSibling = comment.getPrevSibling();
                replacementNamedElement.addRangeBefore((PsiElement)(prevSibling instanceof PsiWhiteSpace ? prevSibling : comment), (PsiElement)(nextSibling instanceof PsiWhiteSpace ? nextSibling : comment), replacementNamedElement.getFirstChild());
            }
            if (originalNamedElement instanceof PsiAnnotation && patternNamedElement instanceof PsiAnnotation && replacementNamedElement instanceof PsiAnnotation) {
                this.copyAnnotationParameters((PsiAnnotation)originalNamedElement, (PsiAnnotation)patternNamedElement, (PsiAnnotation)replacementNamedElement);
            }
            if (originalNamedElement instanceof PsiModifierListOwner && patternNamedElement instanceof PsiModifierListOwner && replacementNamedElement instanceof PsiModifierListOwner) {
                this.copyModifiersAndAnnotations((PsiModifierListOwner)originalNamedElement, (PsiModifierListOwner)patternNamedElement, (PsiModifierListOwner)replacementNamedElement);
            }
            if (originalNamedElement instanceof PsiMethod && patternNamedElement instanceof PsiMethod && replacementNamedElement instanceof PsiMethod) {
                JavaReplaceHandler.copyMethodBodyIfNotReplaced((PsiMethod)originalNamedElement, (PsiMethod)patternNamedElement, (PsiMethod)replacementNamedElement);
            }
            if (originalNamedElement instanceof PsiVariable && patternNamedElement instanceof PsiVariable && replacementNamedElement instanceof PsiVariable) {
                PsiVariable originalVariable = (PsiVariable)originalNamedElement;
                PsiVariable queryVariable = (PsiVariable)patternNamedElement;
                PsiVariable replacementVariable = (PsiVariable)replacementNamedElement;
                if (originalVariable.hasInitializer() && !queryVariable.hasInitializer() && !replacementVariable.hasInitializer()) {
                    replacementVariable.setInitializer(originalVariable.getInitializer());
                }
            }
            if (!(originalNamedElement instanceof PsiClass) || !(patternNamedElement instanceof PsiClass) || !(replacementNamedElement instanceof PsiClass)) continue;
            PsiClass originalClass = (PsiClass)originalNamedElement;
            PsiClass queryClass = (PsiClass)patternNamedElement;
            PsiClass replacementClass = (PsiClass)replacementNamedElement;
            JavaReplaceHandler.copyClassType(originalClass, queryClass, replacementClass);
            JavaReplaceHandler.copyExtendsListIfNotReplaced(originalClass, queryClass, replacementClass);
            JavaReplaceHandler.copyImplementsListIfNotReplaced(originalClass, queryClass, replacementClass);
            JavaReplaceHandler.copyTypeParameterListIfNotReplaced(originalClass, queryClass, replacementClass);
            JavaReplaceHandler.copyUnmatchedMembers(originalClass, originalNamedElements, replacementClass);
        }
    }

    private static void copyClassType(PsiClass originalClass, PsiClass patternClass, PsiClass replacementClass) {
        if (replacementClass.isEnum() || replacementClass.isAnnotationType() || replacementClass.isInterface()) {
            return;
        }
        if (originalClass.isEnum() && !patternClass.isEnum()) {
            JavaReplaceHandler.transform(replacementClass, ClassType.ENUM);
        } else if (originalClass.isAnnotationType() && !patternClass.isAnnotationType()) {
            JavaReplaceHandler.transform(replacementClass, ClassType.ANNOTATION);
        } else if (originalClass.isInterface() && !patternClass.isInterface()) {
            JavaReplaceHandler.transform(replacementClass, ClassType.INTERFACE);
        }
    }

    private static void transform(PsiClass replacementClass, ClassType type2) {
        PsiClass aClass;
        PsiIdentifier nameIdentifier = replacementClass.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PsiKeyword classKeyword = (PsiKeyword)PsiTreeUtil.getPrevSiblingOfType((PsiElement)nameIdentifier, PsiKeyword.class);
        if (classKeyword == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)replacementClass.getProject());
        switch (type2) {
            case ANNOTATION: {
                aClass = factory.createAnnotationType("X");
                break;
            }
            case ENUM: {
                aClass = factory.createEnum("X");
                break;
            }
            case INTERFACE: {
                aClass = factory.createInterface("X");
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        PsiIdentifier identifier = aClass.getNameIdentifier();
        PsiKeyword newKeyword = (PsiKeyword)PsiTreeUtil.getPrevSiblingOfType((PsiElement)identifier, PsiKeyword.class);
        assert (newKeyword != null);
        PsiElement replacement = classKeyword.replace((PsiElement)newKeyword);
        PsiElement atToken = newKeyword.getPrevSibling();
        if (atToken != null) {
            replacementClass.addBefore(atToken, replacement);
        }
    }

    private static void copyUnmatchedMembers(PsiClass originalClass, Map<String, PsiElement> originalNamedElements, PsiClass replacementClass) {
        List elements = (List)originalClass.getUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY);
        if (elements == null) {
            return;
        }
        List anchors = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)replacementClass, PsiNamedElement.class);
        block0: for (PsiNamedElement anchor : anchors) {
            String replacedMemberName = anchor.getName();
            PsiElement originalMember = originalNamedElements.get(replacedMemberName);
            if (originalMember == null) continue;
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                PsiElement element = (PsiElement)iterator.next();
                if (PsiElementOrderComparator.getInstance().compare(element, originalMember) >= 0) continue block0;
                JavaReplaceHandler.addElementAndWhitespaceBeforeAnchor(replacementClass, element, (PsiElement)anchor);
                iterator.remove();
            }
        }
        PsiElement anchor = replacementClass.getRBrace();
        if (anchor == null) {
            return;
        }
        for (PsiElement element : elements) {
            JavaReplaceHandler.addElementAndWhitespaceBeforeAnchor(replacementClass, element, anchor);
        }
    }

    private static void addElementAndWhitespaceBeforeAnchor(PsiClass replacementClass, PsiElement element, PsiElement anchor) {
        PsiElement prevSibling;
        PsiElement replacementSibling = anchor.getPrevSibling();
        if (replacementSibling instanceof PsiWhiteSpace) {
            replacementSibling.delete();
        }
        if ((prevSibling = element.getPrevSibling()) instanceof PsiWhiteSpace || PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
            PsiElement prevPrevSibling = prevSibling.getPrevSibling();
            if (PsiUtil.isJavaToken((PsiElement)prevPrevSibling, (IElementType)JavaTokenType.COMMA)) {
                replacementClass.addBefore(prevPrevSibling, anchor);
            }
            replacementClass.addBefore(prevSibling, anchor);
        }
        replacementClass.addBefore(element, anchor);
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling instanceof PsiWhiteSpace) {
            replacementClass.addBefore(nextSibling, anchor);
        }
    }

    private static void copyMethodBodyIfNotReplaced(PsiMethod original, PsiMethod query, PsiMethod replacement) {
        PsiCodeBlock originalBody = original.getBody();
        if (originalBody != null && query.getBody() == null && replacement.getBody() == null) {
            PsiElement sibling = originalBody.getPrevSibling();
            if (sibling instanceof PsiWhiteSpace) {
                replacement.add(sibling);
            }
            replacement.add((PsiElement)originalBody);
        }
    }

    private void copyAnnotationParameters(PsiAnnotation original, PsiAnnotation query, PsiAnnotation replacement) {
        PsiAnnotationParameterList originalParameters = original.getParameterList();
        if (originalParameters.getTextLength() > 0) {
            PsiAnnotationParameterList replacementParameters = replacement.getParameterList();
            if (query.getParameterList().getTextLength() == 0 && replacementParameters.getTextLength() == 0) {
                replacementParameters.replace((PsiElement)originalParameters);
                return;
            }
            List unmatchedAttributes = (List)original.getUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY);
            if (unmatchedAttributes != null) {
                for (PsiElement attribute : unmatchedAttributes) {
                    replacementParameters.add((PsiElement)this.whiteSpace(attribute.getPrevSibling(), " "));
                    replacementParameters.add(attribute);
                }
            }
        }
    }

    private void copyModifiersAndAnnotations(PsiModifierListOwner original, PsiModifierListOwner query, PsiModifierListOwner replacement) {
        PsiModifierList originalModifierList = original.getModifierList();
        PsiModifierList queryModifierList = query.getModifierList();
        PsiModifierList replacementModifierList = replacement.getModifierList();
        if (originalModifierList == null || queryModifierList == null || replacementModifierList == null) {
            return;
        }
        if (queryModifierList.getTextLength() == 0 && replacementModifierList.getTextLength() == 0) {
            replacementModifierList.replace((PsiElement)originalModifierList);
            return;
        }
        List unmatchedAnnotations = (List)originalModifierList.getUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY);
        PsiElement anchor = replacementModifierList.getFirstChild();
        boolean append = anchor == null;
        for (PsiElement child = originalModifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiKeyword) {
                append = true;
                String modifierText = child.getText();
                if (!JavaReplaceHandler.isCompatibleModifier(modifierText, replacementModifierList) || queryModifierList.hasExplicitModifier(modifierText)) continue;
                if (anchor != null) {
                    replacementModifierList.add((PsiElement)this.whiteSpace(child.getPrevSibling(), " "));
                }
                replacementModifierList.add(child);
                continue;
            }
            if (!(child instanceof PsiAnnotation) || unmatchedAnnotations != null && !unmatchedAnnotations.contains(child)) continue;
            if (append) {
                if (anchor != null) {
                    replacementModifierList.add((PsiElement)this.whiteSpace(child.getPrevSibling(), " "));
                }
                replacementModifierList.add(child);
                continue;
            }
            PsiElement next = replacementModifierList.addBefore(child, anchor).getNextSibling();
            PsiWhiteSpace whiteSpace = this.whiteSpace(child.getNextSibling(), " ");
            if (!(next instanceof PsiWhiteSpace)) {
                replacementModifierList.addBefore((PsiElement)whiteSpace, anchor);
                continue;
            }
            next.replace((PsiElement)whiteSpace);
        }
    }

    private PsiWhiteSpace whiteSpace(PsiElement element, String defaultWs) {
        return element instanceof PsiWhiteSpace ? (PsiWhiteSpace)element : (PsiWhiteSpace)PsiParserFacade.SERVICE.getInstance((Project)this.myProject).createWhiteSpaceFromText(defaultWs);
    }

    private static boolean isCompatibleModifier(String modifier, PsiModifierList modifierList) {
        if ("public".equals(modifier) || "protected".equals(modifier) || "private".equals(modifier)) {
            return !modifierList.hasExplicitModifier("public") && !modifierList.hasExplicitModifier("protected") && !modifierList.hasExplicitModifier("private");
        }
        return true;
    }

    private PsiElement handleSymbolReplacement(PsiElement replacement, PsiElement el) {
        PsiNamedElement nameElement = this.getSymbolReplacementTarget(el);
        if (nameElement != null) {
            PsiElement oldReplacement = replacement;
            replacement = el.copy();
            ((PsiNamedElement)replacement).setName(oldReplacement.getText());
        }
        return replacement;
    }

    public void replace(ReplacementInfo info, ReplaceOptions options) {
        PsiElement replacement;
        PsiElement elementToReplace = StructuralSearchUtil.getPresentableElement((PsiElement)info.getMatch(0));
        if (elementToReplace == null) {
            return;
        }
        PsiElement elementParent = elementToReplace.getParent();
        String replacementToMake = info.getReplacement();
        boolean listContext = JavaReplaceHandler.isListContext(elementToReplace);
        if (elementToReplace instanceof PsiAnnotation && !replacementToMake.isEmpty() && !StringUtil.startsWithChar((CharSequence)replacementToMake, (char)'@')) {
            replacementToMake = "@" + replacementToMake;
        }
        PsiElement[] replacements = MatcherImplUtil.createTreeFromText((String)replacementToMake, (PatternTreeContext)(elementToReplace instanceof PsiMember && !this.isSymbolReplacement(elementToReplace) ? PatternTreeContext.Class : PatternTreeContext.Block), (LanguageFileType)this.myReplaceOptions.getMatchOptions().getFileType(), (Project)this.myProject);
        if (elementToReplace instanceof PsiAnnotation && replacements.length == 1) {
            PsiDeclarationStatement declarationStatement;
            PsiElement firstChild;
            PsiElement replacement2 = replacements[0];
            if (replacement2 instanceof PsiDeclarationStatement && (firstChild = (declarationStatement = (PsiDeclarationStatement)replacement2).getFirstChild()) instanceof PsiModifierList) {
                this.copyUnmatchedElements(elementToReplace, replacement2, info);
                PsiModifierList modifierList = (PsiModifierList)firstChild;
                for (PsiElement child : modifierList.getChildren()) {
                    elementParent.addBefore(child, elementToReplace);
                }
            }
            elementToReplace.delete();
            return;
        }
        if (listContext) {
            if (replacements.length > 1) {
                replacement = elementParent.addRangeBefore(replacements[0], replacements[replacements.length - 1], elementToReplace);
                this.copyUnmatchedElements(elementToReplace, replacement, info);
            } else if (replacements.length == 1) {
                replacement = JavaReplaceHandler.getMatchExpr(replacements[0], elementToReplace);
                if (elementToReplace instanceof PsiParameter && replacement instanceof PsiLocalVariable) {
                    PsiVariable variable = (PsiVariable)replacement;
                    PsiIdentifier identifier = variable.getNameIdentifier();
                    assert (identifier != null);
                    String text2 = variable.getText();
                    String parameterText = text2.substring(0, identifier.getStartOffsetInParent() + identifier.getTextLength());
                    replacement = JavaPsiFacade.getElementFactory((Project)variable.getProject()).createParameterFromText(parameterText, (PsiElement)variable);
                }
                PsiElement patternElement = this.patternElements[0];
                if (elementToReplace instanceof PsiAnonymousClass && patternElement instanceof PsiClass && !(patternElement instanceof PsiAnonymousClass) && replacement instanceof PsiClass && !(replacement instanceof PsiAnonymousClass)) {
                    PsiTypeParameterList parameterList;
                    PsiAnonymousClass anonymousClass = (PsiAnonymousClass)elementToReplace;
                    PsiClass replacementClass = (PsiClass)replacement;
                    PsiExpressionList argumentList = anonymousClass.getArgumentList();
                    PsiElement brace = replacementClass.getLBrace();
                    assert (brace != null);
                    String typeParametersText = "";
                    if (!replacementClass.hasTypeParameters()) {
                        if (!((PsiClass)patternElement).hasTypeParameters() && (parameterList = anonymousClass.getBaseClassReference().getParameterList()) != null) {
                            typeParametersText = parameterList.getText();
                        }
                    } else {
                        parameterList = replacementClass.getTypeParameterList();
                        if (parameterList != null) {
                            typeParametersText = parameterList.getText();
                        }
                    }
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)elementToReplace.getProject());
                    PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText("new " + replacementClass.getName() + typeParametersText + (argumentList == null ? "()" : argumentList.getText()) + replacementClass.getText().substring(brace.getStartOffsetInParent()), elementToReplace);
                    replacement = newExpression.getAnonymousClass();
                    assert (replacement != null);
                }
                this.copyUnmatchedElements(elementToReplace, replacement, info);
                replacement = this.handleSymbolReplacement(replacement, elementToReplace);
                if (replacement instanceof PsiTryStatement) {
                    PsiTryStatement tryStatement = (PsiTryStatement)replacement;
                    List unmatchedElements = (List)elementToReplace.getUserData(GlobalMatchingVisitor.UNMATCHED_ELEMENTS_KEY);
                    if (unmatchedElements != null) {
                        PsiElement firstElement = (PsiElement)unmatchedElements.get(0);
                        if (firstElement instanceof PsiResourceList) {
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, firstElement, tryStatement.getFirstChild());
                        }
                        block3: for (PsiElement element : unmatchedElements) {
                            if (!(element instanceof PsiCatchSection)) continue;
                            PsiCatchSection[] catches = tryStatement.getCatchSections();
                            PsiCatchSection catchSection = (PsiCatchSection)element;
                            if (catches.length == 0) {
                                JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, element, (PsiElement)tryStatement.getTryBlock());
                                continue;
                            }
                            PsiType newType = catchSection.getCatchType();
                            for (PsiCatchSection existingCatch : catches) {
                                PsiType existingType = existingCatch.getCatchType();
                                if (existingType == null || newType == null || !existingType.isAssignableFrom(newType)) continue;
                                JavaReplaceHandler.addElementBeforeAnchor((PsiElement)tryStatement, element, (PsiElement)existingCatch);
                                continue block3;
                            }
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, element, (PsiElement)catches[catches.length - 1]);
                        }
                        PsiElement lastElement = (PsiElement)unmatchedElements.get(unmatchedElements.size() - 1);
                        if (lastElement instanceof PsiCodeBlock) {
                            PsiElement finallyKeyword = PsiTreeUtil.skipWhitespacesBackward((PsiElement)lastElement);
                            assert (finallyKeyword != null);
                            PsiElement finallyAnchor = tryStatement.getLastChild();
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, lastElement, finallyAnchor);
                            JavaReplaceHandler.addElementAfterAnchor((PsiElement)tryStatement, finallyKeyword, finallyAnchor);
                        }
                    }
                }
                try {
                    PsiElement inserted = elementParent.addBefore(replacement, elementToReplace);
                    if (replacement instanceof PsiComment && (elementParent instanceof PsiIfStatement || elementParent instanceof PsiLoopStatement)) {
                        elementParent.addAfter(JavaReplaceHandler.createSemicolon(replacement), inserted);
                    }
                }
                catch (IncorrectOperationException e) {
                    elementToReplace.replace(replacement);
                }
            }
        } else if (replacements.length > 0) {
            replacement = ReplacerUtil.copySpacesAndCommentsBefore((PsiElement)elementToReplace, (PsiElement[])replacements, (String)replacementToMake, (PsiElement)elementParent);
            if ((replacement = JavaReplaceHandler.getMatchExpr(replacement, elementToReplace)) instanceof PsiStatement && !(replacement.getLastChild() instanceof PsiJavaToken) && !(replacement.getLastChild() instanceof PsiComment)) {
                PsiElement prevLastChildInParent = replacement.getLastChild().getPrevSibling();
                if (prevLastChildInParent != null) {
                    elementParent.addRangeBefore(replacement.getFirstChild(), prevLastChildInParent, elementToReplace);
                } else {
                    elementParent.addBefore(replacement.getFirstChild(), elementToReplace);
                }
                elementToReplace.getNode().getTreeParent().removeChild(elementToReplace.getNode());
            } else {
                this.copyUnmatchedElements(elementToReplace, replacement, info);
                replacement = this.handleSymbolReplacement(replacement, elementToReplace);
                elementToReplace.replace(replacement);
            }
        } else {
            PsiElement nextSibling = elementToReplace.getNextSibling();
            elementToReplace.delete();
            if (nextSibling instanceof PsiWhiteSpace && nextSibling.isValid()) {
                nextSibling.delete();
            }
        }
        if (listContext) {
            int matchSize = info.getMatchesCount();
            for (int i = 0; i < matchSize; ++i) {
                PsiElement matchElement = info.getMatch(i);
                PsiElement element = StructuralSearchUtil.getPresentableElement((PsiElement)matchElement);
                if (element == null) continue;
                PsiElement firstToDelete = element;
                PsiElement lastToDelete = element;
                PsiElement prevSibling = element.getPrevSibling();
                PsiElement nextSibling = element.getNextSibling();
                if (prevSibling instanceof PsiWhiteSpace) {
                    firstToDelete = prevSibling;
                    prevSibling = prevSibling.getPrevSibling();
                } else if (prevSibling == null && nextSibling instanceof PsiWhiteSpace) {
                    lastToDelete = nextSibling;
                }
                if (element instanceof PsiExpression) {
                    PsiElement parent = element.getParent().getParent();
                    if ((parent instanceof PsiCall || parent instanceof PsiAnonymousClass) && PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                        firstToDelete = prevSibling;
                    }
                } else if (element instanceof PsiParameter && PsiUtil.isJavaToken((PsiElement)prevSibling, (IElementType)JavaTokenType.COMMA)) {
                    firstToDelete = prevSibling;
                } else if (element instanceof PsiField) {
                    while (PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.COMMA)) {
                        lastToDelete = PsiTreeUtil.skipWhitespacesForward((PsiElement)nextSibling);
                        nextSibling = PsiTreeUtil.skipWhitespacesForward((PsiElement)lastToDelete);
                    }
                }
                element.getParent().deleteChildRange(firstToDelete, lastToDelete);
            }
        }
    }

    private static void copyTypeParameterListIfNotReplaced(PsiClass original, PsiClass query, PsiClass replacement) {
        PsiTypeParameterList originalTypeParameterList = original.getTypeParameterList();
        PsiTypeParameterList queryTypeParameterList = query.getTypeParameterList();
        PsiTypeParameterList replacementTypeParameterList = replacement.getTypeParameterList();
        if (originalTypeParameterList == null || queryTypeParameterList == null || replacementTypeParameterList == null) {
            return;
        }
        if (originalTypeParameterList.getTypeParameters().length != 0 && queryTypeParameterList.getTypeParameters().length == 0 && replacementTypeParameterList.getTypeParameters().length == 0) {
            replacementTypeParameterList.replace((PsiElement)originalTypeParameterList);
        }
    }

    private static void copyImplementsListIfNotReplaced(PsiClass original, PsiClass query, PsiClass replacement) {
        JavaReplaceHandler.copyReferenceListIfNotReplaced(original.getImplementsList(), query.getImplementsList(), replacement.getImplementsList());
    }

    private static void copyExtendsListIfNotReplaced(PsiClass original, PsiClass query, PsiClass replacement) {
        JavaReplaceHandler.copyReferenceListIfNotReplaced(original.getExtendsList(), query.getExtendsList(), replacement.getExtendsList());
    }

    private static void copyReferenceListIfNotReplaced(PsiReferenceList originalReferenceList, PsiReferenceList queryReferenceList, PsiReferenceList replacementReferenceList) {
        if (originalReferenceList == null || queryReferenceList == null || replacementReferenceList == null) {
            return;
        }
        if (originalReferenceList.getReferenceElements().length != 0 && queryReferenceList.getReferenceElements().length == 0 && replacementReferenceList.getReferenceElements().length == 0) {
            replacementReferenceList.replace((PsiElement)originalReferenceList);
        }
    }

    private static void addElementAfterAnchor(PsiElement parentElement, PsiElement element, PsiElement anchor) {
        parentElement.addAfter(element, anchor);
        PsiElement sibling = element.getPrevSibling();
        if (sibling instanceof PsiWhiteSpace) {
            parentElement.addAfter(sibling, anchor);
        }
    }

    private static void addElementBeforeAnchor(PsiElement parentElement, PsiElement element, PsiElement anchor) {
        PsiElement sibling = element.getPrevSibling().copy();
        parentElement.addBefore(element, anchor);
        if (sibling instanceof PsiWhiteSpace) {
            parentElement.addBefore(sibling, anchor);
        }
    }

    public void postProcess(PsiElement affectedElement, ReplaceOptions options) {
        if (!affectedElement.isValid()) {
            return;
        }
        if (this.myReplaceOptions.isToUseStaticImport()) {
            JavaReplaceHandler.shortenWithStaticImports(affectedElement, 0, affectedElement.getTextLength());
        }
        if (this.myReplaceOptions.isToShortenFQN()) {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)affectedElement.getProject());
            codeStyleManager.shortenClassReferences(affectedElement, 0, affectedElement.getTextLength());
        }
    }

    private static void shortenWithStaticImports(PsiElement affectedElement, int startOffset, int endOffset) {
        int elementOffset = affectedElement.getTextOffset();
        final int finalStartOffset = startOffset + elementOffset;
        final int finalEndOffset = endOffset + elementOffset;
        SmartList references = new SmartList();
        JavaRecursiveElementVisitor collector = new JavaRecursiveElementVisitor((List)references){
            final /* synthetic */ List val$references;
            {
                this.val$references = list;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                int offset = reference.getTextOffset();
                if (offset > finalEndOffset) {
                    return;
                }
                super.visitReferenceElement(reference);
                if (offset + reference.getTextLength() < finalStartOffset) {
                    return;
                }
                if (reference.getTypeParameters().length != 0 || reference instanceof PsiMethodReferenceExpression) {
                    return;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiMember)) {
                    return;
                }
                PsiMember member = (PsiMember)target;
                if (!member.hasModifierProperty("static")) {
                    return;
                }
                if (reference.getQualifier() == null) {
                    return;
                }
                this.val$references.add(reference);
            }
        };
        affectedElement.accept((PsiElementVisitor)collector);
        for (PsiJavaCodeReferenceElement expression2 : references) {
            PsiElement qualifier;
            String name2;
            String className2;
            PsiMember member;
            PsiClass containingClass;
            PsiElement target = expression2.resolve();
            if (!(target instanceof PsiMember) || (containingClass = (member = (PsiMember)target).getContainingClass()) == null || (className2 = containingClass.getQualifiedName()) == null || (name2 = member.getName()) == null || !ImportUtils.addStaticImport(className2, name2, (PsiElement)expression2) || (qualifier = expression2.getQualifier()) == null) continue;
            qualifier.delete();
        }
    }

    private static PsiElement createSemicolon(PsiElement space) {
        return JavaPsiFacade.getElementFactory((Project)space.getProject()).createStatementFromText(";", null).getFirstChild();
    }

    public static Map<String, PsiElement> collectNamedElements(PsiElement ... elements) {
        Collector collector = new Collector();
        for (PsiElement element : elements) {
            element.accept((PsiElementVisitor)collector);
        }
        return collector.namedElements;
    }

    private static class Collector
    extends JavaRecursiveElementWalkingVisitor {
        private final HashMap<String, PsiElement> namedElements = new HashMap(1);

        private Collector() {
        }

        public void visitClass(PsiClass aClass) {
            if (aClass instanceof PsiAnonymousClass) {
                PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
                String name2 = anonymousClass.getBaseClassReference().getReferenceName();
                if (!this.namedElements.containsKey(name2)) {
                    this.namedElements.put(name2, (PsiElement)aClass);
                }
            } else {
                this.handleNamedElement((PsiNamedElement)aClass);
            }
        }

        private void handleNamedElement(PsiNamedElement named) {
            String name2 = named.getName();
            if (!this.namedElements.containsKey(name2)) {
                this.namedElements.put(name2, (PsiElement)named);
                named.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitVariable(PsiVariable var) {
            this.handleNamedElement((PsiNamedElement)var);
        }

        public void visitMethod(PsiMethod method) {
            this.handleNamedElement((PsiNamedElement)method);
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            String name2;
            PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
            if (referenceElement != null && !this.namedElements.containsKey(name2 = referenceElement.getText())) {
                this.namedElements.put(name2, (PsiElement)annotation);
                super.visitAnnotation(annotation);
            }
        }
    }

    static enum ClassType {
        ENUM,
        INTERFACE,
        ANNOTATION;

    }
}

