/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.java.JavaBundle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spi.SPIFileType;
import com.intellij.spi.psi.SPIClassProviderReferenceElement;
import org.jetbrains.annotations.NotNull;

public class SPIAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file != null && file.getFileType() instanceof SPIFileType) {
            String serviceProviderName = file.getName();
            PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)element.getManager(), (String)serviceProviderName, null, (boolean)true, (GlobalSearchScope)element.getContainingFile().getResolveScope());
            if (element instanceof PsiFile) {
                if (psiClass == null) {
                    holder.newAnnotation(HighlightSeverity.ERROR, JavaBundle.message((String)"spi.no.provider.error.message", (Object[])new Object[]{serviceProviderName})).fileLevel().create();
                }
            } else if (element instanceof SPIClassProviderReferenceElement) {
                PsiElement resolve2 = ((SPIClassProviderReferenceElement)element).resolve();
                if (resolve2 == null) {
                    holder.newAnnotation(HighlightSeverity.ERROR, AnalysisBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[]{element.getText()})).create();
                } else if (resolve2 instanceof PsiClass && psiClass != null && !((PsiClass)resolve2).isInheritor(psiClass, true)) {
                    holder.newAnnotation(HighlightSeverity.ERROR, JavaBundle.message((String)"spi.extension.error.message", (Object[])new Object[]{serviceProviderName})).create();
                }
            }
        }
    }
}

