/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.java.JavaBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.JavaSliceDereferenceUsage;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUsageCellRendererBase;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.FontUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

class SliceUsageCellRenderer
extends SliceUsageCellRendererBase {
    SliceUsageCellRenderer() {
    }

    public void customizeCellRendererFor(@NotNull SliceUsage sliceUsage) {
        String parentFilterText;
        SliceLanguageSupportProvider foreignSlicing;
        JavaLanguage language;
        String location;
        PsiMethod method;
        PsiClass aClass;
        boolean isForcedLeaf = sliceUsage instanceof JavaSliceDereferenceUsage;
        JavaSliceUsage javaSliceUsage = sliceUsage instanceof JavaSliceUsage ? (JavaSliceUsage)sliceUsage : null;
        TextChunk[] text2 = sliceUsage.getText();
        int length = text2.length;
        for (int i = 0; i < length; ++i) {
            TextChunk textChunk = text2[i];
            SimpleTextAttributes attributes = textChunk.getSimpleAttributesIgnoreBackground();
            if (isForcedLeaf) {
                attributes = attributes.derive(attributes.getStyle(), (Color)JBColor.LIGHT_GRAY, attributes.getBgColor(), attributes.getWaveColor());
            }
            this.append(textChunk.getText(), attributes);
            if (i != 0) continue;
            this.append(FontUtil.spaceAndThinSpace());
        }
        if (javaSliceUsage != null && javaSliceUsage.indexNesting != 0) {
            this.append(" " + JavaBundle.message((String)"slice.usage.message.tracking.container.contents", (Object[])new Object[]{SliceUsageCellRenderer.getContainerName(javaSliceUsage), javaSliceUsage.syntheticField.isEmpty() ? "" : "." + javaSliceUsage.syntheticField}), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        PsiElement element = sliceUsage.getElement();
        while (true) {
            PsiClass psiClass = aClass = (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class)) == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) : method.getContainingClass();
            if (!(aClass instanceof PsiAnonymousClass)) break;
            element = aClass;
        }
        int methodOptions = 4353;
        String string = method != null ? PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)methodOptions, (int)2, (int)2) : (location = aClass != null ? PsiFormatUtil.formatClass((PsiClass)aClass, (int)1) : null);
        if (location != null) {
            SimpleTextAttributes attributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
            this.append(" " + JavaBundle.message((String)"slice.usage.message.location", (Object[])new Object[]{location}), attributes);
        }
        Object object = language = element == null ? JavaLanguage.INSTANCE : element.getLanguage();
        if (language != JavaLanguage.INSTANCE && (foreignSlicing = LanguageSlicing.getProvider((PsiElement)element)) == null) {
            this.append(" " + JavaBundle.message((String)"slice.usage.message.in.file.stopped.here", (Object[])new Object[]{language.getDisplayName()}), SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
        }
        SliceValueFilter filter = sliceUsage.params.valueFilter;
        SliceUsage parent = sliceUsage.getParent();
        SliceValueFilter parentFilter = parent == null ? null : parent.params.valueFilter;
        String filterText = filter == null ? "" : filter.getPresentationText(sliceUsage.getElement());
        String string2 = parentFilterText = parentFilter == null || parent.getElement() == null ? "" : parentFilter.getPresentationText(parent.getElement());
        if (!filterText.isEmpty() && !filterText.equals(parentFilterText)) {
            String message2 = LangBundle.message((String)"slice.analysis.title.filter", (Object[])new Object[]{filterText});
            this.append(" " + message2, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (javaSliceUsage != null && javaSliceUsage.requiresAssertionViolation) {
            this.append(" " + JavaBundle.message((String)"slice.usage.message.assertion.violated", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getContainerName(@NotNull JavaSliceUsage usage) {
        String result = "";
        JavaSliceUsage prev = usage;
        String name2 = "";
        while (usage != null) {
            PsiElement element;
            if (usage.indexNesting != prev.indexNesting) {
                result = name2 + (result.isEmpty() ? "" : ".") + result;
                if (usage.indexNesting == 0) break;
            }
            if ((element = usage.getElement()) instanceof PsiNamedElement) {
                name2 = ((PsiNamedElement)element).getName();
            } else if (element instanceof PsiReference) {
                name2 = ((PsiReference)element).getCanonicalText();
            }
            prev = usage;
            usage = (JavaSliceUsage)usage.getParent();
        }
        return result;
    }
}

