/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.slicer.JavaSliceProvider;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceLeafEquality;
import org.jetbrains.annotations.NotNull;

public class JavaSlicerAnalysisUtil {
    public static final SliceLeafEquality LEAF_ELEMENT_EQUALITY = new SliceLeafEquality(){

        @NotNull
        protected PsiElement substituteElement(@NotNull PsiElement element) {
            PsiElement resolved;
            if (element instanceof PsiJavaReference && (resolved = ((PsiJavaReference)element).resolve()) != null) {
                return resolved;
            }
            return element;
        }
    };

    @NotNull
    public static SliceLeafAnalyzer createLeafAnalyzer() {
        return new SliceLeafAnalyzer(LEAF_ELEMENT_EQUALITY, (SliceLanguageSupportProvider)JavaSliceProvider.getInstance());
    }

    private JavaSlicerAnalysisUtil() {
    }
}

