/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringUtil {
    private static final Logger LOG = Logger.getInstance(RefactoringUtil.class);
    public static final int EXPR_COPY_SAFE = 0;
    public static final int EXPR_COPY_UNSAFE = 1;
    public static final int EXPR_COPY_PROHIBITED = 2;

    private RefactoringUtil() {
    }

    public static boolean isSourceRoot(PsiDirectory directory) {
        if (directory.getManager() == null) {
            return false;
        }
        Project project = directory.getProject();
        VirtualFile virtualFile = directory.getVirtualFile();
        VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getSourceRootForFile(virtualFile);
        return Comparing.equal((Object)virtualFile, (Object)sourceRootForFile);
    }

    public static boolean isInStaticContext(PsiElement element, @Nullable PsiClass aClass) {
        return PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)aClass) != null;
    }

    @Deprecated
    public static boolean isResolvableType(PsiType type2) {
        return !PsiTypesUtil.hasUnresolvedComponents((PsiType)type2);
    }

    public static PsiElement replaceOccurenceWithFieldRef(PsiExpression occurrence, PsiField newField, PsiClass destinationClass) throws IncorrectOperationException {
        PsiManager manager = destinationClass.getManager();
        String fieldName = newField.getName();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiElement element = (PsiElement)occurrence.getUserData(ElementToWorkOn.PARENT);
        PsiVariable psiVariable = facade.getResolveHelper().resolveAccessibleReferencedVariable(fieldName, (PsiElement)(element != null ? element : occurrence));
        PsiElementFactory factory = facade.getElementFactory();
        if (psiVariable != null && psiVariable.equals(newField)) {
            return IntroduceVariableBase.replace(occurrence, factory.createExpressionFromText(fieldName, null), manager.getProject());
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)factory.createExpressionFromText("this." + fieldName, null);
        if (!occurrence.isValid()) {
            return null;
        }
        if (newField.hasModifierProperty("static")) {
            ref.setQualifierExpression((PsiExpression)factory.createReferenceExpression(destinationClass));
        }
        return IntroduceVariableBase.replace(occurrence, (PsiExpression)ref, manager.getProject());
    }

    public static String suggestUniqueVariableName(String baseName, PsiElement place, PsiField fieldToReplace) {
        int index = 0;
        while (true) {
            final String name2 = index > 0 ? baseName + index : baseName;
            PsiManager manager = place.getManager();
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper();
            PsiVariable refVar = helper.resolveAccessibleReferencedVariable(name2, place);
            if (refVar == null || manager.areElementsEquivalent((PsiElement)refVar, (PsiElement)fieldToReplace)) {
                final boolean[] found = new boolean[]{false};
                place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitClass(PsiClass aClass) {
                    }

                    public void visitVariable(PsiVariable variable) {
                        if (name2.equals(variable.getName())) {
                            found[0] = true;
                            this.stopWalking();
                        }
                    }
                });
                if (!found[0]) {
                    return name2;
                }
            }
            ++index;
        }
    }

    @Nullable
    public static String suggestNewOverriderName(String oldOverriderName, String oldBaseName, String newBaseName) {
        if (oldOverriderName.equals(oldBaseName)) {
            return newBaseName;
        }
        int i = oldOverriderName.startsWith(oldBaseName) ? 0 : StringUtil.indexOfIgnoreCase((String)oldOverriderName, (String)oldBaseName, (int)0);
        if (i >= 0) {
            String newOverriderName = oldOverriderName.substring(0, i);
            newOverriderName = Character.isUpperCase(oldOverriderName.charAt(i)) ? newOverriderName + StringUtil.capitalize((String)newBaseName) : newOverriderName + newBaseName;
            int j = i + oldBaseName.length();
            if (j < oldOverriderName.length()) {
                newOverriderName = newOverriderName + oldOverriderName.substring(j);
            }
            return newOverriderName;
        }
        return null;
    }

    public static boolean hasOnDemandStaticImport(PsiElement element, PsiClass aClass) {
        PsiImportList importList;
        if (element.getContainingFile() instanceof PsiJavaFile && (importList = ((PsiJavaFile)element.getContainingFile()).getImportList()) != null) {
            PsiImportStaticStatement[] importStaticStatements = importList.getImportStaticStatements();
            return Arrays.stream(importStaticStatements).anyMatch(stmt -> stmt.isOnDemand() && stmt.resolveTargetClass() == aClass);
        }
        return false;
    }

    public static PsiElement replaceElementsWithMap(PsiElement replaceIn, Map<PsiElement, PsiElement> elementsToReplace) throws IncorrectOperationException {
        for (Map.Entry<PsiElement, PsiElement> e : elementsToReplace.entrySet()) {
            if (e.getKey() == replaceIn) {
                return e.getKey().replace(e.getValue());
            }
            e.getKey().replace(e.getValue());
        }
        return replaceIn;
    }

    public static PsiElement getVariableScope(PsiLocalVariable localVar) {
        if (!(localVar instanceof ImplicitVariable)) {
            return localVar.getParent().getParent();
        }
        return ((ImplicitVariable)localVar).getDeclarationScope();
    }

    @Nullable
    public static PsiElement getParentStatement(@Nullable PsiElement place, boolean skipScopingStatements) {
        PsiElement parent = place;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof PsiStatement) break;
            if (parent instanceof PsiExpression && parent.getParent() instanceof PsiLambdaExpression) {
                return parent;
            }
            parent = parent.getParent();
        }
        PsiElement parentStatement = parent;
        while (parent instanceof PsiStatement && !(parent instanceof PsiSwitchLabeledRuleStatement)) {
            if (!skipScopingStatements && (parent instanceof PsiForStatement && parentStatement == ((PsiForStatement)parent).getBody() || parent instanceof PsiForeachStatement && parentStatement == ((PsiForeachStatement)parent).getBody() || parent instanceof PsiWhileStatement && parentStatement == ((PsiWhileStatement)parent).getBody() || parent instanceof PsiIfStatement && (parentStatement == ((PsiIfStatement)parent).getThenBranch() || parentStatement == ((PsiIfStatement)parent).getElseBranch()))) {
                return parentStatement;
            }
            parentStatement = parent;
            parent = parent.getParent();
        }
        return parentStatement;
    }

    public static PsiElement getParentExpressionAnchorElement(PsiElement place) {
        PsiElement parent = (PsiElement)place.getUserData(ElementToWorkOn.PARENT);
        if (place.getUserData(ElementToWorkOn.OUT_OF_CODE_BLOCK) != null) {
            return parent;
        }
        if (parent == null) {
            parent = place;
        }
        do {
            if (RefactoringUtil.isExpressionAnchorElement(parent)) {
                return parent;
            }
            if (!(parent instanceof PsiExpression) || !(parent.getParent() instanceof PsiLambdaExpression)) continue;
            return parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public static boolean isExpressionAnchorElement(PsiElement element) {
        if (element instanceof PsiDeclarationStatement && element.getParent() instanceof PsiForStatement) {
            return false;
        }
        return element instanceof PsiStatement || element instanceof PsiClassInitializer || element instanceof PsiField || element instanceof PsiMethod;
    }

    public static PsiElement getLoopForLoopCondition(PsiExpression expression2) {
        PsiExpression outermost = expression2;
        while (outermost.getParent() instanceof PsiExpression) {
            outermost = (PsiExpression)outermost.getParent();
        }
        if (outermost.getParent() instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)outermost.getParent();
            if (forStatement.getCondition() == outermost) {
                return forStatement;
            }
            return null;
        }
        if (outermost.getParent() instanceof PsiExpressionStatement && outermost.getParent().getParent() instanceof PsiForStatement) {
            PsiForStatement forStatement = (PsiForStatement)outermost.getParent().getParent();
            if (forStatement.getUpdate() == outermost.getParent()) {
                return forStatement;
            }
            return null;
        }
        if (outermost.getParent() instanceof PsiWhileStatement) {
            return outermost.getParent();
        }
        if (outermost.getParent() instanceof PsiDoWhileStatement) {
            return outermost.getParent();
        }
        return null;
    }

    public static PsiClass getThisResolveClass(PsiReferenceExpression place) {
        JavaResolveResult resolveResult = place.advancedResolve(false);
        PsiElement scope = resolveResult.getCurrentFileResolveScope();
        if (scope instanceof PsiClass) {
            return (PsiClass)scope;
        }
        return null;
    }

    public static PsiCall getEnclosingConstructorCall(PsiJavaCodeReferenceElement ref) {
        PsiElement parent = ref.getParent();
        if (ref instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression) {
            return (PsiCall)parent;
        }
        if (parent instanceof PsiAnonymousClass) {
            parent = parent.getParent();
        }
        return parent instanceof PsiNewExpression ? (PsiNewExpression)parent : null;
    }

    public static PsiMethod getEnclosingMethod(PsiElement element) {
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class, PsiLambdaExpression.class});
        return container instanceof PsiMethod ? (PsiMethod)container : null;
    }

    public static void renameVariableReferences(PsiVariable variable, String newName, SearchScope scope) throws IncorrectOperationException {
        RefactoringUtil.renameVariableReferences(variable, newName, scope, false);
    }

    public static void renameVariableReferences(PsiVariable variable, String newName, SearchScope scope, boolean ignoreAccessScope) throws IncorrectOperationException {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)scope, (boolean)ignoreAccessScope)) {
            reference.handleElementRename(newName);
        }
    }

    public static boolean canBeDeclaredFinal(@NotNull PsiVariable variable) {
        LOG.assertTrue(variable instanceof PsiLocalVariable || variable instanceof PsiParameter);
        boolean isReassigned = HighlightControlFlowUtil.isReassigned(variable, (Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>>)new THashMap());
        return !isReassigned;
    }

    public static PsiJavaCodeReferenceElement removeFromReferenceList(PsiReferenceList refList, PsiClass aClass) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            PsiJavaCodeReferenceElement refCopy = (PsiJavaCodeReferenceElement)ref.copy();
            ref.delete();
            return refCopy;
        }
        return null;
    }

    public static PsiJavaCodeReferenceElement findReferenceToClass(PsiReferenceList refList, PsiClass aClass) {
        PsiJavaCodeReferenceElement[] refs;
        for (PsiJavaCodeReferenceElement ref : refs = refList.getReferenceElements()) {
            if (!ref.isReferenceTo((PsiElement)aClass)) continue;
            return ref;
        }
        return null;
    }

    public static PsiType getTypeByExpressionWithExpectedType(PsiExpression expr2) {
        boolean detectConjunct;
        PsiType typeByExpression;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr2.getProject());
        PsiType type2 = typeByExpression = RefactoringUtil.getTypeByExpression(expr2, factory);
        boolean isFunctionalType = LambdaUtil.notInferredType((PsiType)type2);
        PsiType exprType = expr2.getType();
        boolean bl = detectConjunct = exprType instanceof PsiIntersectionType || exprType instanceof PsiWildcardType && ((PsiWildcardType)exprType).getBound() instanceof PsiIntersectionType || exprType instanceof PsiCapturedWildcardType && ((PsiCapturedWildcardType)exprType).getUpperBound() instanceof PsiIntersectionType;
        if (type2 != null && !isFunctionalType && !detectConjunct) {
            return type2;
        }
        ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes(expr2, false);
        if (expectedTypes.length == 1 || (isFunctionalType || detectConjunct) && expectedTypes.length > 0) {
            if (typeByExpression != null && Arrays.stream(expectedTypes).anyMatch(typeInfo -> typeByExpression.isAssignableFrom(typeInfo.getType()))) {
                return type2;
            }
            type2 = expectedTypes[0].getType();
            if (!type2.equalsToText("java.lang.Object")) {
                return type2;
            }
        }
        return detectConjunct ? type2 : null;
    }

    public static PsiType getTypeByExpression(PsiExpression expr2) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr2.getProject());
        PsiType type2 = RefactoringUtil.getTypeByExpression(expr2, factory);
        if (LambdaUtil.notInferredType((PsiType)type2)) {
            type2 = factory.createTypeByFQClassName("java.lang.Object", expr2.getResolveScope());
        }
        return type2;
    }

    private static PsiType getTypeByExpression(PsiExpression expr2, PsiElementFactory factory) {
        PsiType type2 = RefactoringChangeUtil.getTypeByExpression(expr2);
        if (PsiType.NULL.equals((Object)type2)) {
            ExpectedTypeInfo[] infos = ExpectedTypesProvider.getExpectedTypes(expr2, false);
            if (infos.length > 0) {
                type2 = infos[0].getType();
                if (type2 instanceof PsiPrimitiveType) {
                    type2 = infos.length > 1 && !(infos[1].getType() instanceof PsiPrimitiveType) ? infos[1].getType() : ((PsiPrimitiveType)type2).getBoxedType((PsiElement)expr2);
                }
            } else {
                type2 = factory.createTypeByFQClassName("java.lang.Object", expr2.getResolveScope());
            }
        }
        return type2;
    }

    public static boolean isAssignmentLHS(@NotNull PsiElement element) {
        return element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element));
    }

    private static void removeFinalParameters(PsiMethod method) throws IncorrectOperationException {
        PsiParameter[] params;
        PsiParameterList paramList = method.getParameterList();
        for (PsiParameter param : params = paramList.getParameters()) {
            if (!param.hasModifierProperty("final")) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)false);
        }
    }

    public static PsiElement getAnchorElementForMultipleExpressions(PsiExpression @NotNull [] occurrences, PsiElement scope) {
        PsiSwitchStatement switchStatement;
        PsiElement anchor = null;
        for (PsiExpression occurrence : occurrences) {
            PsiElement firstAnchor;
            if (scope != null && !PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)occurrence, (boolean)false)) continue;
            PsiElement anchor1 = RefactoringUtil.getParentExpressionAnchorElement((PsiElement)occurrence);
            if (anchor1 == null) {
                if (!occurrence.isPhysical()) continue;
                return null;
            }
            if (anchor == null) {
                anchor = anchor1;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)anchor, (PsiElement)anchor1);
            if (commonParent == null || anchor.getTextRange() == null || anchor1.getTextRange() == null) {
                return null;
            }
            PsiElement psiElement = firstAnchor = anchor.getTextRange().getStartOffset() < anchor1.getTextRange().getStartOffset() ? anchor : anchor1;
            if (commonParent.equals(firstAnchor)) {
                anchor = firstAnchor;
                continue;
            }
            if (commonParent instanceof PsiStatement) {
                anchor = commonParent;
                continue;
            }
            PsiElement parent = firstAnchor;
            while (!parent.getParent().equals(commonParent)) {
                parent = parent.getParent();
            }
            PsiElement newAnchor = RefactoringUtil.getParentExpressionAnchorElement(parent);
            anchor = newAnchor != null ? newAnchor : parent;
        }
        if (anchor == null) {
            return null;
        }
        if (occurrences.length > 1 && anchor.getParent().getParent() instanceof PsiSwitchStatement && (switchStatement = (PsiSwitchStatement)anchor.getParent().getParent()).getBody().equals(anchor.getParent())) {
            int startOffset = occurrences[0].getTextRange().getStartOffset();
            int endOffset = occurrences[occurrences.length - 1].getTextRange().getEndOffset();
            PsiStatement[] statements = switchStatement.getBody().getStatements();
            boolean isInDifferentCases = false;
            for (PsiStatement statement : statements) {
                int caseOffset;
                if (!(statement instanceof PsiSwitchLabelStatement) || startOffset >= (caseOffset = statement.getTextRange().getStartOffset()) || caseOffset >= endOffset) continue;
                isInDifferentCases = true;
                break;
            }
            if (isInDifferentCases) {
                anchor = switchStatement;
            }
        }
        return anchor;
    }

    public static boolean isMethodUsage(PsiElement element) {
        if (element instanceof PsiEnumConstant) {
            return JavaLanguage.INSTANCE.equals(element.getLanguage());
        }
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCall) {
            return true;
        }
        if (parent instanceof PsiAnonymousClass) {
            return element.equals(((PsiAnonymousClass)parent).getBaseClassReference());
        }
        return false;
    }

    @Nullable
    public static PsiExpressionList getArgumentListByMethodReference(PsiElement ref) {
        if (ref instanceof PsiCall) {
            return ((PsiCall)ref).getArgumentList();
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiCall) {
            return ((PsiCall)parent).getArgumentList();
        }
        if (parent instanceof PsiAnonymousClass) {
            return ((PsiNewExpression)parent.getParent()).getArgumentList();
        }
        LOG.assertTrue(false);
        return null;
    }

    public static PsiCall getCallExpressionByMethodReference(PsiElement ref) {
        if (ref instanceof PsiCall) {
            return (PsiCall)ref;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)parent;
        }
        if (parent instanceof PsiNewExpression) {
            return (PsiNewExpression)parent;
        }
        if (parent instanceof PsiAnonymousClass) {
            return (PsiNewExpression)parent.getParent();
        }
        LOG.assertTrue(false);
        return null;
    }

    public static List<RangeHighlighter> highlightAllOccurrences(Project project, PsiElement[] occurrences, Editor editor) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        if (occurrences.length > 1) {
            for (PsiElement occurrence : occurrences) {
                RangeMarker rangeMarker = (RangeMarker)occurrence.getUserData(ElementToWorkOn.TEXT_RANGE);
                if (rangeMarker != null && rangeMarker.isValid()) {
                    highlightManager.addRangeHighlight(editor, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
                    continue;
                }
                TextRange textRange = occurrence.getTextRange();
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, highlighters);
            }
        }
        return highlighters;
    }

    public static String createTempVar(PsiExpression expr2, PsiElement context, boolean declareFinal) throws IncorrectOperationException {
        PsiExpression expr1;
        PsiElement anchorStatement = RefactoringUtil.getParentStatement(context, true);
        LOG.assertTrue(anchorStatement != null && anchorStatement.getParent() != null);
        Project project = expr2.getProject();
        String[] suggestedNames = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, (PsiExpression)expr2, null).names;
        String prefix = suggestedNames.length > 0 ? suggestedNames[0] : "var";
        String id = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(prefix, context, true);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr2.getProject());
        if (expr2 instanceof PsiParenthesizedExpression && (expr1 = ((PsiParenthesizedExpression)expr2).getExpression()) != null) {
            expr2 = expr1;
        }
        PsiDeclarationStatement decl = factory.createVariableDeclarationStatement(id, expr2.getType(), expr2);
        if (declareFinal) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)decl.getDeclaredElements()[0]), (String)"final", (boolean)true);
        }
        anchorStatement.getParent().addBefore((PsiElement)decl, anchorStatement);
        return id;
    }

    public static int verifySafeCopyExpression(PsiElement expr2) {
        return RefactoringUtil.verifySafeCopyExpressionSubElement(expr2);
    }

    private static int verifySafeCopyExpressionSubElement(PsiElement element) {
        PsiElement[] children;
        int result = 0;
        if (element == null) {
            return result;
        }
        if (element instanceof PsiThisExpression || element instanceof PsiSuperExpression || element instanceof PsiIdentifier) {
            return 0;
        }
        if (element instanceof PsiMethodCallExpression) {
            result = 1;
        }
        if (element instanceof PsiNewExpression) {
            return 2;
        }
        if (element instanceof PsiAssignmentExpression) {
            return 2;
        }
        if (PsiUtil.isIncrementDecrementOperation((PsiElement)element)) {
            return 2;
        }
        for (PsiElement child : children = element.getChildren()) {
            int childResult = RefactoringUtil.verifySafeCopyExpressionSubElement(child);
            result = Math.max(result, childResult);
        }
        return result;
    }

    @Contract(value="null, _ -> null")
    public static PsiExpression convertInitializerToNormalExpression(PsiExpression expression2, PsiType forcedReturnType) throws IncorrectOperationException {
        if (expression2 instanceof PsiArrayInitializerExpression && (forcedReturnType == null || forcedReturnType instanceof PsiArrayType)) {
            return RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)expression2, forcedReturnType);
        }
        return expression2;
    }

    public static PsiExpression createNewExpressionFromArrayInitializer(PsiArrayInitializerExpression initializer, PsiType forcedType) throws IncorrectOperationException {
        PsiType initializerType = null;
        if (initializer != null) {
            initializerType = forcedType != null ? forcedType : RefactoringUtil.getTypeByExpression((PsiExpression)initializer);
        }
        if (initializerType == null) {
            return initializer;
        }
        LOG.assertTrue(initializerType instanceof PsiArrayType);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)initializer.getProject());
        PsiNewExpression result = (PsiNewExpression)factory.createExpressionFromText("new " + initializerType.getPresentableText() + "{}", null);
        result = (PsiNewExpression)CodeStyleManager.getInstance((Project)initializer.getProject()).reformat((PsiElement)result);
        PsiArrayInitializerExpression arrayInitializer = result.getArrayInitializer();
        LOG.assertTrue(arrayInitializer != null);
        arrayInitializer.replace((PsiElement)initializer);
        return result;
    }

    public static void makeMethodAbstract(@NotNull PsiClass targetClass, @NotNull PsiMethod method) throws IncorrectOperationException {
        if (!method.hasModifierProperty("default")) {
            PsiCodeBlock body2 = method.getBody();
            if (body2 != null) {
                body2.delete();
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
        }
        if (!targetClass.isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)targetClass, (String)"abstract", (boolean)true);
            RefactoringUtil.prepareForAbstract(method);
        } else {
            RefactoringUtil.prepareForInterface(method);
        }
    }

    public static void makeMethodDefault(@NotNull PsiMethod method) throws IncorrectOperationException {
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"default", (!method.hasModifierProperty("static") ? 1 : 0) != 0);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)false);
        RefactoringUtil.prepareForInterface(method);
    }

    private static void prepareForInterface(PsiMethod method) {
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"private", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"protected", (boolean)false);
        RefactoringUtil.prepareForAbstract(method);
    }

    private static void prepareForAbstract(PsiMethod method) {
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"final", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"synchronized", (boolean)false);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"native", (boolean)false);
        RefactoringUtil.removeFinalParameters(method);
    }

    public static boolean isInsideAnonymousOrLocal(PsiElement element, PsiElement upTo) {
        for (PsiElement current = element; current != null && current != upTo; current = current.getParent()) {
            if (current instanceof PsiAnonymousClass) {
                return true;
            }
            if (!(current instanceof PsiClass) || !(current.getParent() instanceof PsiDeclarationStatement)) continue;
            return true;
        }
        return false;
    }

    public static PsiExpression unparenthesizeExpression(PsiExpression expression2) {
        while (expression2 instanceof PsiParenthesizedExpression) {
            PsiExpression innerExpression = ((PsiParenthesizedExpression)expression2).getExpression();
            if (innerExpression == null) {
                return expression2;
            }
            expression2 = innerExpression;
        }
        return expression2;
    }

    public static PsiExpression outermostParenthesizedExpression(PsiExpression expression2) {
        while (expression2.getParent() instanceof PsiParenthesizedExpression) {
            expression2 = (PsiParenthesizedExpression)expression2.getParent();
        }
        return expression2;
    }

    public static String getNewInnerClassName(PsiClass aClass, String oldInnerClassName, String newName) {
        String className2 = aClass.getName();
        if (className2 == null || !oldInnerClassName.endsWith(className2)) {
            return newName;
        }
        StringBuilder buffer = new StringBuilder(oldInnerClassName);
        buffer.replace(buffer.length() - className2.length(), buffer.length(), newName);
        return buffer.toString();
    }

    public static void visitImplicitSuperConstructorUsages(PsiClass subClass, ImplicitConstructorUsageVisitor implicitConstructorUsageVisitor, PsiClass superClass) {
        PsiMethod baseDefaultConstructor = RefactoringUtil.findDefaultConstructor(superClass);
        PsiMethod[] constructors = subClass.getConstructors();
        if (constructors.length > 0) {
            for (PsiMethod constructor : constructors) {
                PsiStatement[] statements;
                PsiCodeBlock body2 = constructor.getBody();
                if (body2 == null || (statements = body2.getStatements()).length >= 1 && JavaHighlightUtil.isSuperOrThisCall(statements[0], true, true)) continue;
                implicitConstructorUsageVisitor.visitConstructor(constructor, baseDefaultConstructor);
            }
        } else {
            implicitConstructorUsageVisitor.visitClassWithoutConstructors(subClass);
        }
    }

    private static PsiMethod findDefaultConstructor(PsiClass aClass) {
        PsiMethod[] constructors;
        for (PsiMethod constructor : constructors = aClass.getConstructors()) {
            if (!constructor.getParameterList().isEmpty()) continue;
            return constructor;
        }
        return null;
    }

    public static void replaceMovedMemberTypeParameters(PsiElement member, Iterable<? extends PsiTypeParameter> parametersIterable, PsiSubstitutor substitutor, PsiElementFactory factory) {
        LinkedHashMap<Object, Object> replacement = new LinkedHashMap<Object, Object>();
        for (PsiTypeParameter psiTypeParameter : parametersIterable) {
            PsiType substitutedType = substitutor.substitute(psiTypeParameter);
            PsiType erasedType = substitutedType == null ? TypeConversionUtil.erasure((PsiType)factory.createType((PsiClass)psiTypeParameter)) : substitutedType;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiTypeParameter, (SearchScope)new LocalSearchScope(member))) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiTypeElement) {
                    if (substitutedType == null) {
                        PsiJavaCodeReferenceElement codeReferenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)parent, PsiJavaCodeReferenceElement.class);
                        if (codeReferenceElement != null) {
                            PsiJavaCodeReferenceElement copy = (PsiJavaCodeReferenceElement)codeReferenceElement.copy();
                            PsiReferenceParameterList parameterList = copy.getParameterList();
                            if (parameterList != null) {
                                parameterList.delete();
                            }
                            replacement.put(codeReferenceElement, copy);
                            continue;
                        }
                        PsiTypeElement topPsiTypeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)parent, PsiTypeElement.class);
                        if (topPsiTypeElement == null) {
                            topPsiTypeElement = (PsiTypeElement)parent;
                        }
                        replacement.put(topPsiTypeElement, factory.createTypeElement(TypeConversionUtil.erasure((PsiType)topPsiTypeElement.getType())));
                        continue;
                    }
                    replacement.put(parent, factory.createTypeElement(substitutedType));
                    continue;
                }
                if (!(element instanceof PsiJavaCodeReferenceElement) || !(erasedType instanceof PsiClassType)) continue;
                replacement.put(element, factory.createReferenceElementByType((PsiClassType)erasedType));
            }
        }
        for (PsiElement psiElement : replacement.keySet()) {
            if (!psiElement.isValid()) continue;
            psiElement.replace((PsiElement)replacement.get(psiElement));
        }
    }

    public static void renameConflictingTypeParameters(PsiMember memberCopy, PsiClass targetClass) {
        if (memberCopy instanceof PsiTypeParameterListOwner && !memberCopy.hasModifierProperty("static")) {
            UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
            PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass).forEach(param -> {
                String paramName = param.getName();
                if (paramName != null) {
                    nameGenerator.addExistingName(paramName);
                }
            });
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)memberCopy.getProject());
            for (PsiTypeParameter parameter2 : ((PsiTypeParameterListOwner)memberCopy).getTypeParameters()) {
                String parameterName = parameter2.getName();
                if (parameterName == null || nameGenerator.isUnique(parameterName)) continue;
                substitutor = substitutor.put(parameter2, PsiSubstitutor.EMPTY.substitute(factory.createTypeParameter(nameGenerator.generateUniqueName(parameterName), PsiClassType.EMPTY_ARRAY)));
            }
            if (!PsiSubstitutor.EMPTY.equals(substitutor)) {
                RefactoringUtil.replaceMovedMemberTypeParameters((PsiElement)memberCopy, PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)((PsiTypeParameterListOwner)memberCopy)), substitutor, factory);
                for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
                    ((PsiTypeParameter)entry.getKey()).setName(((PsiType)entry.getValue()).getCanonicalText());
                }
            }
        }
    }

    @Nullable
    public static PsiMethod getChainedConstructor(PsiMethod constructor) {
        PsiMethodCallExpression methodCallExpression;
        PsiReferenceExpression methodExpr;
        PsiExpression expression2;
        PsiCodeBlock constructorBody = constructor.getBody();
        if (constructorBody == null) {
            return null;
        }
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && "this".equals((methodExpr = (methodCallExpression = (PsiMethodCallExpression)expression2).getMethodExpression()).getReferenceName())) {
            return (PsiMethod)methodExpr.resolve();
        }
        return null;
    }

    public static boolean isInMovedElement(PsiElement element, Set<? extends PsiMember> membersToMove) {
        for (PsiMember psiMember : membersToMove) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiMember, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean inImportStatement(PsiReference ref, PsiElement element) {
        PsiImportList importList;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class) != null) {
            return true;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PsiJavaFile && (importList = ((PsiJavaFile)containingFile).getImportList()) != null) {
            TextRange refRange = ref.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            for (PsiImportStatementBase importStatementBase : importList.getAllImportStatements()) {
                TextRange textRange = importStatementBase.getTextRange();
                if (!textRange.contains(refRange)) continue;
                return true;
            }
        }
        return false;
    }

    public static PsiStatement putStatementInLoopBody(PsiStatement declaration2, PsiElement container, PsiElement finalAnchorStatement) throws IncorrectOperationException {
        return RefactoringUtil.putStatementInLoopBody(declaration2, container, finalAnchorStatement, false);
    }

    public static PsiStatement putStatementInLoopBody(PsiStatement declaration2, PsiElement container, PsiElement finalAnchorStatement, boolean replaceBody) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)container.getProject());
        if (RefactoringUtil.isLoopOrIf(container)) {
            PsiElement pprev;
            PsiStatement loopBody = RefactoringUtil.getLoopBody(container, finalAnchorStatement);
            PsiStatement loopBodyCopy = loopBody != null ? (PsiStatement)loopBody.copy() : null;
            PsiBlockStatement blockStatement = (PsiBlockStatement)elementFactory.createStatementFromText("{}", null);
            blockStatement = (PsiBlockStatement)CodeStyleManager.getInstance((Project)container.getProject()).reformat((PsiElement)blockStatement);
            PsiElement prevSibling = loopBody.getPrevSibling();
            if (!(!(prevSibling instanceof PsiWhiteSpace) || (pprev = prevSibling.getPrevSibling()) instanceof PsiComment && ((PsiComment)pprev).getTokenType().equals(JavaTokenType.END_OF_LINE_COMMENT))) {
                prevSibling.delete();
            }
            blockStatement = (PsiBlockStatement)loopBody.replace((PsiElement)blockStatement);
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            declaration2 = (PsiStatement)codeBlock.add((PsiElement)declaration2);
            JavaCodeStyleManager.getInstance((Project)declaration2.getProject()).shortenClassReferences((PsiElement)declaration2);
            if (loopBodyCopy != null && !replaceBody) {
                codeBlock.add((PsiElement)loopBodyCopy);
            }
        } else if (container instanceof PsiLambdaExpression) {
            PsiLambdaExpression copy;
            PsiStatement lastBodyStatement;
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)container;
            PsiElement invalidBody = lambdaExpression.getBody();
            if (invalidBody == null) {
                return declaration2;
            }
            String lambdaParamListWithArrowAndComments = lambdaExpression.getText().substring(0, (declaration2.isPhysical() ? declaration2 : invalidBody).getStartOffsetInParent());
            PsiLambdaExpression expressionFromText = (PsiLambdaExpression)elementFactory.createExpressionFromText(lambdaParamListWithArrowAndComments + "{}", lambdaExpression.getParent());
            PsiCodeBlock newBody = (PsiCodeBlock)expressionFromText.getBody();
            LOG.assertTrue(newBody != null);
            newBody.add((PsiElement)declaration2);
            PsiElement lambdaExpressionBody = lambdaExpression.getBody();
            LOG.assertTrue(lambdaExpressionBody != null);
            if (PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression))) {
                if (replaceBody) {
                    lastBodyStatement = null;
                } else {
                    lastBodyStatement = elementFactory.createStatementFromText("a;", (PsiElement)lambdaExpression);
                    ((PsiExpressionStatement)lastBodyStatement).getExpression().replace(lambdaExpressionBody);
                }
            } else {
                lastBodyStatement = elementFactory.createStatementFromText("return a;", (PsiElement)lambdaExpression);
                PsiExpression returnValue = ((PsiReturnStatement)lastBodyStatement).getReturnValue();
                LOG.assertTrue(returnValue != null);
                returnValue.replace(lambdaExpressionBody);
            }
            if (lastBodyStatement != null) {
                newBody.add((PsiElement)lastBodyStatement);
            }
            LOG.assertTrue((newBody = (PsiCodeBlock)(copy = (PsiLambdaExpression)lambdaExpression.replace((PsiElement)expressionFromText)).getBody()) != null);
            declaration2 = newBody.getStatements()[0];
            declaration2 = (PsiStatement)JavaCodeStyleManager.getInstance((Project)declaration2.getProject()).shortenClassReferences((PsiElement)declaration2);
        }
        return declaration2;
    }

    @Nullable
    private static PsiStatement getLoopBody(PsiElement container, PsiElement anchorStatement) {
        if (container instanceof PsiLoopStatement) {
            return ((PsiLoopStatement)container).getBody();
        }
        if (container instanceof PsiIfStatement) {
            PsiStatement thenBranch = ((PsiIfStatement)container).getThenBranch();
            if (thenBranch != null && PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)anchorStatement, (boolean)false)) {
                return thenBranch;
            }
            PsiStatement elseBranch = ((PsiIfStatement)container).getElseBranch();
            if (elseBranch != null && PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)anchorStatement, (boolean)false)) {
                return elseBranch;
            }
            LOG.assertTrue(false);
        }
        LOG.assertTrue(false);
        return null;
    }

    public static boolean isLoopOrIf(PsiElement element) {
        return element instanceof PsiLoopStatement || element instanceof PsiIfStatement;
    }

    public static PsiCodeBlock expandExpressionLambdaToCodeBlock(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiElement body2 = lambdaExpression.getBody();
        if (!(body2 instanceof PsiExpression)) {
            return (PsiCodeBlock)body2;
        }
        String newLambdaText = "{";
        if (!PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)lambdaExpression))) {
            newLambdaText = newLambdaText + "return ";
        }
        newLambdaText = newLambdaText + "a;}";
        Project project = lambdaExpression.getProject();
        PsiCodeBlock codeBlock = JavaPsiFacade.getElementFactory((Project)project).createCodeBlockFromText(newLambdaText, (PsiElement)lambdaExpression);
        PsiStatement statement = codeBlock.getStatements()[0];
        if (statement instanceof PsiReturnStatement) {
            PsiExpression value2 = ((PsiReturnStatement)statement).getReturnValue();
            LOG.assertTrue(value2 != null);
            value2.replace(body2);
        } else if (statement instanceof PsiExpressionStatement) {
            ((PsiExpressionStatement)statement).getExpression().replace(body2);
        }
        PsiElement arrow = PsiTreeUtil.skipWhitespacesBackward((PsiElement)body2);
        if (arrow != null && arrow.getNextSibling() != body2) {
            lambdaExpression.deleteChildRange(arrow.getNextSibling(), body2.getPrevSibling());
        }
        return (PsiCodeBlock)CodeStyleManager.getInstance((Project)project).reformat(body2.replace((PsiElement)codeBlock));
    }

    public static String checkEnumConstantInSwitchLabel(PsiExpression expr2) {
        PsiReferenceExpression ref;
        if (PsiImplUtil.getSwitchLabel(expr2) != null && (ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expr2), PsiReferenceExpression.class)) != null && ref.resolve() instanceof PsiEnumConstant) {
            return RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"refactoring.introduce.variable.enum.in.label.message", (Object[])new Object[0]));
        }
        return null;
    }

    public static <T> Set<T> transitiveClosure(Graph<T> graph, Condition<? super T> initialRelation) {
        boolean anyChanged;
        HashSet<T> result = new HashSet<T>();
        Set<T> vertices = graph.getVertices();
        do {
            anyChanged = false;
            block1: for (T currentVertex : vertices) {
                if (result.contains(currentVertex)) continue;
                if (!initialRelation.value(currentVertex)) {
                    Set<T> targets = graph.getTargets(currentVertex);
                    for (T currentTarget : targets) {
                        if (!result.contains(currentTarget) && !initialRelation.value(currentTarget)) continue;
                        result.add(currentVertex);
                        anyChanged = true;
                        continue block1;
                    }
                    continue;
                }
                result.add(currentVertex);
            }
        } while (anyChanged);
        return result;
    }

    public static boolean equivalentTypes(PsiType t1, PsiType t2, PsiManager manager) {
        while (t1 instanceof PsiArrayType) {
            if (!(t2 instanceof PsiArrayType)) {
                return false;
            }
            t1 = ((PsiArrayType)t1).getComponentType();
            t2 = ((PsiArrayType)t2).getComponentType();
        }
        if (t1 instanceof PsiPrimitiveType) {
            return t2 instanceof PsiPrimitiveType && t1.equals(t2);
        }
        return manager.areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)t1), (PsiElement)PsiUtil.resolveClassInType((PsiType)t2));
    }

    public static List<PsiVariable> collectReferencedVariables(PsiElement scope) {
        final ArrayList<PsiVariable> result = new ArrayList<PsiVariable>();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                PsiExpression qualifier;
                PsiElement element = expression2.resolve();
                if (element instanceof PsiVariable) {
                    result.add((PsiVariable)element);
                }
                if ((qualifier = expression2.getQualifierExpression()) != null) {
                    qualifier.accept((PsiElementVisitor)this);
                }
            }
        });
        return result;
    }

    public static boolean isModifiedInScope(PsiVariable variable, PsiElement scope) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope(scope), (boolean)false)) {
            if (!RefactoringUtil.isAssignmentLHS(reference.getElement())) continue;
            return true;
        }
        return false;
    }

    private static String getNameOfReferencedParameter(PsiDocTag tag) {
        LOG.assertTrue("param".equals(tag.getName()));
        PsiElement[] dataElements = tag.getDataElements();
        if (dataElements.length < 1) {
            return null;
        }
        return dataElements[0].getText();
    }

    public static void fixJavadocsForParams(PsiMethod method, Set<? extends PsiParameter> newParameters) throws IncorrectOperationException {
        RefactoringUtil.fixJavadocsForParams(method, newParameters, (Condition<? super Pair<PsiParameter, String>>)Conditions.alwaysFalse());
    }

    public static void fixJavadocsForParams(PsiMethod method, Set<? extends PsiParameter> newParameters, Condition<? super Pair<PsiParameter, String>> eqCondition) throws IncorrectOperationException {
        RefactoringUtil.fixJavadocsForParams(method, newParameters, eqCondition, (Condition<? super String>)Conditions.alwaysTrue());
    }

    public static void fixJavadocsForParams(@NotNull PsiMethod method, @NotNull Set<? extends PsiParameter> newParameters, @NotNull Condition<? super Pair<PsiParameter, String>> eqCondition, @NotNull Condition<? super String> matchedToOldParam) throws IncorrectOperationException {
        RefactoringUtil.fixJavadocsForParams(method, method.getDocComment(), newParameters, eqCondition, matchedToOldParam);
    }

    /*
     * WARNING - void declaration
     */
    public static void fixJavadocsForParams(@NotNull PsiMethod method, @Nullable PsiDocComment docComment, @NotNull Set<? extends PsiParameter> newParameters, @NotNull Condition<? super Pair<PsiParameter, String>> eqCondition, @NotNull Condition<? super String> matchedToOldParam) throws IncorrectOperationException {
        void var12_21;
        if (docComment == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiDocTag[] paramTags = docComment.findTagsByName("param");
        if (parameters2.length > 0 && newParameters.size() < parameters2.length && paramTags.length == 0) {
            return;
        }
        HashMap<PsiParameter, PsiDocTag> tagForParam = new HashMap<PsiParameter, PsiDocTag>();
        for (PsiParameter parameter2 : parameters2) {
            boolean bl = false;
            for (PsiDocTag paramTag : paramTags) {
                if (!parameter2.getName().equals(RefactoringUtil.getNameOfReferencedParameter(paramTag))) continue;
                tagForParam.put(parameter2, paramTag);
                bl = true;
                break;
            }
            if (!bl) {
                for (PsiDocTag paramTag : paramTags) {
                    String paramName = RefactoringUtil.getNameOfReferencedParameter(paramTag);
                    if (!eqCondition.value((Object)Pair.create((Object)parameter2, (Object)paramName))) continue;
                    tagForParam.put(parameter2, paramTag);
                    bl = true;
                    break;
                }
            }
            if (bl || newParameters.contains(parameter2)) continue;
            tagForParam.put(parameter2, null);
        }
        ArrayList<PsiDocTag> newTags = new ArrayList<PsiDocTag>();
        for (PsiDocTag psiDocTag : paramTags) {
            String paramName = RefactoringUtil.getNameOfReferencedParameter(psiDocTag);
            if (tagForParam.containsValue(psiDocTag) || matchedToOldParam.value((Object)paramName)) continue;
            newTags.add((PsiDocTag)psiDocTag.copy());
        }
        for (PsiDocTag psiDocTag : parameters2) {
            if (tagForParam.containsKey(psiDocTag)) {
                PsiDocTag psiDocTag2 = (PsiDocTag)tagForParam.get(psiDocTag);
                if (psiDocTag2 == null) continue;
                PsiDocTag copy = (PsiDocTag)psiDocTag2.copy();
                PsiDocTagValue valueElement = copy.getValueElement();
                if (valueElement != null) {
                    valueElement.replace((PsiElement)RefactoringUtil.createParamTag((PsiParameter)psiDocTag).getValueElement());
                }
                newTags.add(copy);
                continue;
            }
            newTags.add(RefactoringUtil.createParamTag((PsiParameter)psiDocTag));
        }
        PsiElement anchor = paramTags.length > 0 ? paramTags[0].getPrevSibling() : null;
        PsiDocTag[] psiDocTagArray = paramTags;
        int parameter2 = psiDocTagArray.length;
        boolean bl = false;
        while (var12_21 < parameter2) {
            PsiDocTag paramTag = psiDocTagArray[var12_21];
            paramTag.delete();
            ++var12_21;
        }
        for (PsiDocTag psiDocTag : newTags) {
            anchor = anchor != null && anchor.isValid() ? docComment.addAfter((PsiElement)psiDocTag, anchor) : docComment.add((PsiElement)psiDocTag);
        }
    }

    @NotNull
    private static PsiDocTag createParamTag(@NotNull PsiParameter parameter2) {
        return JavaPsiFacade.getElementFactory((Project)parameter2.getProject()).createParamTag(parameter2.getName(), "");
    }

    @NotNull
    public static PsiDirectory createPackageDirectoryInSourceRoot(@NotNull PackageWrapper aPackage, @NotNull VirtualFile sourceRoot) throws IncorrectOperationException {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
            return directory;
        }
        String qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, sourceRoot);
        String[] shortNames = qNameToCreate.split("\\.");
        PsiDirectory current = aPackage.getManager().findDirectory(sourceRoot);
        LOG.assertTrue(current != null);
        for (String shortName : shortNames) {
            PsiDirectory subdirectory = current.findSubdirectory(shortName);
            if (subdirectory == null) {
                subdirectory = current.createSubdirectory(shortName);
            }
            current = subdirectory;
        }
        return current;
    }

    public static String qNameToCreateInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) throws IncorrectOperationException {
        String targetQName = aPackage.getQualifiedName();
        String sourceRootPackage = ProjectRootManager.getInstance((Project)aPackage.getManager().getProject()).getFileIndex().getPackageNameByDirectory(sourceRoot);
        if (!RefactoringUtil.canCreateInSourceRoot(sourceRootPackage, targetQName)) {
            throw new IncorrectOperationException("Cannot create package '" + targetQName + "' in source folder " + sourceRoot.getPresentableUrl());
        }
        String result = targetQName.substring(sourceRootPackage.length());
        if (StringUtil.startsWithChar((CharSequence)result, (char)'.')) {
            result = result.substring(1);
        }
        return result;
    }

    public static boolean canCreateInSourceRoot(String sourceRootPackage, String targetQName) {
        if (sourceRootPackage == null || !targetQName.startsWith(sourceRootPackage)) {
            return false;
        }
        if (sourceRootPackage.isEmpty() || targetQName.length() == sourceRootPackage.length()) {
            return true;
        }
        return targetQName.charAt(sourceRootPackage.length()) == '.';
    }

    @Nullable
    public static PsiDirectory findPackageDirectoryInSourceRoot(PackageWrapper aPackage, VirtualFile sourceRoot) {
        String qNameToCreate;
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)directory.getVirtualFile(), (boolean)false)) continue;
            return directory;
        }
        try {
            qNameToCreate = RefactoringUtil.qNameToCreateInSourceRoot(aPackage, sourceRoot);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        String[] shortNames = qNameToCreate.split("\\.");
        PsiDirectory current = aPackage.getManager().findDirectory(sourceRoot);
        LOG.assertTrue(current != null);
        for (String shortName : shortNames) {
            PsiDirectory subdirectory = current.findSubdirectory(shortName);
            if (subdirectory == null) {
                return null;
            }
            current = subdirectory;
        }
        return current;
    }

    @Nullable
    public static PsiTypeParameterList createTypeParameterListWithUsedTypeParameters(PsiElement ... elements) {
        return RefactoringUtil.createTypeParameterListWithUsedTypeParameters(null, elements);
    }

    @Nullable
    public static PsiTypeParameterList createTypeParameterListWithUsedTypeParameters(@Nullable PsiTypeParameterList fromList, PsiElement ... elements) {
        return RefactoringUtil.createTypeParameterListWithUsedTypeParameters(fromList, (Condition<? super PsiTypeParameter>)Conditions.alwaysTrue(), elements);
    }

    @Nullable
    public static PsiTypeParameterList createTypeParameterListWithUsedTypeParameters(@Nullable PsiTypeParameterList fromList, Condition<? super PsiTypeParameter> filter, PsiElement ... elements) {
        if (elements.length == 0) {
            return null;
        }
        HashSet<PsiTypeParameter> used = new HashSet<PsiTypeParameter>();
        for (PsiElement element : elements) {
            if (element == null) continue;
            RefactoringUtil.collectTypeParameters(used, element, filter);
        }
        RefactoringUtil.collectTypeParametersInDependencies(filter, used);
        if (fromList != null) {
            used.retainAll(Arrays.asList(fromList.getTypeParameters()));
        }
        PsiTypeParameter[] typeParameters = used.toArray(PsiTypeParameter.EMPTY_ARRAY);
        Arrays.sort(typeParameters, Comparator.comparingInt(tp -> tp.getTextRange().getStartOffset()));
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)elements[0].getProject());
        try {
            PsiClass aClass = elementFactory.createClassFromText("class A {}", null);
            PsiTypeParameterList list = aClass.getTypeParameterList();
            assert (list != null);
            for (PsiTypeParameter typeParameter : typeParameters) {
                list.add((PsiElement)typeParameter);
            }
            return list;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            assert (false);
            return null;
        }
    }

    private static void collectTypeParametersInDependencies(Condition<? super PsiTypeParameter> filter, Set<PsiTypeParameter> used) {
        Stack toProcess = new Stack();
        toProcess.addAll(used);
        while (!toProcess.isEmpty()) {
            PsiTypeParameter parameter2 = (PsiTypeParameter)toProcess.pop();
            HashSet dependencies = new HashSet();
            RefactoringUtil.collectTypeParameters(dependencies, (PsiElement)parameter2, (Condition<? super PsiTypeParameter>)((Condition)param -> filter.value(param) && !used.contains(param)));
            used.addAll(dependencies);
            toProcess.addAll(dependencies);
        }
    }

    public static void collectTypeParameters(Set<? super PsiTypeParameter> used, PsiElement element) {
        RefactoringUtil.collectTypeParameters(used, element, (Condition<? super PsiTypeParameter>)Conditions.alwaysTrue());
    }

    public static void collectTypeParameters(final Set<? super PsiTypeParameter> used, final PsiElement element, final Condition<? super PsiTypeParameter> filter) {
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiTypeParameter typeParameter;
                PsiElement resolved;
                super.visitReferenceElement(reference);
                if (!reference.isQualified() && (resolved = reference.resolve()) instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)(typeParameter = (PsiTypeParameter)resolved).getOwner(), (PsiElement)element, (boolean)false) && filter.value((Object)typeParameter)) {
                    used.add(typeParameter);
                }
            }

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                PsiType type2 = expression2.getType();
                if (type2 != null) {
                    PsiTypesUtil.TypeParameterSearcher searcher = new PsiTypesUtil.TypeParameterSearcher();
                    type2.accept((PsiTypeVisitor)searcher);
                    for (PsiTypeParameter typeParam : searcher.getTypeParameters()) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)typeParam.getOwner(), (PsiElement)element, (boolean)false) || !filter.value((Object)typeParam)) continue;
                        used.add(typeParam);
                    }
                }
            }
        });
    }

    public static class IsDescendantOf
    implements Condition<PsiClass> {
        private final PsiClass myClass;
        private final ConditionCache<PsiClass> myConditionCache;

        public IsDescendantOf(PsiClass aClass) {
            this.myClass = aClass;
            this.myConditionCache = new ConditionCache(aClass1 -> InheritanceUtil.isInheritorOrSelf((PsiClass)aClass1, (PsiClass)this.myClass, (boolean)true));
        }

        public boolean value(PsiClass aClass) {
            return this.myConditionCache.value(aClass);
        }
    }

    public static class ConditionCache<T>
    implements Condition<T> {
        private final Condition<? super T> myCondition;
        private final HashSet<T> myProcessedSet = new HashSet();
        private final HashSet<T> myTrueSet = new HashSet();

        public ConditionCache(Condition<? super T> condition2) {
            this.myCondition = condition2;
        }

        public boolean value(T object) {
            if (!this.myProcessedSet.contains(object)) {
                this.myProcessedSet.add(object);
                boolean value2 = this.myCondition.value(object);
                if (value2) {
                    this.myTrueSet.add(object);
                    return true;
                }
                return false;
            }
            return this.myTrueSet.contains(object);
        }
    }

    public static interface Graph<T> {
        public Set<T> getVertices();

        public Set<T> getTargets(T var1);
    }

    public static interface ImplicitConstructorUsageVisitor {
        public void visitConstructor(PsiMethod var1, PsiMethod var2);

        public void visitClassWithoutConstructors(PsiClass var1);
    }
}

