/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaTypeConversionDescriptor
extends TypeConversionDescriptor {
    private static final Logger LOG = Logger.getInstance(GuavaTypeConversionDescriptor.class);
    private final String myReplaceByStringSource;
    private final boolean myIterable;
    private boolean myConvertParameterAsLambda = true;

    GuavaTypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, @NotNull PsiExpression expression2) {
        super(stringToReplace, replaceByString);
        this.myReplaceByStringSource = replaceByString;
        this.myIterable = GuavaTypeConversionDescriptor.isIterable(expression2);
    }

    public GuavaTypeConversionDescriptor setConvertParameterAsLambda(boolean convertParameterAsLambda) {
        this.myConvertParameterAsLambda = convertParameterAsLambda;
        return this;
    }

    @Override
    public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
        this.setReplaceByString(this.myReplaceByStringSource + (this.myIterable ? ".collect(java.util.stream.Collectors.toList())" : ""));
        if (this.myConvertParameterAsLambda) {
            LOG.assertTrue(expression2 instanceof PsiMethodCallExpression);
            PsiExpression[] arguments = ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions();
            if (arguments.length == 1) {
                GuavaConversionUtil.adjustLambdaContainingExpression(arguments[0], false, null, evaluator);
            }
        }
        return super.replace(expression2, evaluator);
    }

    public static boolean isIterable(PsiExpression expression2) {
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiLocalVariable) {
            return GuavaTypeConversionDescriptor.isIterable(((PsiLocalVariable)parent).getType());
        }
        if (parent instanceof PsiReturnStatement) {
            return GuavaTypeConversionDescriptor.isIterable(PsiTypesUtil.getMethodReturnType((PsiElement)parent));
        }
        if (parent instanceof PsiExpressionList) {
            int index;
            Object[] arguments;
            PsiParameter[] parameters2;
            PsiMethod method;
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiElement maybeMethodCallExpr = expressionList.getParent();
            if (maybeMethodCallExpr instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)maybeMethodCallExpr).resolveMethod()) != null && (parameters2 = method.getParameterList().getParameters()).length == (arguments = expressionList.getExpressions()).length && (index = ArrayUtil.indexOf((Object[])arguments, (Object)expression2)) != -1) {
                return GuavaTypeConversionDescriptor.isIterable(parameters2[index].getType());
            }
        } else if (parent instanceof PsiMethodCallExpression) {
            return GuavaTypeConversionDescriptor.isIterable((PsiExpression)parent);
        }
        return false;
    }

    private static boolean isIterable(@Nullable PsiType type2) {
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type2);
        return aClass != null && "java.lang.Iterable".equals(aClass.getQualifiedName());
    }
}

