/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import org.jetbrains.annotations.NotNull;

class ArrayInitializerAwareConversionDescriptor
extends TypeConversionDescriptor {
    ArrayInitializerAwareConversionDescriptor(String stringToReplace, String replaceByString, PsiExpression expression2) {
        super(stringToReplace, replaceByString, expression2);
    }

    @Override
    @NotNull
    protected PsiExpression adjustExpressionBeforeReplacement(@NotNull PsiExpression expression2) {
        if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)expression2.getProject());
            return (PsiExpression)expression2.replace((PsiElement)elementFactory.createExpressionFromText("new " + TypeConversionUtil.erasure((PsiType)expression2.getType()).getCanonicalText() + expression2.getText(), (PsiElement)expression2));
        }
        return expression2;
    }
}

