/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.refactoring.typeMigration.intentions.ConvertFieldToAtomicIntention;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertFieldToThreadLocalIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(ConvertFieldToThreadLocalIntention.class);

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @NotNull
    public String getFamilyName() {
        return TypeMigrationBundle.message("convert.to.threadlocal.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (psiField == null) {
            return false;
        }
        if (psiField.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (psiField.getTypeElement() == null) {
            return false;
        }
        PsiType fieldType = psiField.getType();
        PsiClass fieldTypeClass = PsiUtil.resolveClassInType((PsiType)fieldType);
        if (fieldType instanceof PsiPrimitiveType && !PsiType.VOID.equals((Object)fieldType) || fieldType instanceof PsiArrayType) {
            return true;
        }
        return fieldTypeClass != null && !Comparing.strEqual((String)fieldTypeClass.getQualifiedName(), (String)ThreadLocal.class.getName()) && AllowedApiFilterExtension.isClassAllowed(ThreadLocal.class.getName(), element);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        LOG.assertTrue(psiField != null);
        PsiType fromType = psiField.getType();
        PsiClassType toType = ConvertFieldToThreadLocalIntention.getMigrationTargetType(fromType, project, element);
        if (toType == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{psiField})) {
            return;
        }
        ConvertFieldToAtomicIntention.addExplicitInitializer((PsiVariable)psiField);
        String toTypeCanonicalText = toType.getCanonicalText();
        TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable((PsiVariable)psiField, (PsiType)toType, editor, false, false);
        ConvertFieldToAtomicIntention.postProcessVariable((PsiVariable)psiField, toTypeCanonicalText);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    private static PsiClassType getMigrationTargetType(@NotNull PsiType fromType, @NotNull Project project, @NotNull PsiElement context) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass threadLocalClass = psiFacade.findClass(ThreadLocal.class.getName(), GlobalSearchScope.allScope((Project)project));
        if (threadLocalClass == null) {
            return null;
        }
        HashMap<PsiTypeParameter, PsiType> substitutor = new HashMap<PsiTypeParameter, PsiType>();
        PsiTypeParameter[] typeParameters = threadLocalClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiType type2 = fromType;
            if (fromType instanceof PsiPrimitiveType) {
                type2 = ((PsiPrimitiveType)fromType).getBoxedType(context);
            }
            substitutor.put(typeParameters[0], type2);
        }
        PsiElementFactory factory = psiFacade.getElementFactory();
        return factory.createType(threadLocalClass, factory.createSubstitutor(substitutor));
    }
}

