/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseJavaRefactoringAction;
import com.intellij.refactoring.typeMigration.ChangeTypeSignatureHandler;
import org.jetbrains.annotations.NotNull;

public class ChangeTypeSignatureAction
extends BaseJavaRefactoringAction {
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    public boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements.length > 1) {
            return false;
        }
        for (PsiElement element : elements) {
            if (element instanceof PsiMethod || element instanceof PsiVariable) continue;
            return false;
        }
        return true;
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        int offset = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)editor.getCaretModel().getOffset());
        PsiElement psiElement = file.findElementAt(offset);
        PsiReferenceParameterList referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiReferenceParameterList.class);
        if (referenceParameterList != null) {
            return referenceParameterList.getTypeArguments().length > 0;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiTypeElement.class) != null;
    }

    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return new ChangeTypeSignatureHandler();
    }
}

