/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.turnRefsToSuper;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class TurnRefsToSuperHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        return !PsiUtil.isModuleFile((PsiFile)file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)TurnRefsToSuperHandler.getRefactoringName(), (String)"refactoring.useInterface");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (elements.length != 1) {
            return;
        }
        PsiClass subClass = (PsiClass)elements[0];
        ArrayList<PsiClass> basesList = RefactoringHierarchyUtil.createBasesList(subClass, true, true);
        if (basesList.isEmpty()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"interface.does.not.have.base.interfaces", (Object[])new Object[]{subClass.getQualifiedName()}));
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)TurnRefsToSuperHandler.getRefactoringName(), (String)"refactoring.useInterface");
            return;
        }
        new TurnRefsToSuperDialog(project, subClass, basesList).show();
    }

    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"use.interface.where.possible.title", (Object[])new Object[0]);
    }
}

