/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithFactory;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.replaceConstructorWithFactory.ReplaceConstructorWithFactoryDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ReplaceConstructorWithFactoryHandler
implements RefactoringActionHandler {
    @Deprecated
    public static final String REFACTORING_NAME = "Replace Constructor With Factory Method";
    private Project myProject;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"error.wrong.caret.position.constructor", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)ReplaceConstructorWithFactoryHandler.getRefactoringName(), (String)"refactoring.replaceConstrWithFactory");
                return;
            }
            if (element instanceof PsiReferenceExpression) {
                PsiElement psiElement = ((PsiReferenceExpression)element).resolve();
                if (psiElement instanceof PsiMethod && ((PsiMethod)psiElement).isConstructor()) {
                    this.invoke(project, new PsiElement[]{psiElement}, dataContext);
                    return;
                }
            } else if (element instanceof PsiConstructorCall) {
                PsiElement classElement;
                PsiJavaCodeReferenceElement classReference2;
                PsiConstructorCall constructorCall = (PsiConstructorCall)element;
                PsiMethod method = constructorCall.resolveConstructor();
                if (method != null) {
                    this.invoke(project, new PsiElement[]{method}, dataContext);
                    return;
                }
                if (element instanceof PsiNewExpression && (classReference2 = ((PsiNewExpression)element).getClassReference()) != null && (classElement = classReference2.resolve()) instanceof PsiClass) {
                    this.invoke(project, new PsiElement[]{classElement}, dataContext);
                    return;
                }
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass) && ((PsiClass)element).getConstructors().length == 0) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (elements.length != 1) {
            return;
        }
        this.myProject = project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (elements[0] instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)elements[0];
            this.invoke(method, editor);
        } else if (elements[0] instanceof PsiClass) {
            this.invoke((PsiClass)elements[0], editor);
        }
    }

    private void invoke(PsiClass aClass, Editor editor) {
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            this.showJspOrLocalClassMessage(editor);
            return;
        }
        if (!this.checkAbstractClassOrInterfaceMessage(aClass, editor)) {
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length > 0) {
            String message2 = JavaRefactoringBundle.message((String)"class.does.not.have.implicit.default.constructor", (Object[])new Object[]{aClass.getQualifiedName()});
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message2, (String)ReplaceConstructorWithFactoryHandler.getRefactoringName(), (String)"refactoring.replaceConstrWithFactory");
            return;
        }
        int answer = Messages.showYesNoDialog((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"would.you.like.to.replace.default.constructor.of.0.with.factory.method", (Object[])new Object[]{aClass.getQualifiedName()}), (String)ReplaceConstructorWithFactoryHandler.getRefactoringName(), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)aClass)) {
            return;
        }
        new ReplaceConstructorWithFactoryDialog(this.myProject, null, aClass).show();
    }

    private void showJspOrLocalClassMessage(Editor editor) {
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"refactoring.is.not.supported.for.local.and.jsp.classes", (Object[])new Object[0]));
        CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message2, (String)ReplaceConstructorWithFactoryHandler.getRefactoringName(), (String)"refactoring.replaceConstrWithFactory");
    }

    private boolean checkAbstractClassOrInterfaceMessage(PsiClass aClass, Editor editor) {
        if (!aClass.hasModifierProperty("abstract")) {
            return true;
        }
        String message2 = RefactoringBundle.getCannotRefactorMessage((String)(aClass.isInterface() ? JavaRefactoringBundle.message((String)"class.is.interface", (Object[])new Object[]{aClass.getQualifiedName()}) : JavaRefactoringBundle.message((String)"class.is.abstract", (Object[])new Object[]{aClass.getQualifiedName()})));
        CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message2, (String)ReplaceConstructorWithFactoryHandler.getRefactoringName(), (String)"refactoring.replaceConstrWithFactory");
        return false;
    }

    private void invoke(PsiMethod method, Editor editor) {
        if (!method.isConstructor()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"method.is.not.a.constructor", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message2, (String)ReplaceConstructorWithFactoryHandler.getRefactoringName(), (String)"refactoring.replaceConstrWithFactory");
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || aClass.getQualifiedName() == null) {
            this.showJspOrLocalClassMessage(editor);
            return;
        }
        if (!this.checkAbstractClassOrInterfaceMessage(aClass, editor)) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)method)) {
            return;
        }
        new ReplaceConstructorWithFactoryDialog(this.myProject, method, method.getContainingClass()).show();
    }

    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"replace.constructor.with.factory.method.title", (Object[])new Object[0]);
    }
}

