/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.rename.naming.AutomaticGetterSetterRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AutomaticGetterSetterRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        return element instanceof PsiField && JavaLanguage.INSTANCE.equals(element.getLanguage());
    }

    public String getOptionName() {
        return JavaRefactoringBundle.message((String)"rename.accessors", (Object[])new Object[0]);
    }

    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isToRenameAccessors();
    }

    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameAccessors(enabled);
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new AutomaticGetterSetterRenamer(element, newName);
    }
}

