/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SingleSourceRootMoveDestination
implements MoveDestination {
    private static final Logger LOG = Logger.getInstance(SingleSourceRootMoveDestination.class);
    @NotNull
    private final PackageWrapper myPackage;
    @NotNull
    private final PsiDirectory myTargetDirectory;

    public SingleSourceRootMoveDestination(@NotNull PackageWrapper aPackage, @NotNull PsiDirectory targetDirectory) {
        LOG.assertTrue(aPackage.equalToPackage(JavaDirectoryService.getInstance().getPackage(targetDirectory)));
        this.myPackage = aPackage;
        this.myTargetDirectory = targetDirectory;
    }

    @NotNull
    public PackageWrapper getTargetPackage() {
        return this.myPackage;
    }

    public PsiDirectory getTargetIfExists(PsiDirectory source) {
        return this.myTargetDirectory;
    }

    public PsiDirectory getTargetIfExists(@NotNull PsiFile source) {
        return this.myTargetDirectory;
    }

    public PsiDirectory getTargetDirectory(PsiDirectory source) {
        return this.myTargetDirectory;
    }

    public String verify(PsiFile source) {
        return null;
    }

    public String verify(PsiDirectory source) {
        return null;
    }

    public String verify(PsiPackage source) {
        return null;
    }

    public void analyzeModuleConflicts(@NotNull Collection<? extends PsiElement> elements, @NotNull MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
        RefactoringConflictsUtil.analyzeModuleConflicts(this.myPackage.getManager().getProject(), elements, usages, (PsiElement)this.myTargetDirectory, conflicts);
    }

    public boolean isTargetAccessible(@NotNull Project project, @NotNull VirtualFile place) {
        boolean inTestSourceContent = ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(place);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)place, (Project)project);
        VirtualFile targetVirtualFile = this.myTargetDirectory.getVirtualFile();
        return module == null || GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)inTestSourceContent).contains(targetVirtualFile);
    }

    public PsiDirectory getTargetDirectory(PsiFile source) {
        return this.myTargetDirectory;
    }
}

