/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPullUp;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.PullUpConflictsUtil;
import com.intellij.refactoring.memberPullUp.PullUpDialog;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPullUpHandler
implements RefactoringActionHandler,
PullUpDialog.Callback,
ElementsHandler,
ContextAwareActionHandler {
    @Deprecated
    public static final String REFACTORING_NAME = "Pull Members Up";
    private PsiClass mySubclass;
    private Project myProject;

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        return !JavaPullUpHandler.getElements(editor, file, true).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        List<PsiElement> elements = JavaPullUpHandler.getElements(editor, file, false);
        if (elements.isEmpty()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)JavaPullUpHandler.getRefactoringName(), (String)"refactoring.pullMembersUp");
        } else {
            this.invoke(project, elements.toArray(PsiElement.EMPTY_ARRAY), dataContext);
        }
    }

    private static List<PsiElement> getElements(Editor editor, PsiFile file, boolean stopAtCodeBlock) {
        SmartList elements = new SmartList();
        block0: for (Caret caret : editor.getCaretModel().getAllCarets()) {
            int offset = caret.getOffset();
            for (PsiElement element = file.findElementAt(offset); !(element == null || element instanceof PsiFile || stopAtCodeBlock && element instanceof PsiCodeBlock); element = element.getParent()) {
                if (!(element instanceof PsiClass) && !(element instanceof PsiField) && !(element instanceof PsiMethod)) continue;
                elements.add(element);
                continue block0;
            }
        }
        return elements;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        this.myProject = project;
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.findCommonParent((PsiElement[])elements), PsiClass.class, (boolean)false);
        this.invoke(project, dataContext, aClass, elements);
    }

    private void invoke(Project project, DataContext dataContext, PsiClass aClass, PsiElement ... selectedMembers) {
        Editor editor;
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (aClass == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{JavaPullUpHandler.getRefactoringName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)JavaPullUpHandler.getRefactoringName(), (String)"refactoring.pullMembersUp");
            return;
        }
        ArrayList<PsiClass> bases = RefactoringHierarchyUtil.createBasesList(aClass, false, true);
        if (bases.isEmpty()) {
            PsiClass containingClass = aClass.getContainingClass();
            if (containingClass != null) {
                this.invoke(project, dataContext, containingClass, new PsiElement[]{aClass});
                return;
            }
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)JavaPullUpHandler.getRefactoringName(), (String)"refactoring.pullMembersUp");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        this.mySubclass = aClass;
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(this.mySubclass, (MemberInfoBase.Filter<PsiMember>)((MemberInfoBase.Filter)element -> true));
        List members = memberInfoStorage.getClassMemberInfos((PsiElement)this.mySubclass);
        block0: for (MemberInfoBase member : members) {
            for (PsiElement aMember : selectedMembers) {
                if (!PsiTreeUtil.isAncestor((PsiElement)member.getMember(), (PsiElement)aMember, (boolean)false)) continue;
                member.setChecked(true);
                continue block0;
            }
        }
        new PullUpDialog(project, aClass, bases, memberInfoStorage, this).show();
    }

    @Override
    public boolean checkConflicts(PullUpDialog dialog) {
        List infos = dialog.getSelectedMemberInfos();
        MemberInfo[] memberInfos = infos.toArray(new MemberInfo[0]);
        PsiClass superClass = (PsiClass)dialog.getSuperClass();
        if (superClass == null || !this.checkWritable(superClass, memberInfos)) {
            return false;
        }
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiPackage targetPackage;
            PsiDirectory targetDirectory = superClass.getContainingFile().getContainingDirectory();
            PsiPackage psiPackage = targetPackage = targetDirectory != null ? JavaDirectoryService.getInstance().getPackage(targetDirectory) : null;
            if (targetDirectory != null && targetPackage != null) {
                conflicts.putAllValues(PullUpConflictsUtil.checkConflicts(memberInfos, this.mySubclass, superClass, targetPackage, targetDirectory, dialog.getContainmentVerifier()));
            }
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        if (!conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, () -> new PullUpProcessor(this.mySubclass, superClass, infos.toArray(new MemberInfo[0]), new DocCommentPolicy(dialog.getJavaDocPolicy())).run());
            boolean ok = conflictsDialog.showAndGet();
            if (!ok && conflictsDialog.isShowConflicts()) {
                dialog.close(1);
            }
            return ok;
        }
        return true;
    }

    private boolean checkWritable(PsiClass superClass, MemberInfo[] infos) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)superClass)) {
            return false;
        }
        for (MemberInfo info : infos) {
            if (info.getMember() instanceof PsiClass && info.getOverrides() != null || CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)info.getMember())) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1 && elements[0] instanceof PsiClass;
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"pull.members.up.title");
    }
}

