/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.InplaceIntroduceConstantPopup;
import com.intellij.refactoring.introduceField.IntroduceConstantDialog;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IntroduceConstantHandler
extends BaseExpressionToFieldHandler {
    protected InplaceIntroduceConstantPopup myInplaceIntroduceConstantPopup;

    public IntroduceConstantHandler() {
        super(true);
    }

    @Override
    protected String getHelpID() {
        return "refactoring.introduceConstant";
    }

    public void invoke(Project project, PsiExpression[] expressions2) {
        for (PsiExpression expression2 : expressions2) {
            PsiFile file = expression2.getContainingFile();
            if (CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) continue;
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        super.invoke(project, (PsiElement[])expressions2, null);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ElementToWorkOn.processElementToWorkOn(editor, file, IntroduceConstantHandler.getRefactoringNameText(), this.getHelpID(), project, this.getElementProcessor(project, editor));
    }

    @Override
    protected boolean invokeImpl(final Project project, PsiLocalVariable localVariable, final Editor editor) {
        PsiElement parent = localVariable.getParent();
        if (!(parent instanceof PsiDeclarationStatement)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
            return false;
        }
        LocalToFieldHandler localToFieldHandler = new LocalToFieldHandler(project, true){

            @Override
            protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(PsiClass aClass, PsiLocalVariable local, PsiExpression[] occurences, boolean isStatic) {
                return IntroduceConstantHandler.this.showRefactoringDialog(project, editor, aClass, local.getInitializer(), local.getType(), occurences, (PsiElement)local, null);
            }
        };
        return localToFieldHandler.convertLocalToField(localVariable, editor);
    }

    @Override
    protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(Project project, Editor editor, PsiClass parentClass, PsiExpression expr2, PsiType type2, PsiExpression[] occurrences, PsiElement anchorElement, PsiElement anchorElementIfAll) {
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(expr2 != null ? expr2 : anchorElement), PsiMethod.class);
        ElementToWorkOn elementToWorkOn = ElementToWorkOn.adjustElements(expr2, anchorElement);
        PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
        expr2 = elementToWorkOn.getExpression();
        String enteredName = null;
        boolean replaceAllOccurrences = true;
        AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
        if (activeIntroducer != null) {
            activeIntroducer.stopIntroduce(editor);
            expr2 = (PsiExpression)activeIntroducer.getExpr();
            localVariable = (PsiLocalVariable)activeIntroducer.getLocalVariable();
            occurrences = (PsiExpression[])activeIntroducer.getOccurrences();
            enteredName = activeIntroducer.getInputName();
            replaceAllOccurrences = activeIntroducer.isReplaceAllOccurrences();
            type2 = ((InplaceIntroduceConstantPopup)activeIntroducer).getType();
        }
        for (PsiExpression occurrence : occurrences) {
            if (!RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) continue;
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"introduce.constant.used.for.write.cannot.refactor.message", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
            IntroduceConstantHandler.highlightError(project, editor, (PsiElement)occurrence);
            return null;
        }
        if (localVariable == null) {
            PsiElement errorElement = this.isStaticFinalInitializer(expr2);
            if (errorElement != null) {
                String message3 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.expression.cannot.be.a.constant.initializer", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
                IntroduceConstantHandler.highlightError(project, editor, errorElement);
                return null;
            }
        } else {
            PsiExpression initializer = localVariable.getInitializer();
            if (initializer == null) {
                String message4 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"variable.does.not.have.an.initializer", (Object[])new Object[]{localVariable.getName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
                return null;
            }
            PsiElement errorElement = this.isStaticFinalInitializer(initializer);
            if (errorElement != null) {
                String message5 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"initializer.for.variable.cannot.be.a.constant.initializer", (Object[])new Object[]{localVariable.getName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message5, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
                IntroduceConstantHandler.highlightError(project, editor, errorElement);
                return null;
            }
        }
        TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(project, type2, containingMethod, expr2, occurrences);
        if (editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && (expr2 == null || expr2.isPhysical()) && activeIntroducer == null) {
            this.myInplaceIntroduceConstantPopup = new InplaceIntroduceConstantPopup(project, editor, parentClass, expr2, localVariable, occurrences, typeSelectorManager, anchorElement, anchorElementIfAll, expr2 != null ? this.createOccurrenceManager(expr2, parentClass) : null);
            if (this.myInplaceIntroduceConstantPopup.startInplaceIntroduceTemplate()) {
                return null;
            }
        }
        IntroduceConstantDialog dialog = new IntroduceConstantDialog(project, parentClass, expr2, localVariable, localVariable != null, occurrences, this.getParentClass(), typeSelectorManager, enteredName);
        dialog.setReplaceAllOccurrences(replaceAllOccurrences);
        if (!dialog.showAndGet()) {
            if (occurrences.length > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            return null;
        }
        return new BaseExpressionToFieldHandler.Settings(dialog.getEnteredName(), expr2, occurrences, dialog.isReplaceAllOccurrences(), true, true, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, dialog.getFieldVisibility(), localVariable, dialog.getSelectedType(), dialog.isDeleteVariable(), dialog.getDestinationClass(), dialog.isAnnotateAsNonNls(), dialog.introduceEnumConstant());
    }

    private static void highlightError(Project project, Editor editor, PsiElement errorElement) {
        if (editor != null) {
            TextRange textRange = errorElement.getTextRange();
            HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, new ArrayList());
        }
    }

    @Override
    protected String getRefactoringName() {
        return IntroduceConstantHandler.getRefactoringNameText();
    }

    @Override
    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceConstantPopup;
    }

    @Override
    protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
        return new ExpressionOccurrenceManager(selectedExpr, (PsiElement)parentClass, null);
    }

    @Override
    public PsiClass getParentClass(@NotNull PsiExpression initializerExpression) {
        PsiType type2 = initializerExpression.getType();
        if (type2 != null && PsiUtil.isConstantExpression((PsiExpression)initializerExpression) && (type2 instanceof PsiPrimitiveType || PsiType.getJavaLangString((PsiManager)initializerExpression.getManager(), (GlobalSearchScope)initializerExpression.getResolveScope()).equals((Object)type2))) {
            return super.getParentClass(initializerExpression);
        }
        PsiElement parent = (PsiElement)initializerExpression.getUserData(ElementToWorkOn.PARENT);
        if (parent == null) {
            parent = initializerExpression;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class);
        while (aClass != null) {
            if (aClass.hasModifierProperty("static")) {
                return aClass;
            }
            if (aClass.getParent() instanceof PsiJavaFile) {
                return aClass;
            }
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
        }
        return null;
    }

    @Override
    protected boolean accept(ElementToWorkOn elementToWorkOn) {
        PsiExpression expr2 = elementToWorkOn.getExpression();
        if (expr2 != null) {
            return this.isStaticFinalInitializer(expr2) == null;
        }
        PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
        PsiExpression initializer = localVariable.getInitializer();
        return initializer != null && this.isStaticFinalInitializer(initializer) == null;
    }

    @Override
    protected boolean validClass(PsiClass parentClass, Editor editor) {
        return true;
    }

    public static String getRefactoringNameText() {
        return RefactoringBundle.message((String)"introduce.constant.title");
    }
}

