/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineConstantFieldProcessor;
import com.intellij.refactoring.inline.InlineOptionsWithSearchSettingsDialog;

public class InlineFieldDialog
extends InlineOptionsWithSearchSettingsDialog {
    private final PsiReferenceExpression myReferenceExpression;
    private final PsiField myField;
    protected final int myOccurrencesNumber;

    public InlineFieldDialog(Project project, PsiField field, PsiReferenceExpression ref) {
        super(project, true, (PsiElement)field);
        this.myField = field;
        this.myReferenceExpression = ref;
        this.myInvokedOnReference = this.myReferenceExpression != null;
        this.setTitle(InlineFieldDialog.getRefactoringName());
        this.myOccurrencesNumber = this.getNumberOfOccurrences((PsiNameIdentifierOwner)this.myField);
        this.init();
    }

    protected String getNameLabelText() {
        String occurrencesString = this.myOccurrencesNumber > -1 ? "has " + this.myOccurrencesNumber + " occurrence" + (this.myOccurrencesNumber == 1 ? "" : "s") : "";
        String fieldText = PsiFormatUtil.formatVariable((PsiVariable)this.myField, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return JavaRefactoringBundle.message((String)"inline.field.field.name.label", (Object[])new Object[]{fieldText, occurrencesString});
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.field.border.title");
    }

    protected String getInlineThisText() {
        return JavaRefactoringBundle.message((String)"this.reference.only.and.keep.the.field", (Object[])new Object[0]);
    }

    protected String getInlineAllText() {
        return this.myField.isWritable() ? JavaRefactoringBundle.message((String)"all.references.and.remove.the.field", (Object[])new Object[0]) : RefactoringBundle.message((String)"all.invocations.in.project");
    }

    protected String getKeepTheDeclarationText() {
        if (this.myField.isWritable()) {
            return JavaRefactoringBundle.message((String)"all.references.keep.field", (Object[])new Object[0]);
        }
        return super.getKeepTheDeclarationText();
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_FIELD_THIS;
    }

    protected boolean ignoreOccurrence(PsiReference reference) {
        return PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiImportStatementBase.class) == null;
    }

    protected boolean isSearchInCommentsAndStrings() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD;
    }

    protected void saveSearchInCommentsAndStrings(boolean searchInComments) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD = searchInComments;
    }

    protected boolean isSearchForTextOccurrences() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FIELD;
    }

    protected void saveSearchInTextOccurrences(boolean searchInTextOccurrences) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FIELD = searchInTextOccurrences;
    }

    protected void doAction() {
        super.doAction();
        this.invokeRefactoring(new InlineConstantFieldProcessor(this.myField, this.getProject(), this.myReferenceExpression, this.isInlineThisOnly(), this.isSearchInCommentsAndStrings(), this.isSearchForTextOccurrences(), !this.isKeepTheDeclaration()));
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_FIELD_THIS = this.isInlineThisOnly();
        }
    }

    protected String getHelpId() {
        return "refactoring.inlineField";
    }

    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"inline.field.title", (Object[])new Object[0]);
    }
}

