/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PsiReflectionAccessUtil {
    PsiReflectionAccessUtil() {
    }

    public static boolean isPublicMember(@NotNull PsiMember classMember) {
        return classMember.hasModifierProperty("public") && PsiReflectionAccessUtil.isAccessible(classMember.getContainingClass());
    }

    public static boolean isAccessibleMember(@NotNull PsiMember classMember, @NotNull PsiClass outerClass, @Nullable PsiExpression qualifier) {
        if (!PsiReflectionAccessUtil.isPublicMember(classMember)) {
            return false;
        }
        if (qualifier != null) {
            return PsiReflectionAccessUtil.isQualifierAccessible(qualifier);
        }
        return !Objects.equals(outerClass.getContainingFile(), classMember.getContainingFile());
    }

    @Contract(value="null -> false")
    public static boolean isAccessible(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (PsiUtil.isArrayClass((PsiElement)psiClass)) {
            return true;
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (containingFile instanceof PsiJavaFile && ((PsiJavaFile)containingFile).getPackageName().isEmpty()) {
            return false;
        }
        while (psiClass != null) {
            if (!psiClass.hasModifierProperty("public")) {
                return false;
            }
            psiClass = psiClass.getContainingClass();
        }
        return true;
    }

    public static boolean isAccessibleMethodReference(@NotNull PsiMethodReferenceExpression methodReference) {
        PsiElement method = methodReference.resolve();
        if (!(method instanceof PsiMethod)) {
            return true;
        }
        PsiTypeElement qualifierType = methodReference.getQualifierType();
        boolean qualifierAccessible = qualifierType == null || PsiReflectionAccessUtil.isAccessibleType(qualifierType.getType());
        return qualifierAccessible && PsiReflectionAccessUtil.isPublicMember((PsiMember)method);
    }

    @Contract(value="null -> true")
    public static boolean isQualifierAccessible(@Nullable PsiExpression qualifierExpression2) {
        if (qualifierExpression2 == null) {
            return true;
        }
        PsiType type2 = qualifierExpression2.getType();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        return psiClass == null || PsiReflectionAccessUtil.isAccessible(psiClass);
    }

    @Nullable
    public static String getAccessibleReturnType(@NotNull PsiExpression expression2, @Nullable PsiType type2) {
        String expectedType = PsiReflectionAccessUtil.tryGetWeakestAccessibleExpectedType(expression2);
        if (expectedType != null) {
            return expectedType;
        }
        return type2 != null ? PsiReflectionAccessUtil.nearestAccessibleType(type2).getCanonicalText() : null;
    }

    @Nullable
    public static String getAccessibleReturnType(@NotNull PsiExpression expression2, @Nullable PsiClass psiClass) {
        String expectedType = PsiReflectionAccessUtil.tryGetWeakestAccessibleExpectedType(expression2);
        if (expectedType != null) {
            return expectedType;
        }
        return PsiReflectionAccessUtil.nearestAccessibleBaseClassName(psiClass);
    }

    @Nullable
    private static String tryGetWeakestAccessibleExpectedType(@NotNull PsiExpression expression2) {
        PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, true);
        PsiType realType = expression2.getType();
        if (expectedType != null && realType != null) {
            for (PsiType type2 : PsiReflectionAccessUtil.getAllAssignableSupertypes(realType, expectedType)) {
                if (!PsiReflectionAccessUtil.isAccessibleType(type2)) continue;
                return type2.getCanonicalText();
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiType> getAllAssignableSupertypes(@NotNull PsiType from, @NotNull PsiType to) {
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>();
        LinkedList<PsiType> queue = new LinkedList<PsiType>();
        queue.offer(from);
        while (!queue.isEmpty()) {
            PsiType type2 = (PsiType)queue.poll();
            if (!to.isAssignableFrom(type2)) continue;
            types.add(type2);
            Arrays.stream(type2.getSuperTypes()).forEach(queue::offer);
        }
        ArrayList<PsiType> result = new ArrayList<PsiType>(types);
        Collections.reverse(result);
        return result;
    }

    @NotNull
    @Contract(pure=true)
    public static String classForName(@NotNull String typeName) {
        return TypeConversionUtil.isPrimitive((String)typeName) ? typeName + ".class" : "java.lang.Class.forName(\"" + typeName + "\")";
    }

    @NotNull
    public static String getUniqueMethodName(@NotNull PsiClass psiClass, @NotNull String prefix) {
        String name2;
        if (!StringUtil.isJavaIdentifier((String)prefix)) {
            throw new IllegalArgumentException("prefix must be a correct java identifier: " + prefix);
        }
        int i = 1;
        do {
            name2 = prefix + i;
            ++i;
        } while (psiClass.findMethodsByName(name2, false).length != 0);
        return name2;
    }

    public static boolean isAccessibleType(@NotNull PsiType type2) {
        if (type2 instanceof PsiArrayType) {
            return PsiReflectionAccessUtil.isAccessibleType(type2.getDeepComponentType());
        }
        return TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type2) || PsiReflectionAccessUtil.isAccessible(PsiTypesUtil.getPsiClass((PsiType)type2));
    }

    @NotNull
    public static PsiType nearestAccessibleType(@NotNull PsiType type2) {
        while (!PsiReflectionAccessUtil.isAccessibleType(type2)) {
            type2 = type2.getSuperTypes()[0];
        }
        return type2;
    }

    @Contract(value="null -> null")
    @Nullable
    private static String nearestAccessibleBaseClassName(@Nullable PsiClass psiClass) {
        while (psiClass != null && !PsiReflectionAccessUtil.isAccessible(psiClass)) {
            psiClass = psiClass.getSuperClass();
        }
        return psiClass == null ? null : psiClass.getQualifiedName();
    }
}

