/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableDeclarationDescriptor
implements ItemToReplaceDescriptor {
    private final List<AccessibleLocalVariable> myVariables;
    private final PsiDeclarationStatement myDeclarationStatement;

    public LocalVariableDeclarationDescriptor(@NotNull List<AccessibleLocalVariable> names2, PsiDeclarationStatement statement) {
        this.myVariables = names2;
        this.myDeclarationStatement = statement;
    }

    @Nullable
    public static ItemToReplaceDescriptor createIfInaccessible(@NotNull PsiDeclarationStatement declarationStatement) {
        ArrayList<AccessibleLocalVariable> variables = new ArrayList<AccessibleLocalVariable>();
        for (PsiElement element : declarationStatement.getDeclaredElements()) {
            if (!(element instanceof PsiLocalVariable)) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)element;
            String name2 = variable.getName();
            PsiType variableType = variable.getType();
            if (PsiReflectionAccessUtil.isAccessibleType(variableType)) continue;
            variables.add(new AccessibleLocalVariable(name2, PsiReflectionAccessUtil.nearestAccessibleType(variableType), variable));
        }
        if (!variables.isEmpty()) {
            return new LocalVariableDeclarationDescriptor(variables, declarationStatement);
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        AccessibleLocalVariable variable = this.myVariables.get(0);
        PsiDeclarationStatement lastDeclaration = variable.toVariableDeclaration(elementFactory);
        this.myDeclarationStatement.replace((PsiElement)lastDeclaration);
        for (int i = 1; i < this.myVariables.size(); ++i) {
            variable = this.myVariables.get(i);
            PsiDeclarationStatement declaration2 = variable.toVariableDeclaration(elementFactory);
            lastDeclaration.getParent().addAfter((PsiElement)declaration2, (PsiElement)lastDeclaration);
            lastDeclaration = declaration2;
        }
    }

    private static class AccessibleLocalVariable {
        private final String myName;
        private final PsiType myAccessibleType;
        private final PsiLocalVariable myLocalVariable;

        private AccessibleLocalVariable(@NotNull String name2, @NotNull PsiType type2, @NotNull PsiLocalVariable localVariable) {
            this.myName = name2;
            this.myAccessibleType = type2;
            this.myLocalVariable = localVariable;
        }

        private PsiDeclarationStatement toVariableDeclaration(@NotNull PsiElementFactory elementFactory) {
            return elementFactory.createVariableDeclarationStatement(this.myName, this.myAccessibleType, this.myLocalVariable.getInitializer(), (PsiElement)this.myLocalVariable);
        }
    }
}

