/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseJavaRefactoringAction;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsHandler;
import org.jetbrains.annotations.NotNull;

public class EncapsulateFieldsAction
extends BaseJavaRefactoringAction {
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context, @NotNull String place) {
        PsiElement psiElement = file.findElementAt(editor.getCaretModel().getOffset());
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        if (containingClass != null) {
            PsiField[] fields;
            if ((ActionPlaces.isPopupPlace((String)place) || place.equals("RefactoringQuickList")) && PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiField.class, (boolean)false) == null) {
                return false;
            }
            for (PsiField field : fields = containingClass.getFields()) {
                if (!EncapsulateFieldsAction.isAcceptedField((PsiElement)field)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof PsiClass && elements[0].getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || EncapsulateFieldsAction.isAcceptedField(elements[0]);
        }
        if (elements.length > 1) {
            for (PsiElement element : elements) {
                if (EncapsulateFieldsAction.isAcceptedField(element)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        return new EncapsulateFieldsHandler();
    }

    private static boolean isAcceptedField(PsiElement element) {
        return element instanceof PsiField && element.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && ((PsiField)element).getContainingClass() != null;
    }
}

