/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.refactoring.JavaRefactoringSettings;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaRefactoringUsageCollector
extends ApplicationUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "java.refactoring.settings";
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        JavaRefactoringSettings defaultSettings = new JavaRefactoringSettings();
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_FIELD, (String)"rename.search.in.comments.for.field");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_METHOD, (String)"rename.search.in.comments.for.method");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_CLASS, (String)"rename.search.in.comments.for.class");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, (String)"rename.search.in.comments.for.package");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE, (String)"rename.search.in.comments.for.variable");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_FIELD, (String)"rename.search.for.text.for.field");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_METHOD, (String)"rename.search.for.text.for.method");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_CLASS, (String)"rename.search.for.text.for.class");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE, (String)"rename.search.for.text.for.package");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE, (String)"rename.search.for.text.for.variable");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_INHERITORS, (String)"rename.auto.inheritors");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_OVERLOADS, (String)"rename.auto.overloads");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_TESTS, (String)"rename.auto.tests");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_VARIABLES, (String)"rename.auto.variables");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_LOCAL_CREATE_FINALS, (String)"introduce.local.create.finals");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_LOCAL_CREATE_VAR_TYPE, (String)"introduce.local.use.var");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.MOVE_SEARCH_IN_COMMENTS, (String)"move.search.in.comments");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.MOVE_SEARCH_FOR_TEXT, (String)"move.search.for.text");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.ENCAPSULATE_FIELDS_USE_ACCESSORS_WHEN_ACCESSIBLE, (String)"encapsulate.fields.use.accessors");
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> JavaRefactoringUsageCollector.getReplaceGettersOption(settings.INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS), javadoc -> new MetricEvent("introduce.parameter.replace.fields.with.getters", new FeatureUsageData().addData("replace.fields.with.getters", javadoc)));
        JavaRefactoringUsageCollector.addJavadoc(result, settings, defaultSettings, "extract.interface.javadoc", settings.EXTRACT_INTERFACE_JAVADOC);
        JavaRefactoringUsageCollector.addJavadoc(result, settings, defaultSettings, "extract.superclass.javadoc", settings.EXTRACT_SUPERCLASS_JAVADOC);
        JavaRefactoringUsageCollector.addJavadoc(result, settings, defaultSettings, "pull.up.members.javadoc", settings.PULL_UP_MEMBERS_JAVADOC);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_PARAMETER_DELETE_LOCAL_VARIABLE, (String)"introduce.parameter.delete.local");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_PARAMETER_USE_INITIALIZER, (String)"introduce.parameter.use.initializer");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_PARAMETER_CREATE_FINALS, (String)"introduce.parameter.create.finals");
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> JavaRefactoringUsageCollector.getVisibility(settings.INTRODUCE_FIELD_VISIBILITY), javadoc -> new MetricEvent("introduce.field.visibility", new FeatureUsageData().addData("visibility", javadoc)));
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> JavaRefactoringUsageCollector.getVisibility(settings.INTRODUCE_CONSTANT_VISIBILITY), javadoc -> new MetricEvent("introduce.constant.visibility", new FeatureUsageData().addData("visibility", javadoc)));
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_METHOD_THIS, (String)"inline.method.this.only.choice");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_SUPER_CLASS_THIS, (String)"inline.super.class.this.only.choice");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_FIELD_THIS, (String)"inline.field.this.only.choice");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_LOCAL_THIS, (String)"inline.local.this.only.choice");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INHERITANCE_TO_DELEGATION_DELEGATE_OTHER, (String)"inheritance.to.delegation.delegate.other");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_CONSTANT_MOVE_TO_ANOTHER_CLASS, (String)"introduce.constant.move.to.another.class");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_CLASS_SEARCH_IN_COMMENTS, (String)"inline.class.search.in.comments");
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_CLASS_SEARCH_IN_NON_JAVA, (String)"inline.class.search.in.non.java");
        return result;
    }

    private static void addJavadoc(Set<MetricEvent> result, JavaRefactoringSettings settings, JavaRefactoringSettings defaultSettings, String eventId, int javadocOption) {
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> JavaRefactoringUsageCollector.getJavadocOption(javadocOption), javadoc -> new MetricEvent(eventId, new FeatureUsageData().addData("javadoc", javadoc)));
    }

    private static String getVisibility(String visibility) {
        return "public".equals(visibility) || "private".equals(visibility) || "protected".equals(visibility) || "packageLocal".equals(visibility) || "EscalateVisible".equals(visibility) ? visibility : "unknown";
    }

    private static String getJavadocOption(int javadoc) {
        switch (javadoc) {
            case 0: {
                return "as is";
            }
            case 2: {
                return "copy";
            }
            case 1: {
                return "move";
            }
        }
        return "unknown";
    }

    private static String getReplaceGettersOption(int getters) {
        switch (getters) {
            case 0: {
                return "none";
            }
            case 1: {
                return "inaccessible";
            }
            case 2: {
                return "all";
            }
        }
        return "unknown";
    }
}

