/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiRecordUtil {
    @Nullable
    public static PsiRecordComponent getRecordComponentForAccessor(@NotNull PsiMethod accessor) {
        PsiElement parent;
        PsiClass aClass = accessor.getContainingClass();
        if (aClass == null && (parent = accessor.getParent()) instanceof DummyHolder) {
            aClass = (PsiClass)ObjectUtils.tryCast((Object)parent.getContext(), PsiClass.class);
        }
        if (aClass == null || !aClass.isRecord()) {
            return null;
        }
        if (!accessor.getParameterList().isEmpty()) {
            return null;
        }
        String name2 = accessor.getName();
        for (PsiRecordComponent c : aClass.getRecordComponents()) {
            if (!name2.equals(c.getName())) continue;
            return c;
        }
        return null;
    }

    @Nullable
    public static PsiField getFieldForComponent(@NotNull PsiRecordComponent component) {
        PsiClass aClass = component.getContainingClass();
        if (aClass == null) {
            return null;
        }
        String name2 = component.getName();
        for (PsiField field : aClass.getFields()) {
            if (!field.getName().equals(name2) || field.hasModifierProperty("static")) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public static PsiRecordComponent getComponentForField(@NotNull PsiField field) {
        return field instanceof LightRecordField ? ((LightRecordField)field).getRecordComponent() : null;
    }

    public static boolean isCompactConstructor(@NotNull PsiMethod method) {
        return method.isConstructor() && method.getParameterList().getText() == null;
    }

    public static boolean isExplicitCanonicalConstructor(@NotNull PsiMethod method) {
        if (!method.isConstructor() || JavaPsiRecordUtil.isCompactConstructor(method)) {
            return false;
        }
        if (method instanceof SyntheticElement) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !aClass.isRecord()) {
            return false;
        }
        return JavaPsiRecordUtil.hasCanonicalSignature(method, aClass.getRecordComponents());
    }

    public static boolean isCanonicalConstructor(@NotNull PsiMethod method) {
        if (method instanceof LightRecordCanonicalConstructor) {
            return true;
        }
        if (!method.isConstructor()) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null || !aClass.isRecord()) {
            return false;
        }
        return method.getParameterList().getText() == null || JavaPsiRecordUtil.hasCanonicalSignature(method, aClass.getRecordComponents());
    }

    private static boolean hasCanonicalSignature(@NotNull PsiMethod method, PsiRecordComponent[] components) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (components.length != parameters2.length) {
            return false;
        }
        for (int i = 0; i < parameters2.length; ++i) {
            PsiType componentType = components[i].getType();
            PsiType parameterType = parameters2[i].getType();
            if (componentType instanceof PsiEllipsisType) {
                componentType = ((PsiEllipsisType)componentType).toArrayType();
            }
            if (parameterType instanceof PsiEllipsisType) {
                parameterType = ((PsiEllipsisType)parameterType).toArrayType();
            }
            if (TypeConversionUtil.erasure((PsiType)componentType).equals(TypeConversionUtil.erasure((PsiType)parameterType))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiMethod findCanonicalConstructor(@NotNull PsiClass recordClass) {
        if (!recordClass.isRecord()) {
            return null;
        }
        PsiMethod[] constructors = recordClass.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        PsiRecordComponent[] components = recordClass.getRecordComponents();
        for (PsiMethod constructor : constructors) {
            if (!JavaPsiRecordUtil.isCompactConstructor(constructor) && !JavaPsiRecordUtil.hasCanonicalSignature(constructor, components)) continue;
            return constructor;
        }
        return null;
    }
}

