/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DuplicateConflictResolver
implements PsiConflictResolver {
    public static final DuplicateConflictResolver INSTANCE = new DuplicateConflictResolver();

    private DuplicateConflictResolver() {
    }

    @Override
    public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        HashMap<String, CandidateInfo> uniqueItems = new HashMap<String, CandidateInfo>();
        for (CandidateInfo info : conflicts) {
            PsiElement element = info.getElement();
            String key2 = info instanceof MethodCandidateInfo ? ((PsiMethod)element).getSignature(((MethodCandidateInfo)info).getSubstitutor(false)) : PsiUtilCore.getName((PsiElement)element);
            if (uniqueItems.containsKey(key2)) continue;
            uniqueItems.put(key2, info);
        }
        if (uniqueItems.size() == 1) {
            return (CandidateInfo)uniqueItems.values().iterator().next();
        }
        return null;
    }
}

