/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.resolve;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.DuplicateConflictResolver;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodResolveHelper {
    private final Set<MethodSignature> myDuplicates = new THashSet();
    private final MethodCandidatesProcessor myProcessor;
    private final PsiType @Nullable [] myArgumentTypes;

    public JavaMethodResolveHelper(final @NotNull PsiElement argumentList, PsiFile containingFile, final PsiType @Nullable [] argumentTypes) {
        this.myArgumentTypes = argumentTypes;
        final LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)argumentList);
        PsiConflictResolver resolver = argumentTypes == null ? DuplicateConflictResolver.INSTANCE : new JavaMethodsConflictResolver(argumentList, argumentTypes, languageLevel, containingFile);
        this.myProcessor = new MethodResolverProcessor(argumentList, containingFile, new PsiConflictResolver[]{resolver}){

            @Override
            @NotNull
            protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean staticProblem, boolean accessible, boolean varargs) {
                return JavaMethodResolveHelper.this.createCandidateInfo(method, substitutor, staticProblem, this.myCurrentFileContext, !accessible, argumentList, argumentTypes, languageLevel, varargs);
            }

            @Override
            protected boolean isAccepted(@NotNull PsiMethod candidate) {
                return !candidate.isConstructor();
            }
        };
    }

    @NotNull
    protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem, PsiElement currentFileContext, boolean accessProblem, PsiElement argumentList, PsiType[] argumentTypes, @NotNull LanguageLevel languageLevel, final boolean vararg) {
        return new MethodCandidateInfo((PsiElement)method, substitutor, accessProblem, staticProblem, argumentList, currentFileContext, argumentTypes, PsiType.EMPTY_ARRAY, languageLevel){

            public boolean isVarargs() {
                return vararg;
            }
        };
    }

    public void addMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, boolean staticError) {
        if (this.myDuplicates.add(method.getSignature(substitutor))) {
            this.myProcessor.addMethod(method, substitutor, staticError);
        }
    }

    @NotNull
    public ErrorType getResolveError() {
        List<CandidateInfo> candidates = this.getCandidates();
        if (candidates.size() != 1) {
            return ErrorType.RESOLVE;
        }
        if (!candidates.get(0).isStaticsScopeCorrect()) {
            return ErrorType.STATIC;
        }
        return this.getResolveError((MethodCandidateInfo)candidates.get(0));
    }

    protected List<CandidateInfo> getCandidates() {
        return Arrays.asList(this.myProcessor.getCandidates());
    }

    protected ErrorType getResolveError(MethodCandidateInfo info) {
        if (this.myArgumentTypes == null) {
            return ErrorType.NONE;
        }
        if (!info.isApplicable()) {
            boolean hasNulls = false;
            PsiParameter[] parameters2 = info.getElement().getParameterList().getParameters();
            if (this.myArgumentTypes.length == parameters2.length) {
                for (int i = 0; i < this.myArgumentTypes.length; ++i) {
                    PsiType type2 = this.myArgumentTypes[i];
                    if (type2 == null) {
                        hasNulls = true;
                        continue;
                    }
                    if (parameters2[i].getType().isAssignableFrom(type2)) continue;
                    return ErrorType.RESOLVE;
                }
            }
            return hasNulls ? ErrorType.NONE : ErrorType.RESOLVE;
        }
        return ErrorType.NONE;
    }

    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        this.myProcessor.handleEvent(event, associated);
    }

    public Collection<JavaMethodCandidateInfo> getMethods() {
        return ContainerUtil.mapNotNull(this.getCandidates(), javaResolveResult -> new JavaMethodCandidateInfo((PsiMethod)javaResolveResult.getElement(), javaResolveResult.getSubstitutor()));
    }

    public static enum ErrorType {
        NONE,
        STATIC,
        RESOLVE;

    }
}

