/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.JavaDummyHolder;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiLocalVariableImpl
extends CompositePsiElement
implements PsiLocalVariable,
PsiVariableEx {
    private static final Logger LOG = Logger.getInstance(PsiLocalVariableImpl.class);
    private volatile String myCachedName;

    public PsiLocalVariableImpl() {
        this(JavaElementType.LOCAL_VARIABLE);
    }

    PsiLocalVariableImpl(@NotNull IElementType type2) {
        super(type2);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myCachedName = null;
    }

    @NotNull
    public final PsiIdentifier getNameIdentifier() {
        PsiElement element = this.findChildByRoleAsPsiElement(9);
        assert (element instanceof PsiIdentifier) : this.getText();
        return (PsiIdentifier)element;
    }

    @NotNull
    public final String getName() {
        String cachedName = this.myCachedName;
        if (cachedName == null) {
            this.myCachedName = cachedName = this.getNameIdentifier().getText();
        }
        return cachedName;
    }

    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name2);
        return this;
    }

    @NotNull
    public final PsiType getType() {
        return JavaSharedImplUtil.getType(this.getTypeElement(), (PsiElement)this.getNameIdentifier());
    }

    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getChildOfType((PsiElement)this, PsiTypeElement.class);
        if (typeElement != null) {
            return typeElement;
        }
        PsiElement parent = this.getParent();
        assert (parent != null) : "no parent; " + this + "; [" + this.getText() + "]";
        PsiLocalVariable localVariable = (PsiLocalVariable)PsiTreeUtil.getChildOfType((PsiElement)parent, PsiLocalVariable.class);
        assert (localVariable != null) : "no local variable in " + Arrays.toString(parent.getChildren());
        typeElement = (PsiTypeElement)PsiTreeUtil.getChildOfType((PsiElement)localVariable, PsiTypeElement.class);
        assert (typeElement != null) : "no type element in " + Arrays.toString(localVariable.getChildren());
        return typeElement;
    }

    public PsiModifierList getModifierList() {
        CompositeElement parent = this.getTreeParent();
        if (parent == null) {
            return null;
        }
        CompositeElement first = (CompositeElement)parent.findChildByType(JavaElementType.LOCAL_VARIABLE);
        return first != null ? (PsiModifierList)first.findChildByRoleAsPsiElement(8) : null;
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name2);
    }

    public PsiExpression getInitializer() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(21);
    }

    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    public Object computeConstantValue() {
        return this.computeConstantValue((Set<PsiVariable>)new THashSet());
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        PsiType type2 = this.getType();
        if (!(type2 instanceof PsiPrimitiveType) && !type2.equalsToText("java.lang.String")) {
            return null;
        }
        PsiExpression initializer = this.getInitializer();
        if (initializer == null) {
            return null;
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, this.getType(), visitedVars);
    }

    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
        PsiElement[] variables;
        CheckUtil.checkWritable((PsiElement)this);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
        CompositeElement statement = this.getTreeParent();
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)statement);
        PsiElement[] psiElementArray = variables = psiElement instanceof PsiDeclarationStatement ? ((PsiDeclarationStatement)psiElement).getDeclaredElements() : PsiElement.EMPTY_ARRAY;
        if (variables.length > 1) {
            PsiModifierList modifierList = this.getModifierList();
            PsiTypeElement typeElement = this.getTypeElement();
            assert (modifierList != null) : this.getText();
            CompositeElement last = statement;
            for (int i = 1; i < variables.length; ++i) {
                ASTNode typeCopy = typeElement.copy().getNode();
                ASTNode modifierListCopy = modifierList.copy().getNode();
                CompositeElement variable = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)variables[i]);
                ASTNode comma = PsiImplUtil.skipWhitespaceAndCommentsBack((ASTNode)variable.getTreePrev());
                if (comma != null && comma.getElementType() == JavaTokenType.COMMA) {
                    PsiElement nextSibling;
                    PsiElement lastWhitespaceAfterComma = comma.getPsi();
                    while ((nextSibling = lastWhitespaceAfterComma.getNextSibling()) instanceof PsiWhiteSpace) {
                        lastWhitespaceAfterComma = nextSibling;
                    }
                    CodeEditUtil.removeChildren((ASTNode)statement, (ASTNode)comma, (ASTNode)lastWhitespaceAfterComma.getNode());
                }
                CodeEditUtil.removeChild((ASTNode)statement, (ASTNode)variable);
                CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)statement);
                CompositeElement statement1 = Factory.createCompositeElement((IElementType)JavaElementType.DECLARATION_STATEMENT, (CharTable)charTableByTree, (PsiManager)this.getManager());
                statement1.addChild((ASTNode)variable, null);
                LeafElement space = Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)" ", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                variable.addChild((ASTNode)space, (ASTNode)variable.getFirstChildNode());
                variable.addChild(typeCopy, (ASTNode)variable.getFirstChildNode());
                if (modifierListCopy.getTextLength() > 0) {
                    space = Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)" ", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    variable.addChild((ASTNode)space, (ASTNode)variable.getFirstChildNode());
                }
                variable.addChild(modifierListCopy, (ASTNode)variable.getFirstChildNode());
                LeafElement semicolon = Factory.createSingleLeafElement((IElementType)JavaTokenType.SEMICOLON, (CharSequence)";", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)variables[i - 1]).addChild((ASTNode)semicolon, null);
                CodeEditUtil.addChild((ASTNode)statement.getTreeParent(), (ASTNode)statement1, (ASTNode)last.getTreeNext());
                last = statement1;
            }
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode eq;
        if (this.getChildRole(child) == 21 && (eq = this.findChildByRole(20)) != null) {
            this.deleteChildInternal(eq);
        }
        super.deleteChildInternal(child);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 8: {
                return this.findChildByType(JavaElementType.MODIFIER_LIST);
            }
            case 10: {
                return this.findChildByType(JavaElementType.TYPE);
            }
            case 9: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 20: {
                return this.findChildByType(JavaTokenType.EQ);
            }
            case 21: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.SEMICOLON);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.MODIFIER_LIST) {
            return 8;
        }
        if (i == JavaElementType.TYPE) {
            return this.getChildRole(child, 10);
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i == JavaTokenType.EQ) {
            return this.getChildRole(child, 20);
        }
        if (i == JavaTokenType.SEMICOLON) {
            return this.getChildRole(child, 22);
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 21;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitLocalVariable((PsiLocalVariable)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (lastParent == null) {
            return true;
        }
        if (lastParent.getContext() instanceof JavaDummyHolder) {
            return processor2.execute((PsiElement)this, state);
        }
        if (lastParent.getParent() != this) {
            return true;
        }
        ASTNode lastParentTree = SourceTreeToPsiMap.psiElementToTree((PsiElement)lastParent);
        return this.getChildRole(lastParentTree) != 21 || processor2.execute((PsiElement)this, state);
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public String toString() {
        return "PsiLocalVariable:" + this.getName();
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement parentElement = this.getParent();
        if (parentElement instanceof PsiDeclarationStatement) {
            return new LocalSearchScope(parentElement.getParent());
        }
        return ResolveScopeManager.getElementUseScope((PsiElement)this);
    }

    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, PlatformIcons.VARIABLE_ICON, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }
}

