/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.tree.java.PsiMethodReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferenceResolver
implements ResolveCache.PolyVariantContextResolver<PsiMethodReferenceExpressionImpl> {
    public JavaResolveResult @NotNull [] resolve(final @NotNull PsiMethodReferenceExpressionImpl reference, @NotNull PsiFile containingFile, boolean incompleteCode) {
        final PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)reference);
        final PsiClass containingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor substitutor = qualifierResolveResult.getSubstitutor();
        if (containingClass != null) {
            PsiElement element = reference.getReferenceNameElement();
            boolean isConstructor = reference.isConstructor();
            if (element instanceof PsiIdentifier || isConstructor) {
                if (isConstructor && !MethodReferenceResolver.canBeConstructed(containingClass)) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                final PsiType functionalInterfaceType = reference.getFunctionalInterfaceType();
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                final PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
                PsiSubstitutor functionalInterfaceSubstitutor = interfaceMethod != null ? LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult) : null;
                final MethodSignature signature = interfaceMethod != null ? interfaceMethod.getSignature(functionalInterfaceSubstitutor) : null;
                final PsiType interfaceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                if (isConstructor && containingClass.getConstructors().length == 0) {
                    JavaResolveResult[] javaResolveResultArray;
                    if (interfaceMethodReturnType != null) {
                        PsiClassType returnType = MethodReferenceResolver.composeReturnType(containingClass, substitutor);
                        InferenceSession session = new InferenceSession(containingClass.getTypeParameters(), substitutor, (PsiManager)reference.getManager(), null);
                        if (!session.isProperType(session.substituteWithInferenceVariables((PsiType)returnType)) || !session.isProperType(interfaceMethodReturnType)) {
                            session.registerReturnTypeConstraints((PsiType)returnType, interfaceMethodReturnType, (PsiElement)reference);
                            substitutor = session.infer();
                        }
                    }
                    ClassCandidateInfo candidateInfo = null;
                    boolean isArray = PsiUtil.isArrayClass((PsiElement)containingClass);
                    if (signature == null || !isArray && (containingClass.getContainingClass() == null || !MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) && signature.getParameterTypes().length == 0 || isArray && MethodReferenceResolver.arrayCreationSignature(signature)) {
                        candidateInfo = new ClassCandidateInfo((PsiElement)containingClass, substitutor);
                    }
                    if (candidateInfo == null) {
                        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                    } else {
                        JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                        javaResolveResultArray = javaResolveResultArray2;
                        javaResolveResultArray2[0] = candidateInfo;
                    }
                    return javaResolveResultArray;
                }
                PsiConflictResolver conflictResolver = this.createResolver(reference, qualifierResolveResult, interfaceMethod, signature);
                MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor((PsiElement)reference, containingFile, new PsiConflictResolver[]{conflictResolver}, (List)new SmartList()){

                    @Override
                    protected boolean acceptVarargs() {
                        return true;
                    }

                    @Override
                    @NotNull
                    protected MethodCandidateInfo createCandidateInfo(final @NotNull PsiMethod method, final @NotNull PsiSubstitutor substitutor, boolean staticProblem, boolean accessible, final boolean varargs) {
                        PsiExpressionList argumentList = this.getArgumentList();
                        PsiType[] typeParameters = reference.getTypeParameters();
                        return new MethodCandidateInfo((PsiElement)method, substitutor, !accessible, staticProblem, (PsiElement)argumentList, this.myCurrentFileContext, argumentList != null ? argumentList.getExpressionTypes() : null, method.hasTypeParameters() && typeParameters.length > 0 ? typeParameters : null, this.getLanguageLevel()){

                            public boolean isVarargs() {
                                return varargs;
                            }

                            @NotNull
                            public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
                                return includeReturnConstraint ? this.inferTypeArguments(true) : (PsiSubstitutor)Objects.requireNonNull(MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)reference, false, () -> this.inferTypeArguments(false)));
                            }

                            private PsiSubstitutor inferTypeArguments(boolean includeReturnConstraint) {
                                if (interfaceMethod == null) {
                                    return substitutor;
                                }
                                InferenceSession session = new InferenceSession(method.getTypeParameters(), substitutor, (PsiManager)reference.getManager(), (PsiElement)reference);
                                session.initThrowsConstraints(method);
                                PsiSubstitutor psiSubstitutor = session.collectApplicabilityConstraints(reference, this, functionalInterfaceType);
                                if (psiSubstitutor != null) {
                                    return psiSubstitutor;
                                }
                                if (!session.repeatInferencePhases()) {
                                    List<String> errorMessages = session.getIncompatibleErrorMessages();
                                    if (errorMessages != null) {
                                        this.setApplicabilityError(StringUtil.join(errorMessages, (String)"\n"));
                                    }
                                    return substitutor;
                                }
                                if (includeReturnConstraint && !PsiType.VOID.equals((Object)interfaceMethodReturnType) && interfaceMethodReturnType != null) {
                                    PsiClassType returnType;
                                    Object object = returnType = method.isConstructor() ? MethodReferenceResolver.composeReturnType(containingClass, substitutor) : PsiMethodReferenceCompatibilityConstraint.getSubstitutor(signature, qualifierResolveResult, (PsiMember)method, containingClass, reference).substitute(method.getReturnType());
                                    if (returnType != null) {
                                        session.registerReturnTypeConstraints((PsiType)returnType, interfaceMethodReturnType, (PsiElement)reference);
                                    }
                                }
                                return session.infer(method.getParameterList().getParameters(), null, null, null);
                            }

                            public boolean isApplicable() {
                                boolean hasReceiver;
                                if (signature == null) {
                                    return false;
                                }
                                if (this.getInferenceErrorMessageAssumeAlreadyComputed() != null) {
                                    return false;
                                }
                                PsiType[] argTypes = signature.getParameterTypes();
                                return MethodReferenceConflictResolver.isApplicableByFirstSearch((CandidateInfo)this, argTypes, hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible((PsiType[])argTypes, (PsiMethodReferenceUtil.QualifierResolveResult)qualifierResolveResult, (PsiMethodReferenceExpression)reference), reference, interfaceMethod.isVarArgs(), interfaceMethod) != null;
                            }
                        };
                    }
                };
                processor2.setIsConstructor(isConstructor);
                processor2.setName(isConstructor ? containingClass.getName() : element.getText());
                PsiExpression expression2 = reference.getQualifierExpression();
                if (expression2 == null || !(expression2.getType() instanceof PsiArrayType) && !(expression2 instanceof PsiSuperExpression)) {
                    processor2.setAccessClass(containingClass);
                }
                if (qualifierResolveResult.isReferenceTypeQualified() && MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) {
                    processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
                }
                ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor);
                containingClass.processDeclarations((PsiScopeProcessor)processor2, state, (PsiElement)reference, (PsiElement)reference);
                return processor2.getResult();
            }
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public static boolean canBeConstructed(@NotNull PsiClass psiClass) {
        return !psiClass.isEnum() && !psiClass.hasModifierProperty("abstract") && !(psiClass instanceof PsiTypeParameter);
    }

    private static boolean isLocatedInStaticContext(@NotNull PsiClass containingClass, @NotNull PsiMethodReferenceExpression reference) {
        PsiClass gContainingClass = containingClass.getContainingClass();
        if (gContainingClass == null || !containingClass.hasModifierProperty("static")) {
            PsiClass aClass = null;
            if (PsiTreeUtil.isAncestor((PsiElement)(gContainingClass != null ? gContainingClass : containingClass), (PsiElement)reference, (boolean)false)) {
                aClass = gContainingClass != null ? gContainingClass : containingClass;
            }
            return PsiUtil.getEnclosingStaticElement((PsiElement)reference, aClass) != null;
        }
        return false;
    }

    protected PsiConflictResolver createResolver(@NotNull PsiMethodReferenceExpressionImpl referenceExpression, @NotNull PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable PsiMethod interfaceMethod, @Nullable MethodSignature signature) {
        return new MethodReferenceConflictResolver(referenceExpression, qualifierResolveResult, signature, interfaceMethod);
    }

    @NotNull
    private static PsiClassType composeReturnType(@NotNull PsiClass containingClass, @NotNull PsiSubstitutor substitutor) {
        boolean isRawSubst = PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)substitutor);
        return JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor);
    }

    private static boolean arrayCreationSignature(@NotNull MethodSignature signature) {
        PsiType[] parameterTypes = signature.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0] != null && TypeConversionUtil.isAssignable((PsiType)PsiType.INT, (PsiType)parameterTypes[0]);
    }

    private static class MethodReferenceConflictResolver
    extends JavaMethodsConflictResolver {
        private final MethodSignature mySignature;
        private final PsiMethod myInterfaceMethod;
        private final PsiMethodReferenceExpressionImpl myReferenceExpression;
        private final PsiMethodReferenceUtil.QualifierResolveResult myQualifierResolveResult;
        private final boolean myFunctionalMethodVarArgs;

        private MethodReferenceConflictResolver(@NotNull PsiMethodReferenceExpressionImpl referenceExpression, @NotNull PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable MethodSignature signature, @Nullable PsiMethod interfaceMethod) {
            super((PsiElement)referenceExpression, signature != null ? signature.getParameterTypes() : PsiType.EMPTY_ARRAY, PsiUtil.getLanguageLevel((PsiElement)referenceExpression), referenceExpression.getContainingFile());
            this.myReferenceExpression = referenceExpression;
            this.myQualifierResolveResult = qualifierResolveResult;
            this.myFunctionalMethodVarArgs = interfaceMethod != null && interfaceMethod.isVarArgs();
            this.mySignature = signature;
            this.myInterfaceMethod = interfaceMethod;
        }

        @Override
        protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict) {
            return conflict.isVarargs() ? 2 : 3;
        }

        @Override
        @Nullable
        protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
            CandidateInfo candidateInfo;
            if (this.mySignature == null) {
                return null;
            }
            if (conflicts.isEmpty()) {
                return null;
            }
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            this.checkSameSignatures(conflicts);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            MethodReferenceConflictResolver.checkAccessStaticLevels(conflicts, true);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
            PsiType[] argTypes = this.mySignature.getParameterTypes();
            boolean hasReceiver = PsiMethodReferenceUtil.isSecondSearchPossible((PsiType[])argTypes, (PsiMethodReferenceUtil.QualifierResolveResult)this.myQualifierResolveResult, (PsiMethodReferenceExpression)this.myReferenceExpression);
            ArrayList<CandidateInfo> firstCandidates = new ArrayList<CandidateInfo>();
            ArrayList<CandidateInfo> secondCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo conflict : conflicts) {
                Boolean applicableByFirstSearch;
                if (!(conflict instanceof MethodCandidateInfo) || (applicableByFirstSearch = MethodReferenceConflictResolver.isApplicableByFirstSearch(conflict, argTypes, hasReceiver, this.myReferenceExpression, this.myFunctionalMethodVarArgs, this.myInterfaceMethod)) == null) continue;
                (applicableByFirstSearch != false ? firstCandidates : secondCandidates).add(conflict);
            }
            if (this.myQualifierResolveResult.isReferenceTypeQualified() && this.myReferenceExpression.getReferenceNameElement() instanceof PsiIdentifier) {
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(firstCandidates, secondCandidates, true);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(secondCandidates, firstCandidates, false);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
            }
            if ((candidateInfo = this.resolveConflicts(firstCandidates, secondCandidates, 3)) != null) {
                return candidateInfo;
            }
            candidateInfo = this.resolveConflicts(firstCandidates, secondCandidates, 2);
            if (candidateInfo != null) {
                return candidateInfo;
            }
            if (firstCandidates.isEmpty() && secondCandidates.isEmpty()) {
                return null;
            }
            conflicts.clear();
            firstCandidates.addAll(secondCandidates);
            conflicts.addAll(firstCandidates);
            return null;
        }

        private static Boolean isApplicableByFirstSearch(@NotNull CandidateInfo conflict, PsiType @NotNull [] functionalInterfaceParamTypes, boolean hasReceiver, @NotNull PsiMethodReferenceExpression referenceExpression, boolean functionalMethodVarArgs, PsiMethod interfaceMethod) {
            PsiMethod psiMethod = ((MethodCandidateInfo)conflict).getElement();
            PsiSubstitutor substitutor = ((MethodCandidateInfo)conflict).getSubstitutor(false);
            if (((MethodCandidateInfo)conflict).getInferenceErrorMessage() != null) {
                return null;
            }
            PsiType[] parameterTypes = psiMethod.getSignature(substitutor).getParameterTypes();
            boolean varargs = ((MethodCandidateInfo)conflict).isVarargs();
            if (varargs && (!psiMethod.isVarArgs() || functionalMethodVarArgs)) {
                return null;
            }
            if ((varargs || functionalInterfaceParamTypes.length == parameterTypes.length) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes, functionalInterfaceParamTypes, interfaceMethod, varargs, conflict, 0)) {
                PsiClass containingClass;
                if (psiMethod.hasModifierProperty("static") && (containingClass = psiMethod.getContainingClass()) != null && containingClass.isInterface()) {
                    PsiClass qualifierClass = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)referenceExpression).getContainingClass();
                    if (!containingClass.getManager().areElementsEquivalent((PsiElement)qualifierClass, (PsiElement)containingClass)) {
                        return null;
                    }
                }
                return true;
            }
            if (hasReceiver && (varargs || functionalInterfaceParamTypes.length == parameterTypes.length + 1) && MethodReferenceConflictResolver.isCorrectAssignment(parameterTypes, functionalInterfaceParamTypes, interfaceMethod, varargs, conflict, 1)) {
                return false;
            }
            return null;
        }

        private static boolean isCorrectAssignment(PsiType @NotNull [] parameterTypes, PsiType @NotNull [] functionalInterfaceParamTypes, PsiMethod interfaceMethod, boolean varargs, @NotNull CandidateInfo conflict, int offset) {
            int min = Math.min(parameterTypes.length, functionalInterfaceParamTypes.length - offset);
            for (int i = 0; i < min; ++i) {
                PsiType argType = PsiUtil.captureToplevelWildcards((PsiType)functionalInterfaceParamTypes[i + offset], (PsiElement)interfaceMethod.getParameterList().getParameters()[i]);
                PsiType parameterType = parameterTypes[i];
                if (varargs && i == parameterTypes.length - 1) {
                    if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)argType) || TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)parameterType).getComponentType(), (PsiType)argType)) continue;
                    MethodReferenceConflictResolver.markNotApplicable(conflict);
                    return false;
                }
                if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)argType)) continue;
                MethodReferenceConflictResolver.markNotApplicable(conflict);
                return false;
            }
            return !varargs || parameterTypes.length - 1 <= functionalInterfaceParamTypes.length - offset;
        }

        private static void markNotApplicable(@NotNull CandidateInfo conflict) {
            if (conflict instanceof MethodCandidateInfo) {
                ((MethodCandidateInfo)conflict).markNotApplicable();
            }
        }

        private CandidateInfo resolveConflicts(@NotNull List<CandidateInfo> firstCandidates, @NotNull List<CandidateInfo> secondCandidates, int applicabilityLevel) {
            int firstApplicability = this.checkApplicability(firstCandidates);
            this.checkSpecifics(firstCandidates, applicabilityLevel);
            int secondApplicability = this.checkApplicability(secondCandidates);
            this.checkSpecifics(secondCandidates, applicabilityLevel, null, 1);
            if (firstApplicability < secondApplicability) {
                return secondCandidates.size() == 1 ? secondCandidates.get(0) : null;
            }
            if (secondApplicability < firstApplicability) {
                return firstCandidates.size() == 1 ? firstCandidates.get(0) : null;
            }
            return firstCandidates.size() + secondCandidates.size() == 1 ? (firstCandidates.isEmpty() ? secondCandidates.get(0) : firstCandidates.get(0)) : null;
        }

        @Override
        protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
            if (method == conflict) {
                return true;
            }
            PsiElement psiElement = method.getElement();
            PsiElement conflictElement = conflict.getElement();
            if (psiElement instanceof PsiMethod && conflictElement instanceof PsiMethod) {
                return fixedArity && ((PsiMethod)psiElement).getParameterList().getParametersCount() != ((PsiMethod)conflictElement).getParameterList().getParametersCount();
            }
            return false;
        }

        private static CandidateInfo filterStaticCorrectCandidates(@NotNull List<CandidateInfo> firstCandidates, @NotNull List<CandidateInfo> secondCandidates, boolean shouldBeStatic) {
            boolean isStatic;
            CandidateInfo candidateInfo;
            PsiElement element;
            if (firstCandidates.size() == 1 && (element = (candidateInfo = firstCandidates.get(0)).getElement()) instanceof PsiMethod && shouldBeStatic == (isStatic = ((PsiMethod)element).hasModifierProperty("static"))) {
                for (CandidateInfo secondCandidate : secondCandidates) {
                    boolean oppositeStatic;
                    PsiElement psiElement = secondCandidate.getElement();
                    if (!(psiElement instanceof PsiMethod) || shouldBeStatic == (oppositeStatic = ((PsiMethod)psiElement).hasModifierProperty("static"))) continue;
                    return null;
                }
                return candidateInfo;
            }
            return null;
        }
    }
}

