/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JavaSourceUtil {
    private static final Logger LOG = Logger.getInstance(JavaSourceUtil.class);
    private static final TokenSet REF_FILTER = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaElementType.ANNOTATION})});

    private JavaSourceUtil() {
    }

    public static void fullyQualifyReference(@NotNull CompositeElement reference, @NotNull PsiClass targetClass) {
        if (((SourceJavaCodeReference)reference).isQualified()) {
            PsiClass parentClass = targetClass.getContainingClass();
            if (parentClass == null) {
                return;
            }
            ASTNode qualifier = reference.findChildByRole(54);
            if (qualifier instanceof SourceJavaCodeReference) {
                ((SourceJavaCodeReference)qualifier).fullyQualify(parentClass);
            }
        } else {
            String qName = targetClass.getQualifiedName();
            if (qName == null) {
                return;
            }
            int i = qName.lastIndexOf(46);
            if (i > 0) {
                String prefix = qName.substring(0, i);
                PsiManagerEx manager = reference.getManager();
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)manager.getProject()).getParserFacade();
                TreeElement qualifier = reference instanceof PsiReferenceExpression ? (TreeElement)parserFacade.createExpressionFromText(prefix, null).getNode() : (TreeElement)parserFacade.createReferenceFromText(prefix, null).getNode();
                if (qualifier != null) {
                    CharTable systemCharTab = SharedImplUtil.findCharTableByTree((ASTNode)qualifier);
                    LeafElement dot = Factory.createSingleLeafElement((IElementType)JavaTokenType.DOT, (CharSequence)".", (int)0, (int)1, (CharTable)systemCharTab, (PsiManager)manager);
                    qualifier.rawInsertAfterMe((TreeElement)dot);
                    reference.addInternal(qualifier, (ASTNode)dot, null, Boolean.FALSE);
                }
            }
        }
    }

    @NotNull
    public static String getReferenceText(@NotNull PsiJavaCodeReferenceElement ref) {
        final StringBuilder buffer = new StringBuilder();
        ((TreeElement)ref.getNode()).acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor(){

            public void visitLeaf(LeafElement leaf) {
                if (!REF_FILTER.contains(leaf.getElementType())) {
                    char lastInBuffer;
                    String leafText = leaf.getText();
                    if (buffer.length() > 0 && !leafText.isEmpty() && Character.isJavaIdentifierPart(leafText.charAt(0)) && ((lastInBuffer = buffer.charAt(buffer.length() - 1)) == '?' || Character.isJavaIdentifierPart(lastInBuffer))) {
                        buffer.append(" ");
                    }
                    buffer.append(leafText);
                }
            }

            public void visitComposite(CompositeElement composite) {
                if (!REF_FILTER.contains(composite.getElementType())) {
                    super.visitComposite(composite);
                }
            }
        });
        return buffer.toString();
    }

    @NotNull
    public static String getReferenceText(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        return LightTreeUtil.toFilteredString((LighterAST)tree, (LighterASTNode)node, (TokenSet)REF_FILTER);
    }

    @NotNull
    public static TreeElement addParenthToReplacedChild(@NotNull ASTNode child, @NotNull TreeElement newChild, @NotNull PsiManager manager) {
        boolean needParenth;
        boolean bl = needParenth = ElementType.EXPRESSION_BIT_SET.contains(child.getElementType()) && ElementType.EXPRESSION_BIT_SET.contains(newChild.getElementType()) && ReplaceExpressionUtil.isNeedParenthesis(child, (ASTNode)newChild);
        if (!needParenth) {
            return newChild;
        }
        CompositeElement parenthExpr = ASTFactory.composite((IElementType)JavaElementType.PARENTH_EXPRESSION);
        TreeElement dummyExpr = (TreeElement)newChild.clone();
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)newChild);
        new DummyHolder(manager, (TreeElement)parenthExpr, null, charTableByTree);
        parenthExpr.putUserData(CharTable.CHAR_TABLE_KEY, (Object)charTableByTree);
        parenthExpr.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)JavaTokenType.LPARENTH, (CharSequence)"("));
        parenthExpr.rawAddChildren(dummyExpr);
        parenthExpr.rawAddChildren((TreeElement)ASTFactory.leaf((IElementType)JavaTokenType.RPARENTH, (CharSequence)")"));
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            PsiElement formatted = codeStyleManager.reformat(SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)parenthExpr));
            parenthExpr = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull((PsiElement)formatted);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        newChild.putUserData(CharTable.CHAR_TABLE_KEY, (Object)SharedImplUtil.findCharTableByTree((ASTNode)newChild));
        dummyExpr.getTreeParent().replaceChild((ASTNode)dummyExpr, (ASTNode)newChild);
        TreeUtil.clearCaches((TreeElement)TreeUtil.getFileElement((TreeElement)parenthExpr));
        return parenthExpr;
    }

    public static void deleteSeparatingComma(@NotNull CompositeElement element, @NotNull ASTNode child) {
        assert (child.getElementType() != JavaTokenType.COMMA) : child;
        ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
        if (next != null && next.getElementType() == JavaTokenType.COMMA) {
            element.deleteChildInternal(next);
        } else {
            ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
            if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
                element.deleteChildInternal(prev);
            }
        }
    }

    public static void addSeparatingComma(@NotNull CompositeElement element, @NotNull ASTNode child, @NotNull TokenSet listTypes) {
        assert (child.getElementType() != JavaTokenType.COMMA) : child;
        JavaSourceUtil.scanChildren(element, child, listTypes, true);
        JavaSourceUtil.scanChildren(element, child, listTypes, false);
    }

    private static void scanChildren(CompositeElement element, ASTNode node, TokenSet listTypes, boolean forward) {
        block1: {
            ASTNode child = node;
            do {
                ASTNode aSTNode = child = forward ? child.getTreeNext() : child.getTreePrev();
                if (child == null || child.getElementType() == JavaTokenType.COMMA) break block1;
            } while (!listTypes.contains(child.getElementType()));
            CharTable charTable = SharedImplUtil.findCharTableByTree((ASTNode)element);
            PsiManager manager = element.getPsi().getManager();
            LeafElement comma = Factory.createSingleLeafElement((IElementType)JavaTokenType.COMMA, (CharSequence)",", (int)0, (int)1, (CharTable)charTable, (PsiManager)manager);
            element.addInternal((TreeElement)comma, (ASTNode)comma, forward ? node : child, Boolean.FALSE);
        }
    }
}

