/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PathListReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        return this.getReferencesByElement(element);
    }

    protected boolean disableNonSlashedPaths() {
        return true;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element) {
        Object[] refs;
        Object[] result = PsiReference.EMPTY_ARRAY;
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        String s = range.substring(element.getText());
        int offset = range.getStartOffset();
        if (this.disableNonSlashedPaths() && !s.trim().startsWith("/")) {
            return result;
        }
        int pos = -1;
        char separator = this.getSeparator();
        while (true) {
            int nextPos;
            if ((nextPos = s.indexOf(separator, pos + 1)) == -1) break;
            refs = this.createReferences(element, s.substring(pos + 1, nextPos), pos + offset + 1, false);
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])refs);
            pos = nextPos;
        }
        refs = this.createReferences(element, s.substring(pos + 1), pos + offset + 1, false);
        result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])refs);
        return result;
    }

    protected char getSeparator() {
        return ',';
    }

    protected PsiReference @NotNull [] createReferences(@NotNull PsiElement element, String s, int offset, final boolean soft) {
        int contentOffset = StringUtil.findFirst((CharSequence)s, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        if (contentOffset >= 0) {
            offset += contentOffset;
        }
        return new FileReferenceSet(s.trim(), element, offset, this, true){

            protected boolean isSoft() {
                return soft;
            }
        }.getAllReferences();
    }
}

