/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceSet {
    public static final char DOT = '.';
    public static final char DOLLAR = '$';
    public static final char LT = '<';
    public static final char GT = '>';
    public static final char COMMA = ',';
    public static final char QUESTION = '?';
    public static final String EXTENDS = "extends";
    public static final String SUPER = "super";
    private JavaClassReference[] myReferences;
    private List<JavaClassReferenceSet> myNestedGenericParameterReferences;
    private JavaClassReferenceSet myContext;
    private PsiElement myElement;
    private final int myStartInElement;
    private final JavaClassReferenceProvider myProvider;

    public JavaClassReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, boolean isStatic, @NotNull JavaClassReferenceProvider provider) {
        this(str, element, startInElement, isStatic, provider, null);
    }

    private JavaClassReferenceSet(@NotNull String str, @NotNull PsiElement element, int startInElement, boolean isStatic, @NotNull JavaClassReferenceProvider provider, JavaClassReferenceSet context) {
        this.myStartInElement = startInElement;
        this.myProvider = provider;
        this.reparse(str, element, isStatic, context);
    }

    @NotNull
    public JavaClassReferenceProvider getProvider() {
        return this.myProvider;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiReference[] references = this.getReferences();
        return new TextRange(references[0].getRangeInElement().getStartOffset(), references[references.length - 1].getRangeInElement().getEndOffset());
    }

    private void reparse(@NotNull String str, @NotNull PsiElement element, boolean isStaticImport, JavaClassReferenceSet context) {
        this.myElement = element;
        this.myContext = context;
        ArrayList<JavaClassReference> referencesList = new ArrayList<JavaClassReference>();
        int currentDot = -1;
        int referenceIndex = 0;
        boolean allowDollarInNames = this.isAllowDollarInNames();
        boolean allowSpaces = this.isAllowSpaces();
        boolean allowGenerics = false;
        boolean allowWildCards = JavaClassReferenceProvider.ALLOW_WILDCARDS.getBooleanValue(this.getOptions());
        boolean allowGenericsCalculated = false;
        boolean parsingClassNames = true;
        while (parsingClassNames) {
            char ch;
            int nextDotOrDollar = -1;
            for (int curIndex = currentDot + 1; curIndex < str.length(); ++curIndex) {
                ch = str.charAt(curIndex);
                if (ch == '.' || ch == '$' && allowDollarInNames) {
                    nextDotOrDollar = curIndex;
                    break;
                }
                if (ch != '<' && ch != ',') continue;
                if (!allowGenericsCalculated) {
                    allowGenerics = !isStaticImport && PsiUtil.isLanguageLevel5OrHigher((PsiElement)element);
                    allowGenericsCalculated = true;
                }
                if (!allowGenerics) continue;
                nextDotOrDollar = curIndex;
                break;
            }
            if (nextDotOrDollar == -1) {
                for (int i = nextDotOrDollar = currentDot + 1; i < str.length() && Character.isJavaIdentifierPart(str.charAt(i)); ++i) {
                    ++nextDotOrDollar;
                }
                parsingClassNames = false;
                int j = JavaClassReferenceSet.skipSpaces(nextDotOrDollar, str.length(), str, allowSpaces);
                if (j < str.length()) {
                    ch = str.charAt(j);
                    boolean recognized = false;
                    if (ch == '[' && (j = JavaClassReferenceSet.skipSpaces(j + 1, str.length(), str, allowSpaces)) < str.length() && str.charAt(j) == ']') {
                        recognized = (j = JavaClassReferenceSet.skipSpaces(j + 1, str.length(), str, allowSpaces)) == str.length();
                    }
                    Boolean aBoolean = (Boolean)JavaClassReferenceProvider.JVM_FORMAT.getValue(this.getOptions());
                    if (!(recognized || aBoolean != null && aBoolean.booleanValue())) {
                        nextDotOrDollar = -1;
                    }
                }
            }
            if (nextDotOrDollar != -1 && nextDotOrDollar < str.length()) {
                char c = str.charAt(nextDotOrDollar);
                if (c == '<') {
                    boolean recognized = false;
                    int start = JavaClassReferenceSet.skipSpaces(nextDotOrDollar + 1, str.length(), str, allowSpaces);
                    int j = str.lastIndexOf(62);
                    int end = JavaClassReferenceSet.skipSpacesBackward(j, 0, str, allowSpaces);
                    if (end != -1 && end > start) {
                        if (this.myNestedGenericParameterReferences == null) {
                            this.myNestedGenericParameterReferences = new ArrayList<JavaClassReferenceSet>(1);
                        }
                        this.myNestedGenericParameterReferences.add(new JavaClassReferenceSet(str.substring(start, end), this.myElement, this.myStartInElement + start, isStaticImport, this.myProvider, this));
                        parsingClassNames = false;
                        j = JavaClassReferenceSet.skipSpaces(j + 1, str.length(), str, allowSpaces);
                        boolean bl = recognized = j == str.length();
                    }
                    if (!recognized) {
                        nextDotOrDollar = -1;
                    }
                } else if (c == ',' && this.myContext != null) {
                    if (this.myContext.myNestedGenericParameterReferences == null) {
                        this.myContext.myNestedGenericParameterReferences = new ArrayList<JavaClassReferenceSet>(1);
                    }
                    int start = JavaClassReferenceSet.skipSpaces(nextDotOrDollar + 1, str.length(), str, allowSpaces);
                    this.myContext.myNestedGenericParameterReferences.add(new JavaClassReferenceSet(str.substring(start), this.myElement, this.myStartInElement + start, isStaticImport, this.myProvider, this));
                    parsingClassNames = false;
                }
            }
            int maxIndex = nextDotOrDollar > 0 ? nextDotOrDollar : str.length();
            int beginIndex = JavaClassReferenceSet.skipSpaces(currentDot + 1, maxIndex, str, allowSpaces);
            int endIndex = JavaClassReferenceSet.skipSpacesBackward(maxIndex, beginIndex, str, allowSpaces);
            boolean skipReference = false;
            if (allowWildCards && str.charAt(beginIndex) == '?') {
                int next = JavaClassReferenceSet.skipSpaces(beginIndex + 1, endIndex, str, allowSpaces);
                if (next != beginIndex + 1) {
                    String keyword;
                    String string = str.startsWith(EXTENDS, next) ? EXTENDS : (keyword = str.startsWith(SUPER, next) ? SUPER : null);
                    if (keyword != null) {
                        beginIndex = next = JavaClassReferenceSet.skipSpaces(next + keyword.length(), endIndex, str, allowSpaces);
                    }
                } else if (endIndex == beginIndex + 1) {
                    skipReference = true;
                }
            }
            if (!skipReference) {
                TextRange textRange = TextRange.create((int)(this.myStartInElement + beginIndex), (int)(this.myStartInElement + endIndex));
                JavaClassReference currentContextRef = this.createReference(referenceIndex, str.substring(beginIndex, endIndex), textRange, isStaticImport);
                ++referenceIndex;
                referencesList.add(currentContextRef);
            }
            if ((currentDot = nextDotOrDollar) >= 0) continue;
            break;
        }
        this.myReferences = referencesList.toArray(new JavaClassReference[0]);
    }

    private static int skipSpaces(int pos, int max, @NotNull String str, boolean allowSpaces) {
        while (allowSpaces && pos < max && Character.isWhitespace(str.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private static int skipSpacesBackward(int pos, int min, @NotNull String str, boolean allowSpaces) {
        while (allowSpaces && pos > min && Character.isWhitespace(str.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    @NotNull
    protected JavaClassReference createReference(int referenceIndex, @NotNull String referenceText, @NotNull TextRange textRange, boolean staticImport) {
        return new JavaClassReference(this, textRange, referenceIndex, referenceText, staticImport);
    }

    public boolean isAllowDollarInNames() {
        Boolean aBoolean = this.myProvider.getOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES);
        return !Boolean.FALSE.equals(aBoolean) && this.myElement.getLanguage() instanceof XMLLanguage;
    }

    public boolean isAllowSpaces() {
        return true;
    }

    protected boolean isStaticSeparator(char c, boolean strict) {
        return this.isAllowDollarInNames() ? c == '$' : c == '.';
    }

    public void reparse(@NotNull PsiElement element, @NotNull TextRange range) {
        String text2 = range.substring(element.getText());
        this.reparse(text2, element, false, this.myContext);
    }

    public JavaClassReference getReference(int index) {
        return this.myReferences[index];
    }

    public JavaClassReference @NotNull [] getAllReferences() {
        JavaClassReference[] result = this.myReferences;
        if (this.myNestedGenericParameterReferences != null) {
            for (JavaClassReferenceSet set : this.myNestedGenericParameterReferences) {
                result = (JavaClassReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])set.getAllReferences());
            }
        }
        return result;
    }

    public boolean canReferencePackage(int index) {
        int endOffset;
        if (index == this.myReferences.length - 1) {
            return false;
        }
        String text2 = this.getElement().getText();
        return !StringUtil.isChar((CharSequence)text2, (int)(endOffset = this.myReferences[index].getRangeInElement().getEndOffset()), (char)'$');
    }

    public boolean isSoft() {
        return this.myProvider.isSoft();
    }

    @NotNull
    public PsiElement getElement() {
        return this.myElement;
    }

    public PsiReference @NotNull [] getReferences() {
        return this.myReferences;
    }

    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myProvider.getOptions();
    }

    @NotNull
    public String getUnresolvedMessagePattern(int index) {
        if (this.canReferencePackage(index)) {
            return JavaErrorBundle.message("error.cannot.resolve.class.or.package", new Object[0]);
        }
        return JavaErrorBundle.message("error.cannot.resolve.class", new Object[0]);
    }
}

