/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.CustomizableReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.GenericReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassKind;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassReferenceProvider
extends GenericReferenceProvider
implements CustomizableReferenceProvider {
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> RESOLVE_QUALIFIED_CLASS_NAME = new CustomizableReferenceProvider.CustomizationKey("RESOLVE_QUALIFIED_CLASS_NAME");
    public static final CustomizableReferenceProvider.CustomizationKey<List<String>> SUPER_CLASSES = new CustomizableReferenceProvider.CustomizationKey("SUPER_CLASSES");
    public static final CustomizableReferenceProvider.CustomizationKey<List<String>> IMPORTS = new CustomizableReferenceProvider.CustomizationKey("IMPORTS");
    public static final CustomizableReferenceProvider.CustomizationKey<String> CLASS_TEMPLATE = new CustomizableReferenceProvider.CustomizationKey("CLASS_TEMPLATE");
    public static final CustomizableReferenceProvider.CustomizationKey<ClassKind> CLASS_KIND = new CustomizableReferenceProvider.CustomizationKey("CLASS_KIND");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> INSTANTIATABLE = new CustomizableReferenceProvider.CustomizationKey("INSTANTIATABLE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> CONCRETE = new CustomizableReferenceProvider.CustomizationKey("CONCRETE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> NOT_INTERFACE = new CustomizableReferenceProvider.CustomizationKey("NOT_INTERFACE");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> NOT_ENUM = new CustomizableReferenceProvider.CustomizationKey("NOT_ENUM");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ADVANCED_RESOLVE = new CustomizableReferenceProvider.CustomizationKey("RESOLVE_ONLY_CLASSES");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> JVM_FORMAT = new CustomizableReferenceProvider.CustomizationKey("JVM_FORMAT");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ALLOW_DOLLAR_NAMES = new CustomizableReferenceProvider.CustomizationKey("ALLOW_DOLLAR_NAMES");
    public static final CustomizableReferenceProvider.CustomizationKey<Boolean> ALLOW_WILDCARDS = new CustomizableReferenceProvider.CustomizationKey("ALLOW_WILDCARDS");
    @Deprecated
    public static final CustomizableReferenceProvider.CustomizationKey<String[]> EXTEND_CLASS_NAMES = new CustomizableReferenceProvider.CustomizationKey("EXTEND_CLASS_NAMES");
    @Deprecated
    public static final CustomizableReferenceProvider.CustomizationKey<String> DEFAULT_PACKAGE = new CustomizableReferenceProvider.CustomizationKey("DEFAULT_PACKAGE");
    @Nullable
    private Map<CustomizableReferenceProvider.CustomizationKey, Object> myOptions;
    private boolean myAllowEmpty;
    private static final ParameterizedCachedValueProvider<List<PsiPackage>, Project> ourPackagesProvider = project -> {
        PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        PsiPackage root = JavaPsiFacade.getInstance((Project)project).findPackage("");
        List psiPackages = root == null ? Collections.emptyList() : ContainerUtil.filter((Object[])root.getSubPackages(), p -> nameHelper.isIdentifier(p.getName(), PsiUtil.getLanguageLevel((PsiElement)p)));
        return CachedValueProvider.Result.createSingleDependency((Object)psiPackages, (Object)PsiModificationTracker.MODIFICATION_COUNT);
    };
    private static final Key<ParameterizedCachedValue<List<PsiPackage>, Project>> ourPackagesKey = Key.create((String)"default packages");

    public <T> void setOption(CustomizableReferenceProvider.CustomizationKey<T> option, T value2) {
        if (this.myOptions == null) {
            this.myOptions = new THashMap();
        }
        if (option == EXTEND_CLASS_NAMES) {
            SUPER_CLASSES.putValue(this.myOptions, (Object)ContainerUtil.immutableList((Object[])((String[])value2)));
        } else if (option == DEFAULT_PACKAGE) {
            IMPORTS.putValue(this.myOptions, Collections.singletonList((String)value2));
        } else {
            option.putValue(this.myOptions, value2);
        }
    }

    @Nullable
    public <T> T getOption(@NotNull CustomizableReferenceProvider.CustomizationKey<T> option) {
        return (T)(this.myOptions == null ? null : option.getValue(this.myOptions));
    }

    @Nullable
    public GlobalSearchScope getScope(@NotNull Project project) {
        return null;
    }

    @NotNull
    public PsiFile getContextFile(@NotNull PsiElement element) {
        return element.getContainingFile();
    }

    @Nullable
    public PsiClass getContextClass(@NotNull PsiElement element) {
        return null;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        return this.getReferencesByElement(element);
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element) {
        int offsetInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        String text2 = ElementManipulators.getValueText((PsiElement)element);
        return this.getReferencesByString(text2, element, offsetInElement);
    }

    public PsiReference @NotNull [] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
        if (this.myAllowEmpty && StringUtil.isEmpty((String)str)) {
            return PsiReference.EMPTY_ARRAY;
        }
        boolean allowDollars = Boolean.TRUE.equals(this.getOption(ALLOW_DOLLAR_NAMES));
        return new JavaClassReferenceSet(str, position, offsetInPosition, allowDollars, this).getAllReferences();
    }

    @Override
    public void handleEmptyContext(PsiScopeProcessor processor2, PsiElement position) {
        ElementClassHint hint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (position == null) {
            return;
        }
        if (hint == null || hint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE) || hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            List<PsiPackage> cachedPackages = JavaClassReferenceProvider.getDefaultPackages(position.getProject());
            for (PsiElement psiElement : cachedPackages) {
                if (processor2.execute(psiElement, ResolveState.initial())) continue;
                return;
            }
        }
    }

    @NotNull
    static List<PsiPackage> getDefaultPackages(@NotNull Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)project, ourPackagesKey, ourPackagesProvider, false, (Object)project);
    }

    public void setOptions(@Nullable Map<CustomizableReferenceProvider.CustomizationKey, Object> options) {
        this.myOptions = options;
    }

    @Nullable
    public Map<CustomizableReferenceProvider.CustomizationKey, Object> getOptions() {
        return this.myOptions;
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
    }
}

