/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtomicReferenceImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final Set<String> ourUpdateMethods = ContainerUtil.set((Object[])new String[]{"compareAndSet", "weakCompareAndSet", "set", "lazySet", "getAndSet", "getAndIncrement", "getAndDecrement", "getAndAdd", "incrementAndGet", "decrementAndGet", "addAndGet", "getAndUpdate", "updateAndGet", "getAndAccumulate", "accumulateAndGet"});

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        PsiField field;
        if (element instanceof PsiField && (field = (PsiField)element).hasModifierProperty("volatile")) {
            return (Boolean)CachedValuesManager.getCachedValue((PsiElement)field, () -> new CachedValueProvider.Result((Object)AtomicReferenceImplicitUsageProvider.isAtomicWrite(field), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        }
        return false;
    }

    private static boolean isAtomicWrite(@NotNull PsiField field) {
        PsiType type2 = field.getType();
        if (PsiType.INT.equals((Object)type2)) {
            return AtomicReferenceImplicitUsageProvider.isAtomicWrite(field, "java.util.concurrent.atomic.AtomicIntegerFieldUpdater");
        }
        if (PsiType.LONG.equals((Object)type2)) {
            return AtomicReferenceImplicitUsageProvider.isAtomicWrite(field, "java.util.concurrent.atomic.AtomicLongFieldUpdater");
        }
        if (!(type2 instanceof PsiPrimitiveType)) {
            return AtomicReferenceImplicitUsageProvider.isAtomicWrite(field, "java.util.concurrent.atomic.AtomicReferenceFieldUpdater");
        }
        return false;
    }

    private static boolean isAtomicWrite(@NotNull PsiField field, @NonNls String updaterName) {
        SearchScope scope = AtomicReferenceImplicitUsageProvider.getCheapSearchScope(field);
        if (scope == null) {
            return false;
        }
        Query fieldQuery = ReferencesSearch.search((PsiElement)field, (SearchScope)scope);
        return !fieldQuery.forEach(reference -> AtomicReferenceImplicitUsageProvider.findAtomicUpdaters(reference, updaterName));
    }

    private static boolean findAtomicUpdaters(@NotNull PsiReference reference, @NotNull String updaterName) {
        Query updaterQuery;
        PsiElement resolved;
        PsiExpression lExpression;
        PsiAssignmentExpression assignment;
        if (!(reference instanceof JavaLangClassMemberReference)) {
            return true;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiMethodCallExpression.class);
        if (methodCall == null || !JavaReflectionReferenceUtil.isCallToMethod(methodCall, updaterName, "newUpdater")) {
            return true;
        }
        PsiElement callParent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        PsiVariable updaterVariable = null;
        if (callParent instanceof PsiVariable && PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiVariable)callParent).getInitializer()) == methodCall) {
            updaterVariable = (PsiVariable)callParent;
        } else if (callParent instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)callParent).getOperationTokenType() == JavaTokenType.EQ && PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()) == methodCall && (lExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression())) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
            updaterVariable = (PsiVariable)resolved;
        }
        return updaterVariable == null || !InheritanceUtil.isInheritor((PsiType)updaterVariable.getType(), (String)updaterName) || (updaterQuery = ReferencesSearch.search((PsiElement)updaterVariable)).forEach(AtomicReferenceImplicitUsageProvider::findWrites);
    }

    private static boolean findWrites(@NotNull PsiReference reference) {
        PsiElement element = reference.getElement();
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent()), PsiReferenceExpression.class);
        return methodExpression == null || !(methodExpression instanceof PsiMethodReferenceExpression) && !(methodExpression.getParent() instanceof PsiMethodCallExpression) || !ourUpdateMethods.contains(methodExpression.getReferenceName()) || PsiUtil.skipParenthesizedExprDown((PsiExpression)methodExpression.getQualifierExpression()) != element;
    }

    @Nullable
    private static SearchScope getCheapSearchScope(@NotNull PsiField field) {
        SearchScope scope = field.getUseScope();
        if (scope instanceof LocalSearchScope) {
            return scope;
        }
        String name2 = field.getName();
        Project project = field.getProject();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        if (scope instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(name2, (GlobalSearchScope)scope, null, null) == PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) {
            return scope;
        }
        return null;
    }
}

