/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.LambdaExpressionCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.PsiMethodReferenceCompatibilityConstraint;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExpressionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;

    public ExpressionCompatibilityConstraint(@NotNull PsiExpression expression2, @NotNull PsiType type2) {
        super(type2);
        this.myExpression = expression2;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        PsiExpression expression3;
        PsiType myT = this.getCurrentType();
        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)this.myExpression)) {
            PsiType exprType = this.myExpression.getType();
            if (session.isProperType(myT)) {
                boolean assignmentCompatible;
                boolean bl = assignmentCompatible = exprType == null || TypeConversionUtil.isAssignable((PsiType)myT, (PsiType)exprType);
                if (!assignmentCompatible) {
                    PsiType type2 = this.myExpression.getType();
                    session.registerIncompatibleErrorMessage((type2 != null ? type2.getPresentableText() : this.myExpression.getText()) + " is not compatible with " + session.getPresentableText(myT));
                } else if (TypeCompatibilityConstraint.isUncheckedConversion(myT, exprType, session) && !JavaGenericsUtil.isReifiableType((PsiType)myT)) {
                    session.setErased();
                }
                return assignmentCompatible;
            }
            if (exprType instanceof PsiLambdaParameterType) {
                return false;
            }
            if (exprType instanceof PsiClassType && ((PsiClassType)exprType).resolve() == null) {
                return true;
            }
            if (exprType != null && exprType != PsiType.NULL) {
                if (exprType instanceof PsiDisjunctionType) {
                    exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
                }
                constraints.add(new TypeCompatibilityConstraint(myT, exprType));
            }
            return true;
        }
        if (this.myExpression instanceof PsiParenthesizedExpression && (expression3 = ((PsiParenthesizedExpression)this.myExpression).getExpression()) != null && !InferenceSession.ignoreLambdaConstraintTree(expression3)) {
            constraints.add(new ExpressionCompatibilityConstraint(expression3, myT));
            return true;
        }
        if (this.myExpression instanceof PsiConditionalExpression) {
            PsiExpression elseExpression2;
            PsiExpression thenExpression2 = ((PsiConditionalExpression)this.myExpression).getThenExpression();
            if (thenExpression2 != null && !InferenceSession.ignoreLambdaConstraintTree(thenExpression2)) {
                constraints.add(new ExpressionCompatibilityConstraint(thenExpression2, myT));
            }
            if ((elseExpression2 = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null && !InferenceSession.ignoreLambdaConstraintTree(elseExpression2)) {
                constraints.add(new ExpressionCompatibilityConstraint(elseExpression2, myT));
            }
            return true;
        }
        if (this.myExpression instanceof PsiSwitchExpression) {
            PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)((PsiSwitchExpression)this.myExpression)).forEach(expression2 -> {
                if (!InferenceSession.ignoreLambdaConstraintTree(expression2)) {
                    constraints.add(new ExpressionCompatibilityConstraint((PsiExpression)expression2, myT));
                }
            });
            return true;
        }
        if (this.myExpression instanceof PsiCall) {
            InferenceSession callSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, this.myExpression, myT, true);
            if (callSession == null) {
                return false;
            }
            if (callSession != session) {
                MethodCandidateInfo resolveResult;
                session.getInferenceSessionContainer().registerNestedSession(callSession);
                session.propagateVariables(callSession);
                for (Pair<InferenceVariable[], PsiClassType> pair2 : callSession.myIncorporationPhase.getCaptures()) {
                    session.myIncorporationPhase.addCapture((InferenceVariable[])pair2.first, (PsiClassType)pair2.second);
                }
                MethodCandidateInfo currentMethod = session.getCurrentMethod(((PsiCall)this.myExpression).getArgumentList());
                Object object = resolveResult = currentMethod != null ? currentMethod : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((PsiCall)this.myExpression));
                if (resolveResult instanceof MethodCandidateInfo && callSession.isErased()) {
                    resolveResult.setErased();
                }
            }
            return true;
        }
        if (this.myExpression instanceof PsiMethodReferenceExpression) {
            constraints.add(new PsiMethodReferenceCompatibilityConstraint((PsiMethodReferenceExpression)this.myExpression, myT));
            return true;
        }
        if (this.myExpression instanceof PsiLambdaExpression) {
            constraints.add(new LambdaExpressionCompatibilityConstraint((PsiLambdaExpression)this.myExpression, myT));
            return true;
        }
        return true;
    }

    public static InferenceSession reduceExpressionCompatibilityConstraint(InferenceSession session, PsiExpression expression2, PsiType targetType, boolean registerErrorOnFailure) {
        if (!PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression2)) {
            return session;
        }
        PsiExpressionList argumentList = ((PsiCall)expression2).getArgumentList();
        if (argumentList != null) {
            PsiMethod method;
            JavaResolveResult resolveResult;
            MethodCandidateInfo currentMethod = session.getCurrentMethod(argumentList);
            PsiType returnType = null;
            Object[] typeParams = null;
            JavaResolveResult javaResolveResult = resolveResult = currentMethod != null ? null : PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((PsiCall)expression2));
            Object object = currentMethod != null ? currentMethod.getElement() : (method = resolveResult instanceof MethodCandidateInfo ? ((MethodCandidateInfo)resolveResult).getElement() : null);
            if (method != null && !method.isConstructor()) {
                returnType = method.getReturnType();
                typeParams = method.getTypeParameters();
            } else if (resolveResult != null) {
                PsiClass psiClass;
                PsiClass psiClass2 = psiClass = method != null ? method.getContainingClass() : (PsiClass)resolveResult.getElement();
                if (psiClass != null) {
                    returnType = JavaPsiFacade.getElementFactory((Project)argumentList.getProject()).createType(psiClass, PsiSubstitutor.EMPTY);
                    typeParams = psiClass.getTypeParameters();
                    if (method != null && method.hasTypeParameters()) {
                        typeParams = (PsiTypeParameter[])ArrayUtil.mergeArrays((Object[])typeParams, (Object[])method.getTypeParameters());
                    }
                }
            } else {
                return session;
            }
            if (typeParams != null) {
                List<String> messages;
                PsiSubstitutor siteSubstitutor = InferenceSession.chooseSiteSubstitutor(currentMethod, resolveResult, method);
                InferenceSession callSession = new InferenceSession((PsiTypeParameter[])typeParams, siteSubstitutor, expression2.getManager(), (PsiElement)expression2, session.getInferencePolicy());
                callSession.propagateVariables(session);
                if (method != null) {
                    PsiExpression[] args = argumentList.getExpressions();
                    PsiParameter[] parameters2 = method.getParameterList().getParameters();
                    callSession.initExpressionConstraints(parameters2, args, method, InferenceSession.chooseVarargsMode(currentMethod, resolveResult));
                }
                if (callSession.repeatInferencePhases()) {
                    if (PsiType.VOID.equals((Object)targetType)) {
                        return callSession;
                    }
                    if (returnType != null) {
                        callSession.registerReturnTypeConstraints(siteSubstitutor.substitute(returnType), targetType, (PsiElement)expression2);
                    }
                    if (callSession.repeatInferencePhases()) {
                        if (callSession.isErased() && !JavaGenericsUtil.isReifiableType((PsiType)targetType) && session.getInferenceVariable(targetType) == null) {
                            session.setErased();
                        }
                        return callSession;
                    }
                }
                if ((messages = callSession.getIncompatibleErrorMessages()) != null) {
                    for (String message2 : messages) {
                        session.registerIncompatibleErrorMessage(message2);
                    }
                }
                return null;
            }
            if (registerErrorOnFailure) {
                session.registerIncompatibleErrorMessage("Failed to resolve argument");
                return null;
            }
        }
        return session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionCompatibilityConstraint that = (ExpressionCompatibilityConstraint)o;
        return this.myExpression.equals(that.myExpression);
    }

    public int hashCode() {
        return this.myExpression.hashCode();
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type2, PsiExpression expression2) {
        return new ExpressionCompatibilityConstraint(expression2, type2);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<? super InferenceVariable> result) {
        if (psiExpression instanceof PsiLambdaExpression && !PsiType.VOID.equals((Object)returnType)) {
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)psiExpression));
            for (PsiExpression expression2 : returnExpressions) {
                Set<InferenceVariable> resultInputVars = this.createSelfConstraint(returnType, expression2).getInputVariables(session);
                if (resultInputVars == null) continue;
                result.addAll(resultInputVars);
            }
        }
    }
}

