/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProcessCandidateParameterTypeInferencePolicy
extends DefaultParameterTypeInferencePolicy {
    public static final ProcessCandidateParameterTypeInferencePolicy INSTANCE = new ProcessCandidateParameterTypeInferencePolicy();

    public Pair<PsiType, ConstraintType> inferTypeConstraintFromCallContext(PsiExpression innerMethodCall, PsiExpressionList expressionList, @NotNull PsiCallExpression contextCall, PsiTypeParameter typeParameter) {
        Object[] expressions2 = expressionList.getExpressions();
        PsiExpression parent = innerMethodCall;
        while (parent.getParent() instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        int i = ArrayUtilRt.find((Object[])expressions2, (Object)parent);
        if (i < 0) {
            return null;
        }
        PsiMethod owner2 = (PsiMethod)typeParameter.getOwner();
        if (owner2 == null) {
            return null;
        }
        try {
            JavaResolveResult[] results = this.getResults(contextCall, i);
            PsiType innerReturnType = owner2.getReturnType();
            for (JavaResolveResult result : results) {
                PsiSubstitutor substitutor;
                Pair<PsiType, ConstraintType> constraint;
                if (result == null || (constraint = ProcessCandidateParameterTypeInferencePolicy.inferConstraint(typeParameter, innerMethodCall, i, innerReturnType, result, substitutor = this.getSubstitutor(contextCall, (PsiExpression[])expressions2, i, result))) == null) continue;
                return constraint;
            }
        }
        catch (MethodProcessorSetupFailedException ev) {
            return null;
        }
        return null;
    }

    protected PsiSubstitutor getSubstitutor(PsiCallExpression contextCall, PsiExpression[] expressions2, int i, JavaResolveResult result) {
        if (result instanceof MethodCandidateInfo) {
            List<PsiExpression> leftArgs = this.getExpressions(expressions2, i);
            return ((MethodCandidateInfo)result).inferSubstitutorFromArgs((ParameterTypeInferencePolicy)this, leftArgs.toArray(PsiExpression.EMPTY_ARRAY));
        }
        return result.getSubstitutor();
    }

    protected List<PsiExpression> getExpressions(PsiExpression[] expressions2, int i) {
        return Arrays.asList(expressions2).subList(0, i);
    }

    protected static Pair<PsiType, ConstraintType> inferConstraint(PsiTypeParameter typeParameter, PsiExpression innerMethodCall, int parameterIdx, PsiType innerReturnType, JavaResolveResult result, PsiSubstitutor substitutor) {
        PsiElement element = result.getElement();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiParameter parameter2 = null;
            if (parameters2.length > parameterIdx) {
                parameter2 = parameters2[parameterIdx];
            } else if (method.isVarArgs()) {
                parameter2 = parameters2[parameters2.length - 1];
            }
            if (parameter2 != null) {
                PsiParameter finalParameter = parameter2;
                PsiType type2 = (PsiType)PsiResolveHelper.ourGuard.doPreventingRecursion((Object)innerMethodCall, true, () -> substitutor.substitute(finalParameter.getType()));
                LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)finalParameter);
                Pair<PsiType, ConstraintType> constraint = new PsiOldInferenceHelper(element.getManager()).getSubstitutionForTypeParameterConstraint(typeParameter, innerReturnType, type2, false, languageLevel);
                if (constraint != null) {
                    return constraint;
                }
            }
        }
        return null;
    }

    protected JavaResolveResult @NotNull [] getResults(@NotNull PsiCallExpression contextCall, int exprIdx) throws MethodProcessorSetupFailedException {
        PsiFile containingFile = contextCall.getContainingFile();
        MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor((PsiElement)contextCall, containingFile);
        PsiScopesUtil.setupAndRunProcessor(processor2, contextCall, false);
        return processor2.getResult();
    }
}

