/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiRequiresStatementStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import org.jetbrains.annotations.NotNull;

public class PsiRequiresStatementImpl
extends JavaStubPsiElement<PsiRequiresStatementStub>
implements PsiRequiresStatement {
    private SoftReference<PsiJavaModuleReference> myReference;

    public PsiRequiresStatementImpl(@NotNull PsiRequiresStatementStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.REQUIRES_STATEMENT);
    }

    public PsiRequiresStatementImpl(@NotNull ASTNode node) {
        super(node);
    }

    public PsiJavaModuleReferenceElement getReferenceElement() {
        return (PsiJavaModuleReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)this, PsiJavaModuleReferenceElement.class);
    }

    public String getModuleName() {
        PsiRequiresStatementStub stub = (PsiRequiresStatementStub)this.getGreenStub();
        if (stub != null) {
            return StringUtil.nullize((String)stub.getModuleName());
        }
        PsiJavaModuleReferenceElement refElement = this.getReferenceElement();
        return refElement != null ? refElement.getReferenceText() : null;
    }

    public PsiJavaModuleReference getModuleReference() {
        PsiRequiresStatementStub stub = (PsiRequiresStatementStub)this.getStub();
        if (stub != null) {
            String refText = StringUtil.nullize((String)stub.getModuleName());
            if (refText == null) {
                return null;
            }
            PsiJavaModuleReference ref = (PsiJavaModuleReference)SoftReference.dereference(this.myReference);
            if (ref == null) {
                ref = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade().createModuleReferenceFromText(refText, (PsiElement)this).getReference();
                this.myReference = new SoftReference((Object)ref);
            }
            return ref;
        }
        this.myReference = null;
        PsiJavaModuleReferenceElement refElement = this.getReferenceElement();
        return refElement != null ? refElement.getReference() : null;
    }

    public PsiModifierList getModifierList() {
        return (PsiModifierList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name2);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitRequiresStatement((PsiRequiresStatement)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiRequiresStatement";
    }
}

