/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiLabelReference
implements PsiReference {
    private final PsiStatement myStatement;
    private PsiIdentifier myIdentifier;

    public PsiLabelReference(PsiStatement stat, PsiIdentifier identifier) {
        this.myStatement = stat;
        this.myIdentifier = identifier;
    }

    @NotNull
    public PsiElement getElement() {
        return this.myStatement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int start = this.myIdentifier.getStartOffsetInParent();
        return new TextRange(start, this.myIdentifier.getTextLength() + start);
    }

    public PsiElement resolve() {
        String label = this.myIdentifier.getText();
        for (PsiStatement context = this.myStatement; context != null; context = context.getContext()) {
            if (!(context instanceof PsiLabeledStatement) || !label.equals(((PsiLabeledStatement)context).getName())) continue;
            return context;
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        return this.getElement().getText();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        this.myIdentifier = (PsiIdentifier)PsiImplUtil.setName((PsiElement)this.myIdentifier, newElementName);
        return this.myIdentifier;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (!(element instanceof PsiLabeledStatement)) {
            throw new IncorrectOperationException("Can't bind to non-labeled statement");
        }
        return this.handleElementRename(((PsiLabeledStatement)element).getName());
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        return this.resolve() == element;
    }

    public String @NotNull [] getVariants() {
        return ArrayUtil.toStringArray(PsiImplUtil.findAllEnclosingLabels((PsiElement)this.myStatement));
    }

    public boolean isSoft() {
        return false;
    }
}

