/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImpl
extends JavaStubPsiElement<PsiClassStub<?>>
implements PsiExtensibleClass,
Queryable {
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);
    private volatile String myCachedName;

    public PsiClassImpl(PsiClassStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.CLASS);
    }

    protected PsiClassImpl(PsiClassStub stub, IStubElementType type2) {
        super(stub, type2);
        this.addTrace(null);
    }

    public PsiClassImpl(ASTNode node) {
        super(node);
        this.addTrace(null);
    }

    private void addTrace(@Nullable PsiClassStub stub) {
        if (ourTraceStubAstBinding) {
            String creationTrace = "Creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            if (stub != null) {
                String stubTrace;
                creationTrace = creationTrace + "\nfrom stub " + stub + "@" + System.identityHashCode(stub) + "\n";
                if (stub instanceof UserDataHolder && (stubTrace = (String)((UserDataHolder)stub).getUserData(CREATION_TRACE)) != null) {
                    creationTrace = creationTrace + stubTrace;
                }
            }
            this.putUserData(CREATION_TRACE, creationTrace);
        }
    }

    public void subtreeChanged() {
        this.dropCaches();
        super.subtreeChanged();
    }

    private void dropCaches() {
        this.myCachedName = null;
    }

    @Override
    protected Object clone() {
        PsiClassImpl clone = (PsiClassImpl)super.clone();
        clone.dropCaches();
        return clone;
    }

    public PsiElement getOriginalElement() {
        return (PsiElement)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(this.getProject());
            PsiClassImpl result = helper != null ? helper.getOriginalClass(this) : this;
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    public CompositeElement getNode() {
        return (CompositeElement)super.getNode();
    }

    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    public PsiElement getScope() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        CompositeElement treeElement = this.getNode();
        for (ASTNode parent = treeElement.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!(parent.getElementType() instanceof IStubElementType)) continue;
            return parent.getPsi();
        }
        return this.getContainingFile();
    }

    public String getName() {
        PsiIdentifier identifier;
        String name2 = this.myCachedName;
        if (name2 != null) {
            return name2;
        }
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        name2 = stub == null ? ((identifier = this.getNameIdentifier()) == null ? null : identifier.getText()) : stub.getName();
        this.myCachedName = name2;
        return name2;
    }

    public String getQualifiedName() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PsiJavaFile) {
            return StringUtil.getQualifiedName((String)((PsiJavaFile)parent).getPackageName(), (String)StringUtil.notNullize((String)this.getName()));
        }
        if (parent instanceof PsiClass) {
            String parentQName = ((PsiClass)parent).getQualifiedName();
            if (parentQName == null) {
                return null;
            }
            return StringUtil.getQualifiedName((String)parentQName, (String)StringUtil.notNullize((String)this.getName()));
        }
        return null;
    }

    public PsiModifierList getModifierList() {
        return (PsiModifierList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name2) {
        PsiModifierList modlist = this.getModifierList();
        return modlist != null && modlist.hasModifierProperty(name2);
    }

    public PsiReferenceList getExtendsList() {
        return (PsiReferenceList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.EXTENDS_LIST);
    }

    public PsiReferenceList getImplementsList() {
        return (PsiReferenceList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.IMPLEMENTS_LIST);
    }

    public PsiClassType @NotNull [] getExtendsListTypes() {
        return PsiClassImplUtil.getExtendsListTypes(this);
    }

    public PsiClassType @NotNull [] getImplementsListTypes() {
        return PsiClassImplUtil.getImplementsListTypes(this);
    }

    @Nullable
    public PsiReferenceList getPermitsList() {
        return (PsiReferenceList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.PERMITS_LIST);
    }

    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    public PsiClass @NotNull [] getInterfaces() {
        return PsiClassImplUtil.getInterfaces(this);
    }

    public PsiClass @NotNull [] getSupers() {
        return PsiClassImplUtil.getSupers(this);
    }

    public PsiClassType @NotNull [] getSuperTypes() {
        return PsiClassImplUtil.getSuperTypes(this);
    }

    @Nullable
    public PsiClass getContainingClass() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            StubElement parent = stub.getParentStub();
            return parent instanceof PsiClassStub ? (PsiClass)((PsiClassStub)parent).getPsi() : null;
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClassLevelDeclarationStatement) {
            return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
        }
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    public PsiElement getContext() {
        return this.getContext(null);
    }

    public PsiElement getContext(@Nullable String referenceName) {
        StubElement parent;
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub == null) {
            return this.getParent();
        }
        if (referenceName == null) {
            return super.getContext();
        }
        for (parent = stub.getParentStub(); parent != null && !(parent instanceof PsiClassStub) && !(parent instanceof PsiFileStub); parent = parent.getParentStub()) {
            Object[] allLocalClasses = (PsiClass[])parent.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (allLocalClasses.length > 0 && ContainerUtil.exists((Object[])allLocalClasses, c -> referenceName.equals(c.getName()))) {
                return this.getParent();
            }
            if (!(parent instanceof PsiMethodStub)) continue;
            return parent.getPsi();
        }
        return parent != null ? parent.getPsi() : this.getParent();
    }

    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        return PsiSuperMethodImplUtil.getVisibleSignatures(this);
    }

    public PsiField @NotNull [] getFields() {
        return this.myInnersCache.getFields();
    }

    public PsiMethod @NotNull [] getMethods() {
        return this.myInnersCache.getMethods();
    }

    public PsiMethod @NotNull [] getConstructors() {
        return this.myInnersCache.getConstructors();
    }

    public PsiClass @NotNull [] getInnerClasses() {
        return this.myInnersCache.getInnerClasses();
    }

    public PsiRecordComponent @NotNull [] getRecordComponents() {
        return this.myInnersCache.getRecordComponents();
    }

    @Nullable
    public PsiRecordHeader getRecordHeader() {
        return (PsiRecordHeader)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.RECORD_HEADER);
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        return Arrays.asList(this.getStubOrPsiChildren(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        return Arrays.asList(this.getStubOrPsiChildren(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        return Arrays.asList(this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY));
    }

    public PsiClassInitializer @NotNull [] getInitializers() {
        return (PsiClassInitializer[])this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.CLASS_INITIALIZER, PsiClassInitializer.ARRAY_FACTORY);
    }

    public PsiTypeParameter @NotNull [] getTypeParameters() {
        return PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
    }

    public PsiField @NotNull [] getAllFields() {
        return PsiClassImplUtil.getAllFields(this);
    }

    public PsiMethod @NotNull [] getAllMethods() {
        return PsiClassImplUtil.getAllMethods(this);
    }

    public PsiClass @NotNull [] getAllInnerClasses() {
        return PsiClassImplUtil.getAllInnerClasses(this);
    }

    public PsiField findFieldByName(String name2, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name2, checkBases);
    }

    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
    }

    public PsiMethod @NotNull [] findMethodsByName(String name2, boolean checkBases) {
        return this.myInnersCache.findMethodsByName(name2, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name2, boolean checkBases) {
        return PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name2, checkBases);
    }

    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        return PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
    }

    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name2, checkBases);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)this.getRequiredStubOrPsiChild((IStubElementType)JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    public PsiDocComment getDocComment() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null && !stub.hasDocComment()) {
            return null;
        }
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(18);
    }

    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(19);
    }

    public boolean isInterface() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isInterface();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.INTERFACE_KEYWORD;
    }

    public boolean isAnnotationType() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAnnotationType();
        }
        return this.getNode().findChildByRole(247) != null;
    }

    public boolean isEnum() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isEnum();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.ENUM_KEYWORD;
    }

    public boolean isRecord() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isRecord();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.RECORD_KEYWORD;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitClass((PsiClass)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiClass:" + this.getName();
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)place);
        return PsiClassImplUtil.processDeclarationsInClass(this, processor2, state, null, lastParent, place, level, false);
    }

    public PsiElement setName(@NotNull String newName) throws IncorrectOperationException {
        String oldName = this.getName();
        boolean isRenameFile = this.isRenameFileOnRenaming();
        PsiImplUtil.setName((PsiElement)Objects.requireNonNull(this.getNameIdentifier()), newName);
        if (isRenameFile) {
            PsiFile file;
            String fileName = (file = (PsiFile)this.getParent()).getName();
            int dotIndex = fileName.lastIndexOf(46);
            file.setName(dotIndex >= 0 ? newName + "." + fileName.substring(dotIndex + 1) : newName);
        }
        for (PsiMethod method : this.getMethods()) {
            if (!method.isConstructor() || !method.getName().equals(oldName)) continue;
            method.setName(newName);
        }
        return this;
    }

    private boolean isRenameFileOnRenaming() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiFile) {
            PsiFile file = (PsiFile)parent;
            String fileName = file.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String name2 = dotIndex >= 0 ? fileName.substring(0, dotIndex) : fileName;
            String oldName = this.getName();
            return name2.equals(oldName);
        }
        return false;
    }

    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @NotNull
    public SearchScope getUseScope() {
        return PsiClassImplUtil.getClassUseScope(this);
    }

    public void putInfo(@NotNull Map<String, String> info) {
        PsiClassImpl.putInfo(this, info);
    }

    public static void putInfo(@NotNull PsiClass psiClass, @NotNull Map<String, String> info) {
        info.put("className", psiClass.getName());
        info.put("qualifiedClassName", psiClass.getQualifiedName());
        PsiFile file = psiClass.getContainingFile();
        if (file instanceof Queryable) {
            ((Queryable)file).putInfo(info);
        }
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return this.myInnersCache.getValuesMethod();
    }
}

